/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import java.awt.Color;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import tv.soaryn.xycraft.core.content.CustomColors;

public class ColorUtils {
    public static int getColorFromDyeNoCorrection(DyeColor color) {
        float[] rgbFloats = color.m_41068_();
        return 0xFF000000 | (int)(rgbFloats[0] * 255.0f) << 16 | (int)(rgbFloats[1] * 255.0f) << 8 | (int)(rgbFloats[2] * 255.0f);
    }

    public static int getColorFromDye(DyeColor color) {
        float[] rgbFloats = color.m_41068_();
        Vec3 rgb = new Vec3((double)rgbFloats[0], (double)rgbFloats[1], (double)rgbFloats[2]);
        if (color == DyeColor.LIGHT_BLUE) {
            rgb = ColorUtils.convertRGBToComponents(6459135);
        }
        return ColorUtils.convertComponentsToRGB(rgb);
    }

    public static int getColorTime(int offset) {
        return ColorUtils.getColorTime(offset, 10000);
    }

    public static int getColorTime(int offset, int speed) {
        return Color.HSBtoRGB((float)((System.currentTimeMillis() + (long)offset) % (long)speed) / (float)speed, 1.0f, 1.0f);
    }

    public static Vec3 convertRGBToComponents(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Vec3((double)r, (double)g, (double)b);
    }

    public static int convertComponentsToRGB(Vec3 color) {
        return 0xFF000000 | (int)(color.f_82479_ * 255.0) << 16 | (int)(color.f_82480_ * 255.0) << 8 | (int)(color.f_82481_ * 255.0);
    }

    public static int multiply(int color, float intensity) {
        Vec3 rgb = ColorUtils.convertRGBToComponents(color).m_82542_((double)intensity, (double)intensity, (double)intensity);
        return ColorUtils.convertComponentsToRGB(rgb);
    }

    public static Vec3i toVec3i(Vec3 vector) {
        return new Vec3i(vector.f_82479_, vector.f_82480_, vector.f_82481_);
    }

    public static MaterialColor getMaterialColor(CustomColors color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case CustomColors.Blue -> MaterialColor.f_76361_;
            case CustomColors.Red -> MaterialColor.f_76364_;
            case CustomColors.Green -> MaterialColor.f_76363_;
            case CustomColors.Light -> MaterialColor.f_76372_;
            case CustomColors.Dark -> MaterialColor.f_76419_;
        };
    }
}

