/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.dimension.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import earth.terrarium.ad_astra.client.dimension.renderer.SkyUtil;
import earth.terrarium.ad_astra.client.resourcepack.PlanetSkyRenderer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModSkyRenderer {
    private final PlanetSkyRenderer.StarsRenderer starsRenderer;
    private final PlanetSkyRenderer.SunsetColour sunsetColour;
    private final List<PlanetSkyRenderer.SkyObject> skyObjects;
    private final int horizonAngle;
    private final boolean shouldRenderWhileRaining;
    private VertexBuffer starsBuffer;
    private int starsCount;

    public ModSkyRenderer(PlanetSkyRenderer skyRenderer) {
        this.starsRenderer = skyRenderer.starsRenderer();
        this.sunsetColour = skyRenderer.sunsetColour();
        this.skyObjects = skyRenderer.skyObjects();
        this.horizonAngle = skyRenderer.horizonAngle();
        this.shouldRenderWhileRaining = !skyRenderer.weatherEffects().equals((Object)PlanetSkyRenderer.WeatherEffects.NONE);
    }

    public void render(ClientLevel level, int ticks, float tickDelta, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean foggy) {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Minecraft minecraft = Minecraft.m_91087_();
        if (this.shouldRenderWhileRaining && level.m_46471_()) {
            return;
        }
        if (SkyUtil.isSubmerged(camera)) {
            return;
        }
        SkyUtil.preRender(level, minecraft.f_91060_, camera, projectionMatrix, bufferBuilder, this.sunsetColour, this.horizonAngle, poseStack, tickDelta);
        if (this.starsRenderer.fastStars() > 0) {
            int stars = !((GraphicsStatus)minecraft.f_91066_.m_232060_().m_231551_()).equals((Object)GraphicsStatus.FAST) ? this.starsRenderer.fancyStars() : this.starsRenderer.fastStars();
            this.starsBuffer = this.renderStars(level, poseStack, tickDelta, bufferBuilder, stars, this.starsRenderer, projectionMatrix);
        }
        for (PlanetSkyRenderer.SkyObject skyObject : this.skyObjects) {
            float scale = skyObject.scale();
            Vector3f rotation = skyObject.rotation();
            switch (skyObject.renderType()) {
                case STATIC: {
                    break;
                }
                case DYNAMIC: {
                    rotation = new Vector3f(level.m_46942_(tickDelta) * 360.0f + rotation.m_122239_(), rotation.m_122260_(), rotation.m_122269_());
                    break;
                }
                case SCALING: {
                    scale *= SkyUtil.getScale();
                    break;
                }
                case DEBUG: {
                    rotation = new Vector3f(60.0f, 0.0f, 0.0f);
                }
            }
            SkyUtil.render(poseStack, bufferBuilder, skyObject.texture(), skyObject.colour(), rotation, scale, skyObject.blending());
        }
        SkyUtil.postRender(minecraft.f_91063_, level, tickDelta);
    }

    private VertexBuffer renderStars(ClientLevel level, PoseStack poseStack, float tickDelta, BufferBuilder bufferBuilder, int stars, PlanetSkyRenderer.StarsRenderer starsRenderer, Matrix4f projectionMatrix) {
        SkyUtil.startRendering(poseStack, new Vector3f(-30.0f, 0.0f, level.m_46942_(tickDelta) * 360.0f));
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        this.createStarBuffer(bufferBuilder, stars);
        if (!starsRenderer.daylightVisible()) {
            float rot = level.m_104811_(tickDelta);
            RenderSystem.m_157429_((float)rot, (float)rot, (float)rot, (float)rot);
        } else {
            RenderSystem.m_157429_((float)0.8f, (float)0.8f, (float)0.8f, (float)0.8f);
        }
        FogRenderer.m_109017_();
        this.starsBuffer.m_85921_();
        this.starsBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
        poseStack.m_85849_();
        return this.starsBuffer;
    }

    private void createStarBuffer(BufferBuilder bufferBuilder, int stars) {
        if (this.starsBuffer != null) {
            if (this.starsCount == stars) {
                return;
            }
            this.starsBuffer.close();
        }
        this.starsBuffer = new VertexBuffer();
        this.starsCount = stars;
        BufferBuilder.RenderedBuffer renderedBuffer = SkyUtil.renderStars(bufferBuilder, stars, this.starsRenderer.colouredStars());
        this.starsBuffer.m_85921_();
        this.starsBuffer.m_231221_(renderedBuffer);
        VertexBuffer.m_85931_();
    }
}

