/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity.vehicle;

import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import earth.terrarium.ad_astra.common.screen.LanderMenuProvider;
import earth.terrarium.ad_astra.common.util.ModKeyBindings;
import earth.terrarium.ad_astra.common.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.Vec3;

public class Lander
extends Vehicle {
    public Lander(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Override
    public int getInventorySize() {
        return 11;
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        super.m_6096_(player, hand);
        this.openInventory(player, new LanderMenuProvider(this));
        return InteractionResult.SUCCESS;
    }

    @Override
    public double m_6048_() {
        return super.m_6048_() + 2.0;
    }

    @Override
    public void drop() {
        Containers.m_19002_((Level)this.f_19853_, (BlockPos)this.m_20183_(), (Container)this.getInventory());
        super.drop();
    }

    @Override
    public boolean shouldRenderPlayer() {
        return false;
    }

    @Override
    public boolean doHighFov() {
        return true;
    }

    @Override
    public boolean fullyConcealsRider() {
        return true;
    }

    @Override
    public boolean canRiderTakeFallDamage() {
        return false;
    }

    @Override
    public boolean renderPlanetBar() {
        return true;
    }

    @Override
    public void doGravity() {
        if (!(this.f_19853_.m_8055_(this.m_20097_()).m_60734_() instanceof LiquidBlock)) {
            super.doGravity();
        } else {
            Vec3 velocity = this.m_20184_();
            this.m_20334_(velocity.m_7096_(), Math.max(0.1, velocity.m_7098_() + 0.03), velocity.m_7094_());
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.m_20096_() && ModKeyBindings.jumpKeyDown(player)) {
                this.applyBoosters();
            }
        }
    }

    public void applyBoosters() {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.1, 0.0));
        if (this.m_20184_().m_7098_() > VehiclesConfig.LanderConfig.boosterThreshold) {
            this.m_20334_(0.0, VehiclesConfig.LanderConfig.boosterThreshold, 0.0);
        }
        if (!this.f_19853_.f_46443_) {
            ModUtils.spawnForcedParticles((ServerLevel)this.m_9236_(), ParticleTypes.f_123764_, this.m_20185_(), this.m_20186_() - 0.3, this.m_20189_(), 3, 0.1, 0.1, 0.1, 0.001);
        }
    }

    @Override
    public boolean cautionForDismount(Entity passenger) {
        if (!this.m_20096_()) {
            return true;
        }
        return super.cautionForDismount(passenger);
    }
}

