/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.datagen.builder;

import com.thevortex.allthemodium.datagen.RecipeException;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class ShapedArmorBuilder {
    private final String criteriaName;
    private final InventoryChangeTrigger.TriggerInstance criterion;
    private final EnumMap<Slot, Item> pieces = new EnumMap(Slot.class);
    private final TagKey<Item> ingot;
    private Item core;

    public ShapedArmorBuilder(TagKey<Item> ingot) {
        this.ingot = ingot;
        this.criteriaName = String.format("has_%s_ingot", ingot);
        ItemPredicate predicate = ItemPredicate.Builder.m_45068_().m_204145_(ingot).m_45077_();
        this.criterion = InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{predicate});
    }

    public static ShapedArmorBuilder builder(TagKey<Item> ingot) {
        return new ShapedArmorBuilder(ingot);
    }

    public ShapedArmorBuilder setHelmet(RegistryObject<ArmorItem> object) {
        this.pieces.put(Slot.HELMET, (Item)object.get());
        return this;
    }

    public ShapedArmorBuilder setChestplate(RegistryObject<ArmorItem> object) {
        this.pieces.put(Slot.CHESTPLATE, (Item)object.get());
        return this;
    }

    public ShapedArmorBuilder setLeggings(RegistryObject<ArmorItem> object) {
        this.pieces.put(Slot.LEGGINGS, (Item)object.get());
        return this;
    }

    public ShapedArmorBuilder setBoots(RegistryObject<ArmorItem> object) {
        this.pieces.put(Slot.BOOTS, (Item)object.get());
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.pieces.isEmpty()) {
            throw new RecipeException(id.toString(), "recipe must have at least 1 output");
        }
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        Consumer<ShapedRecipeBuilder> register = builder -> builder.m_176498_(consumer);
        Optional.ofNullable(this.pieces.get((Object)Slot.HELMET)).map(this::helmet).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.CHESTPLATE)).map(this::chestplate).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.LEGGINGS)).map(this::leggings).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.BOOTS)).map(this::boots).map(this::addCriterion).ifPresent(register);
    }

    private ShapedRecipeBuilder shaped(ItemLike provider) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)provider).m_126145_("allthemodium");
    }

    private ShapedRecipeBuilder addCriterion(ShapedRecipeBuilder builder) {
        return builder.m_206416_(Character.valueOf('a'), this.ingot).m_126132_(this.criteriaName, (CriterionTriggerInstance)this.criterion);
    }

    private ShapedRecipeBuilder helmet(ItemLike provider) {
        return this.shaped(provider).m_126130_("aaa").m_126130_("a a").m_126130_("   ");
    }

    private ShapedRecipeBuilder chestplate(ItemLike provider) {
        return this.shaped(provider).m_126130_("a a").m_126130_("aaa").m_126130_("aaa");
    }

    private ShapedRecipeBuilder leggings(ItemLike provider) {
        return this.shaped(provider).m_126130_("aaa").m_126130_("a a").m_126130_("a a");
    }

    private ShapedRecipeBuilder boots(ItemLike provider) {
        return this.shaped(provider).m_126130_("a a").m_126130_("a a").m_126130_("   ");
    }

    public static enum Slot {
        HELMET,
        CHESTPLATE,
        LEGGINGS,
        BOOTS;


        public String lower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

