/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.registry;

import alexthw.ars_elemental.common.entity.FirenandoEntity;
import alexthw.ars_elemental.common.entity.MermaidEntity;
import alexthw.ars_elemental.common.entity.familiars.FirenandoFamiliar;
import alexthw.ars_elemental.common.entity.familiars.MermaidFamiliar;
import alexthw.ars_elemental.common.entity.mages.AirMage;
import alexthw.ars_elemental.common.entity.mages.EarthMage;
import alexthw.ars_elemental.common.entity.mages.EntityMageBase;
import alexthw.ars_elemental.common.entity.mages.FireMage;
import alexthw.ars_elemental.common.entity.mages.WaterMage;
import alexthw.ars_elemental.common.entity.spells.EntityCurvedProjectile;
import alexthw.ars_elemental.common.entity.spells.EntityHomingProjectile;
import alexthw.ars_elemental.common.entity.spells.EntityLerpedProjectile;
import alexthw.ars_elemental.common.entity.spells.EntityMagnetSpell;
import alexthw.ars_elemental.common.entity.spells.FlashLightning;
import alexthw.ars_elemental.common.entity.summon.AllyVhexEntity;
import alexthw.ars_elemental.common.entity.summon.SummonDirewolf;
import alexthw.ars_elemental.common.entity.summon.SummonDolphin;
import alexthw.ars_elemental.common.entity.summon.SummonSkeleHorse;
import alexthw.ars_elemental.common.entity.summon.SummonStrider;
import alexthw.ars_elemental.common.entity.summon.SummonUndead;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.WealdWalker;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDelay;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWindshear;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="ars_elemental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"ars_elemental");
    public static final RegistryObject<EntityType<MermaidEntity>> SIREN_ENTITY = ModEntities.registerEntity("siren_entity", 0.4f, 1.0f, MermaidEntity::new, MobCategory.WATER_CREATURE);
    public static final RegistryObject<EntityType<MermaidFamiliar>> SIREN_FAMILIAR = ModEntities.registerEntity("siren_familiar", 0.4f, 1.0f, MermaidFamiliar::new, MobCategory.WATER_CREATURE);
    public static final RegistryObject<EntityType<FirenandoEntity>> FIRENANDO_ENTITY = ModEntities.addEntity("firenando_entity", 1.0f, 2.2f, true, false, FirenandoEntity::new, MobCategory.CREATURE);
    public static final RegistryObject<EntityType<FirenandoFamiliar>> FIRENANDO_FAMILIAR = ModEntities.addEntity("firenando_familiar", 1.0f, 1.8f, true, false, FirenandoFamiliar::new, MobCategory.CREATURE);
    public static final RegistryObject<EntityType<WealdWalker>> FLASHING_WEALD_WALKER;
    public static final RegistryObject<EntityType<EntityMageBase>> FIRE_MAGE;
    public static final RegistryObject<EntityType<EntityMageBase>> WATER_MAGE;
    public static final RegistryObject<EntityType<EntityMageBase>> AIR_MAGE;
    public static final RegistryObject<EntityType<EntityMageBase>> EARTH_MAGE;
    public static final RegistryObject<EntityType<SummonSkeleHorse>> SKELEHORSE_SUMMON;
    public static final RegistryObject<EntityType<SummonDirewolf>> DIREWOLF_SUMMON;
    public static final RegistryObject<EntityType<SummonUndead>> WSKELETON_SUMMON;
    public static final RegistryObject<EntityType<SummonDolphin>> DOLPHIN_SUMMON;
    public static final RegistryObject<EntityType<SummonStrider>> STRIDER_SUMMON;
    public static final RegistryObject<EntityType<AllyVhexEntity>> VHEX_SUMMON;
    public static final RegistryObject<EntityType<EntityHomingProjectile>> HOMING_PROJECTILE;
    public static final RegistryObject<EntityType<EntityCurvedProjectile>> CURVED_PROJECTILE;
    public static final RegistryObject<EntityType<EntityMagnetSpell>> LINGER_MAGNET;
    public static final RegistryObject<EntityType<EntityLerpedProjectile>> LERP_PROJECTILE;
    public static final RegistryObject<EntityType<FlashLightning>> FLASH_LIGHTNING;

    static <T extends Entity> RegistryObject<EntityType<T>> registerEntity(String name, float width, float height, EntityType.EntityFactory<T> factory, MobCategory kind) {
        return ENTITIES.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)kind).setTrackingRange(16).m_20699_(width, height).m_20712_("ars_elemental:" + name));
    }

    static <T extends Entity> RegistryObject<EntityType<T>> addEntity(String name, float width, float height, boolean fire, boolean noSave, EntityType.EntityFactory<T> factory, MobCategory kind) {
        return ENTITIES.register(name, () -> {
            EntityType.Builder builder = EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)kind).setTrackingRange(32).m_20699_(width, height);
            if (noSave) {
                builder.m_20716_();
            }
            if (fire) {
                builder.m_20719_();
            }
            return builder.m_20712_("ars_elemental:" + name);
        });
    }

    @SubscribeEvent
    public static void registerSP(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)SIREN_ENTITY.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (p_186238_, p_186239_, p_186240_, p_186241_, p_186242_) -> MermaidEntity.checkSurfaceWaterAnimalSpawnRules((LevelAccessor)p_186239_, p_186241_), SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)FIRE_MAGE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)AIR_MAGE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)WATER_MAGE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)EARTH_MAGE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
    }

    static {
        FIRE_MAGE = ModEntities.registerEntity("fire_mage", 0.5f, 1.8f, FireMage::new, MobCategory.MONSTER);
        WATER_MAGE = ModEntities.registerEntity("water_mage", 0.5f, 1.8f, WaterMage::new, MobCategory.MONSTER);
        AIR_MAGE = ModEntities.registerEntity("air_mage", 0.5f, 1.8f, AirMage::new, MobCategory.MONSTER);
        EARTH_MAGE = ModEntities.registerEntity("earth_mage", 0.5f, 1.8f, EarthMage::new, MobCategory.MONSTER);
        FLASHING_WEALD_WALKER = ModEntities.registerEntity("flashing_weald_walker", 1.4f, 3.0f, (type, world) -> {
            WealdWalker walker = new WealdWalker(type, world);
            walker.spell = new Spell(new AbstractSpellPart[]{MethodProjectile.INSTANCE, EffectLaunch.INSTANCE, EffectLaunch.INSTANCE, EffectDelay.INSTANCE, EffectWindshear.INSTANCE});
            walker.color = new ParticleColor(200, 150, 15);
            return walker;
        }, MobCategory.CREATURE);
        SKELEHORSE_SUMMON = ModEntities.addEntity("summon_skelehorse", 1.4f, 1.6f, true, true, SummonSkeleHorse::new, MobCategory.CREATURE);
        DIREWOLF_SUMMON = ModEntities.registerEntity("summon_direwolf", 0.9f, 1.0f, SummonDirewolf::new, MobCategory.CREATURE);
        WSKELETON_SUMMON = ModEntities.registerEntity("summon_wskeleton", 1.0f, 1.8f, SummonUndead::new, MobCategory.CREATURE);
        DOLPHIN_SUMMON = ModEntities.addEntity("summon_dolphin", 0.9f, 0.6f, false, true, SummonDolphin::new, MobCategory.WATER_CREATURE);
        STRIDER_SUMMON = ModEntities.addEntity("summon_strider", 0.9f, 1.7f, true, true, SummonStrider::new, MobCategory.CREATURE);
        VHEX_SUMMON = ModEntities.registerEntity("summon_vhex", 0.4f, 0.8f, AllyVhexEntity::new, MobCategory.MONSTER);
        HOMING_PROJECTILE = ModEntities.addEntity("homing_projectile", 0.5f, 0.5f, true, true, EntityHomingProjectile::new, MobCategory.MISC);
        CURVED_PROJECTILE = ModEntities.addEntity("curved_projectile", 0.5f, 0.5f, true, true, EntityCurvedProjectile::new, MobCategory.MISC);
        LINGER_MAGNET = ModEntities.addEntity("linger_magnet", 0.5f, 0.5f, true, true, EntityMagnetSpell::new, MobCategory.MISC);
        LERP_PROJECTILE = ModEntities.addEntity("lerp", 0.5f, 0.5f, true, true, EntityLerpedProjectile::new, MobCategory.MISC);
        FLASH_LIGHTNING = ModEntities.addEntity("flash_lightning", 0.5f, 0.5f, true, true, FlashLightning::new, MobCategory.MISC);
    }
}

