/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.entity.DripstoneSpikeEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;
import software.bernie.ars_nouveau.geckolib3.renderers.geo.GeoProjectilesRenderer;

public class SpikeRenderer
extends GeoProjectilesRenderer<DripstoneSpikeEntity> {
    public SpikeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AnimatedGeoModel)new DripGeoModel());
    }

    public SpikeRenderer(EntityRendererProvider.Context renderManager, ResourceLocation textureLocation) {
        super(renderManager, (AnimatedGeoModel)new DripGeoModel(textureLocation));
    }

    public float getWidthScale(DripstoneSpikeEntity animatable) {
        return (float)animatable.getAoe();
    }

    public float getHeightScale(DripstoneSpikeEntity entity) {
        return (float)(entity.getPierce() + entity.getAoe() - 1.0);
    }

    private static class DripGeoModel
    extends AnimatedGeoModel<DripstoneSpikeEntity> {
        ResourceLocation AltTexture;
        static final ResourceLocation MODEL = ArsElemental.prefix("geo/spike.geo.json");
        static final ResourceLocation TEXTURE = ArsElemental.prefix("textures/entity/spike.png");
        static final ResourceLocation ANIMATIONS = ArsElemental.prefix("animations/spike.animation.json");

        public DripGeoModel() {
        }

        public DripGeoModel(ResourceLocation textureLocation) {
            this.AltTexture = textureLocation;
        }

        public ResourceLocation getModelResource(DripstoneSpikeEntity dripstoneSpikeEntity) {
            return MODEL;
        }

        public ResourceLocation getTextureResource(DripstoneSpikeEntity dripstoneSpikeEntity) {
            return this.AltTexture != null ? this.AltTexture : TEXTURE;
        }

        public ResourceLocation getAnimationResource(DripstoneSpikeEntity dripstoneSpikeEntity) {
            return ANIMATIONS;
        }
    }
}

