/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.prism;

import alexthw.ars_elemental.registry.ModTiles;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;
import software.bernie.ars_nouveau.geckolib3.util.GeckoLibUtil;

public class AdvancedPrismTile
extends ModdedTile
implements IWandable,
IAnimatable {
    private static final String TAG_LENTS = "prismLent";
    private static final String TAG_ROTATION_X = "rotationX";
    private static final String TAG_ROTATION_Y = "rotationY";
    public float rotationX;
    public float rotationY;
    private ItemStack prismLens;
    final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public AdvancedPrismTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public AdvancedPrismTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.ADVANCED_PRISM.get(), pos, state);
    }

    public void aim(@Nullable BlockPos blockPos, Player playerEntity) {
        if (blockPos == null) {
            return;
        }
        Vec3 thisVec = Vec3.m_82512_((Vec3i)this.m_58899_());
        Vec3 blockVec = Vec3.m_82512_((Vec3i)blockPos);
        Vec3 diffVec = blockVec.m_82546_(thisVec);
        Vec3 diffVec2D = new Vec3(diffVec.f_82479_, diffVec.f_82481_, 0.0);
        Vec3 rotVec = new Vec3(0.0, 1.0, 0.0);
        double angle = AdvancedPrismTile.angleBetween(rotVec, diffVec2D) / Math.PI * 180.0;
        if (blockVec.f_82479_ < thisVec.f_82479_) {
            angle = -angle;
        }
        this.setRotationX((float)angle + 90.0f);
        rotVec = new Vec3(diffVec.f_82479_, 0.0, diffVec.f_82481_);
        angle = AdvancedPrismTile.angleBetween(diffVec, rotVec) * 180.0 / Math.PI;
        if (blockVec.f_82480_ < thisVec.f_82480_) {
            angle = -angle;
        }
        this.setRotationY((float)angle);
        this.updateBlock();
        ParticleUtil.beam((BlockPos)blockPos, (BlockPos)this.m_58899_(), (Level)this.f_58857_);
        PortUtil.sendMessageNoSpam((Entity)playerEntity, (Component)Component.m_237113_((String)("Prism now aims to " + blockPos.m_123344_())));
    }

    public static double angleBetween(Vec3 a, Vec3 b) {
        double projection = a.m_82541_().m_82526_(b.m_82541_());
        return Math.acos(Mth.m_14008_((double)projection, (double)-1.0, (double)1.0));
    }

    public void onWanded(Player playerEntity) {
        if (this.prismLens != null) {
            playerEntity.m_9236_().m_7967_((Entity)new ItemEntity(playerEntity.f_19853_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), this.prismLens));
            this.prismLens = ItemStack.f_41583_;
        }
        this.updateBlock();
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null) {
            this.aim(storedPos, playerEntity);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_(TAG_ROTATION_Y, this.rotationY);
        tag.m_128350_(TAG_ROTATION_X, this.rotationX);
        if (this.prismLens != null) {
            tag.m_128365_(TAG_LENTS, (Tag)this.prismLens.serializeNBT());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.rotationX = tag.m_128457_(TAG_ROTATION_X);
        this.rotationY = tag.m_128457_(TAG_ROTATION_Y);
        if (tag.m_128441_(TAG_LENTS)) {
            this.prismLens = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_LENTS));
        }
    }

    public float getRotationX() {
        return this.rotationX;
    }

    public float getRotationY() {
        return this.rotationY;
    }

    public void setRotationX(float rot) {
        this.rotationX = rot;
    }

    public void setRotationY(float rot) {
        this.rotationY = rot;
    }

    public Vec3 getShootAngle() {
        float f = this.getRotationY() * ((float)Math.PI / 180);
        float f1 = (90.0f + this.getRotationX()) * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4)).m_82548_();
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public ItemStack getLens() {
        return this.prismLens == null ? ItemStack.f_41583_ : this.prismLens;
    }

    void setLens(ItemStack lent, Player pPlayer) {
        this.onWanded(pPlayer);
        this.prismLens = lent;
        this.updateBlock();
    }
}

