/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity;

import alexthw.ars_elemental.common.glyphs.EffectSpike;
import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.PlayState;
import software.bernie.ars_nouveau.geckolib3.core.builder.AnimationBuilder;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;
import software.bernie.ars_nouveau.geckolib3.resource.GeckoLibCache;
import software.bernie.ars_nouveau.geckolib3.util.GeckoLibUtil;

public class DripstoneSpikeEntity
extends Entity
implements IAnimatable,
IEntityAdditionalSpawnData {
    private LivingEntity caster;
    private UUID casterUUID;
    private int lifeTicks = 20;
    float damage;
    SpellStats stats;
    SpellContext context;
    SpellResolver resolver;
    double pierce;
    double aoe = 1.0;
    public final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public double getPierce() {
        return this.pierce;
    }

    public double getAoe() {
        return this.aoe;
    }

    public DripstoneSpikeEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public DripstoneSpikeEntity(Level worldIn, double x, double y, double z, float damage, LivingEntity casterIn, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
        this(worldIn, x, y, z, damage, casterIn, spellStats, context, resolver, (EntityType)ModEntities.DRIPSTONE_SPIKE.get());
    }

    public DripstoneSpikeEntity(Level worldIn, double x, double y, double z, float damage, LivingEntity casterIn, SpellStats spellStats, SpellContext context, SpellResolver resolver, EntityType<?> type) {
        this(type, worldIn);
        this.setOwner(casterIn);
        this.m_6034_(x, y + 0.5, z);
        this.damage = damage;
        this.stats = spellStats;
        this.context = context;
        this.resolver = resolver;
        this.pierce = 1.0 + (double)spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE) * 0.25;
        this.aoe = 1.0 + (spellStats.getAoeMultiplier() - 1.0) * 0.25;
        this.lifeTicks += (int)(5.0 * spellStats.getDurationMultiplier());
    }

    @NotNull
    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.DRIPSTONE_SPIKE.get();
    }

    public void damage(LivingEntity entity) {
        EffectSpike.INSTANCE.attemptDamage(entity.f_19853_, this.caster, this.stats, this.context, this.resolver, (Entity)entity, (DamageSource)new EntityDamageSource(DamageSource.f_146703_.m_19385_(), (Entity)this.caster), this.damage);
    }

    public boolean m_7307_(@NotNull Entity pEntity) {
        if (this.getOwner() != null) {
            return pEntity == this.getOwner() || this.getOwner().m_7307_(pEntity);
        }
        return super.m_7307_(pEntity);
    }

    protected void m_8097_() {
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.caster = pOwner;
        this.casterUUID = pOwner == null ? null : pOwner.m_20148_();
    }

    public void m_8119_() {
        if (!this.f_19853_.m_5776_() && (double)this.lifeTicks < 16.0 + this.stats.getDurationMultiplier() * 5.0 && this.lifeTicks % 5 == 0) {
            for (Entity entity : this.f_19853_.m_6249_((Entity)this, this.m_20191_(), e -> e instanceof LivingEntity)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity target = (LivingEntity)entity;
                this.damage(target);
            }
        }
        if (--this.lifeTicks < 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.caster == null && this.casterUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.casterUUID)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("OwnerUUID")) {
            this.casterUUID = compound.m_128342_("OwnerUUID");
        }
        this.pierce = compound.m_128459_("pierce");
        this.aoe = compound.m_128459_("aoe");
    }

    protected void m_7380_(@NotNull CompoundTag compound) {
        if (this.casterUUID != null) {
            compound.m_128362_("OwnerUUID", this.casterUUID);
        }
        compound.m_128347_("pierce", this.pierce);
        compound.m_128347_("aoe", this.aoe);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::sprout));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "size", 0.0f, this::size));
    }

    private PlayState size(AnimationEvent<DripstoneSpikeEntity> dripstoneSpikeEntityAnimationEvent) {
        GeckoLibCache.getInstance().parser.setValue("aoe", this::getAoe);
        GeckoLibCache.getInstance().parser.setValue("pierce", this::getPierce);
        dripstoneSpikeEntityAnimationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("adjust_size"));
        return PlayState.CONTINUE;
    }

    private PlayState sprout(AnimationEvent<DripstoneSpikeEntity> dripstoneSpikeEntityAnimationEvent) {
        dripstoneSpikeEntityAnimationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("sprout"));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        EntityDimensions base = super.m_6972_(pPose);
        return new EntityDimensions((float)((double)base.f_20377_ * this.aoe), (float)((double)base.f_20378_ * (this.aoe + this.pierce - 0.5)), false);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.pierce);
        buffer.writeDouble(this.aoe);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.pierce = additionalData.readDouble();
        this.aoe = additionalData.readDouble();
    }
}

