/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.mixin.ZombieInvoker;
import alexthw.ars_elemental.registry.ModPotions;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectWaterGrave
extends ElementalAbstractEffect
implements IDamageEffect,
IPotionEffect {
    public static EffectWaterGrave INSTANCE = new EffectWaterGrave();

    private EffectWaterGrave() {
        super("watery_grave", "Watery Grave");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof LivingEntity) {
            int airSupply;
            LivingEntity living = (LivingEntity)entity;
            if (spellStats.hasBuff((AbstractAugment)AugmentExtendTime.INSTANCE)) {
                this.applyConfigPotion(living, (MobEffect)ModPotions.WATER_GRAVE.get(), spellStats);
            } else {
                Vec3 delta = living.m_20184_();
                double dy = Math.min(-1.0, delta.f_82480_ - 0.05);
                living.m_20334_(delta.f_82479_, dy, delta.f_82481_);
            }
            if (living instanceof Zombie) {
                Zombie zombie = (Zombie)living;
                if (!(living instanceof Drowned)) {
                    ((ZombieInvoker)zombie).callStartUnderWaterConversion(20);
                    return;
                }
            }
            if ((airSupply = living.m_20146_()) <= 0 || living.m_6336_() == MobType.f_21644_) {
                double damage = (Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
                this.attemptDamage(world, shooter, spellStats, spellContext, resolver, (Entity)living, (DamageSource)new EntityDamageSource(DamageSource.f_19312_.m_19385_(), (Entity)shooter), (float)damage);
            } else {
                double newSupply = Math.max(-19.0, (double)airSupply - 50.0 * (3.0 + spellStats.getAmpMultiplier()));
                living.m_20301_((int)newSupply);
            }
            living.f_19864_ = true;
        }
    }

    public int getDefaultManaCost() {
        return 25;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDefaultPotionConfig(builder);
        this.addDamageConfig(builder, 5.0);
        this.addAmpConfig(builder, 2.0);
    }

    protected Map<ResourceLocation, Integer> getDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        super.getDefaultAugmentLimits(defaults);
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
        return defaults;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.getPotionAugments();
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return Set.of(SpellSchools.ELEMENTAL_WATER);
    }

    public String getBookDescription() {
        return "Causes entities to drown. When augmented with Extend Time, they will be dragged down and unable to swim up.";
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

