/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.foci;

import alexthw.ars_elemental.ArsNouveauRegistry;
import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.api.IUndeadSummon;
import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.glyphs.EffectPhantom;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import alexthw.ars_elemental.common.items.ElementalCurio;
import alexthw.ars_elemental.util.ParticleUtil;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonUndead;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="ars_elemental")
public class NecroticFocus
extends ElementalCurio
implements ISchoolFocus {
    public NecroticFocus(Item.Properties properties) {
        super(properties);
    }

    @Override
    public double getDiscount() {
        return (Double)ConfigHandler.COMMON.MajorFocusDiscount.get();
    }

    @Override
    public SpellSchool getSchool() {
        return ArsNouveauRegistry.NECROMANCY;
    }

    public static void spawnDeathPoof(ServerLevel world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 1.2;
            double d2 = (double)pos.m_123343_() + 0.5;
            world.m_8767_((ParticleOptions)ParticleTypes.f_123792_, d0, d1, d2, 2, ((double)world.f_46441_.m_188501_() - 0.5) / 3.0, ((double)world.f_46441_.m_188501_() - 0.5) / 3.0, ((double)world.f_46441_.m_188501_() - 0.5) / 3.0, (double)0.1f);
        }
    }

    public static boolean hasFocus(Level level, Entity entity) {
        Optional curios;
        if (!level.f_46443_ && entity instanceof Player && (curios = CuriosUtil.getAllWornItems((LivingEntity)((LivingEntity)entity)).resolve()).isPresent()) {
            IItemHandlerModifiable items = (IItemHandlerModifiable)curios.get();
            return IntStream.range(0, items.getSlots()).anyMatch(i -> items.getStackInSlot(i).m_41720_() instanceof NecroticFocus);
        }
        return false;
    }

    public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        builder.addDamageModifier(1.0);
        if (ArsNouveauRegistry.NECROMANCY.isPartOfSchool(spellPart)) {
            builder.addDurationModifier(2.0);
            if (spellPart == EffectHeal.INSTANCE || spellPart == EffectPhantom.INSTANCE || spellPart == EffectSummonUndead.INSTANCE) {
                builder.addAmplification(2.0);
            }
        }
        return builder;
    }

    @SubscribeEvent
    public static void lifeSteal(LivingDeathEvent event) {
        IUndeadSummon risen;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof IUndeadSummon && (risen = (IUndeadSummon)entity).getOwnerID() != null && (entity = event.getEntity().m_9236_()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)entity;
            Player player = event.getEntity().f_19853_.m_46003_(risen.getOwnerID());
            if (player != null) {
                player.m_5634_(2.0f);
                level.m_7967_((Entity)new EntityFollowProjectile((Level)level, risen.getLivingEntity().m_20183_(), player.m_20183_(), ParticleUtil.soulColor.toWrapper()));
            }
        }
    }

    @SubscribeEvent
    public static void castSpell(SpellCastEvent event) {
        Object object = event.getWorld();
        if (object instanceof ServerLevel) {
            Player player;
            ServerLevel world = (ServerLevel)object;
            object = event.getEntity();
            if (object instanceof Player && NecroticFocus.hasFocus((Level)world, (Entity)(player = (Player)object)) && event.spell.getCastMethod() == MethodHomingProjectile.INSTANCE) {
                for (Mob i : world.m_6443_(Mob.class, new AABB(event.getEntity().m_20183_()).m_82400_(30.0), l -> {
                    if (!(l instanceof IUndeadSummon)) return false;
                    IUndeadSummon summon = (IUndeadSummon)l;
                    if (!player.m_20148_().equals(summon.getOwnerID())) return false;
                    return true;
                })) {
                    LivingEntity target = i.m_5448_();
                    if (target == null) {
                        target = player.m_21214_();
                    }
                    if (target != null && target.m_6084_()) {
                        i.m_21563_().m_148051_((Entity)target);
                    } else {
                        i.m_21563_().m_24964_(player.m_20252_(1.0f));
                    }
                    EntitySpellResolver spellResolver = new EntitySpellResolver(event.context.clone().withWrappedCaster((IWrappedCaster)new LivingCaster((LivingEntity)i)));
                    spellResolver.onCast(ItemStack.f_41583_, (Level)world);
                }
            }
        }
    }
}

