/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="ars_elemental")
public class Events {
    @SubscribeEvent
    public static void focusDiscount(SpellCastEvent event) {
        Player player;
        ISchoolFocus focus;
        LivingEntity livingEntity;
        if (!event.getWorld().f_46443_ && (livingEntity = event.getEntity()) instanceof Player && (focus = ISchoolFocus.getFocus(player = (Player)livingEntity)) != null) {
            if (event.spell.recipe.stream().anyMatch(arg_0 -> ((SpellSchool)focus.getSchool()).isPartOfSchool(arg_0))) {
                event.spell.addDiscount((int)((double)event.spell.getNoDiscountCost() * focus.getDiscount()));
            }
        }
    }

    @SubscribeEvent
    public static void DeathEvent(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21023_((MobEffect)ModPotions.HYMN_OF_ORDER.get())) {
            MobEffectInstance effect = player.m_21124_((MobEffect)ModPotions.HYMN_OF_ORDER.get());
            if (effect == null) {
                return;
            }
            CompoundTag data = player.getPersistentData();
            if (!data.m_128441_("PlayerPersisted")) {
                data.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
            }
            CompoundTag persist = data.m_128469_("PlayerPersisted");
            persist.m_128379_("magic_locked", true);
            persist.m_128405_("magic_lock_duration", effect.m_19557_());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDrop(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player instanceof FakePlayer || player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
                return;
            }
            Collection drops = event.getDrops();
            if (drops == null) {
                return;
            }
            ArrayList<ItemEntity> keeps = new ArrayList<ItemEntity>();
            for (ItemEntity item : drops) {
                ItemStack stack = item.m_32055_();
                if (stack.m_41619_() || stack.getEnchantmentLevel((Enchantment)ModRegistry.SOULBOUND.get()) <= 0) continue;
                keeps.add(item);
            }
            if (!keeps.isEmpty()) {
                drops.removeAll(keeps);
                CompoundTag cmp = new CompoundTag();
                cmp.m_128405_("tagSoulboundDC", keeps.size());
                int i = 0;
                for (ItemEntity keep : keeps) {
                    ItemStack stack = keep.m_32055_();
                    CompoundTag cmp1 = stack.m_41739_(new CompoundTag());
                    cmp.m_128365_("tagSoulboundPrefix" + i, (Tag)cmp1);
                    ++i;
                }
                CompoundTag data = player.getPersistentData();
                if (!data.m_128441_("PlayerPersisted")) {
                    data.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
                }
                CompoundTag persist = data.m_128469_("PlayerPersisted");
                persist.m_128365_("tagSoulbound", (Tag)cmp);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnHW(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        CompoundTag data = event.getEntity().getPersistentData();
        if (data.m_128441_("PlayerPersisted")) {
            CompoundTag persist = data.m_128469_("PlayerPersisted");
            if (persist.m_128441_("magic_locked") && persist.m_128441_("magic_lock_duration")) {
                event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ModPotions.HYMN_OF_ORDER.get(), persist.m_128451_("magic_lock_duration")));
                persist.m_128473_("magic_locked");
                persist.m_128473_("magic_lock_duration");
            }
            CompoundTag soulTag = persist.m_128469_("tagSoulbound");
            int count = soulTag.m_128451_("tagSoulboundDC");
            ArrayList<ItemStack> recovered = new ArrayList<ItemStack>();
            for (int i = 0; i < count; ++i) {
                CompoundTag toRecover = soulTag.m_128469_("tagSoulboundPrefix" + i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)toRecover);
                if (stack.m_41619_()) continue;
                recovered.add(stack.m_41777_());
            }
            for (ItemStack stack : recovered) {
                Item item = stack.m_41720_();
                if (item instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)item;
                    if (event.getEntity().m_6844_(armor.m_40402_()).m_41619_()) {
                        event.getEntity().m_8061_(armor.m_40402_(), stack);
                        continue;
                    }
                }
                if (stack.m_41720_() instanceof ShieldItem && event.getEntity().m_21206_().m_41619_()) {
                    event.getEntity().m_21008_(InteractionHand.OFF_HAND, stack);
                    continue;
                }
                ItemHandlerHelper.giveItemToPlayer((Player)event.getEntity(), (ItemStack)stack);
            }
            persist.m_128473_("tagSoulbound");
        }
    }

    @SubscribeEvent
    public static void soulboundCurio(DropRulesEvent event) {
        event.addOverride(i -> i.getEnchantmentLevel((Enchantment)ModRegistry.SOULBOUND.get()) > 0, ICurio.DropRule.ALWAYS_KEEP);
    }
}

