/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.strategy;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.localization.GuiText;
import appeng.util.BlockApiCache;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import gripe._90.arseng.block.entity.IAdvancedSourceTile;
import gripe._90.arseng.definition.ArsEngCapabilities;
import gripe._90.arseng.me.key.SourceKey;
import gripe._90.arseng.me.key.SourceKeyType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.Nullable;

public class SourceExternalStorageStrategy
implements ExternalStorageStrategy {
    private final BlockApiCache<IAdvancedSourceTile> apiCache;
    private final Direction fromSide;

    public SourceExternalStorageStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = BlockApiCache.create(ArsEngCapabilities.SOURCE_TILE, (ServerLevel)level, (BlockPos)fromPos);
        this.fromSide = fromSide;
    }

    @Nullable
    public MEStorage createWrapper(boolean extractableOnly, Runnable injectOrExtractCallback) {
        IAdvancedSourceTile sourceTile = (IAdvancedSourceTile)this.apiCache.find(this.fromSide);
        return sourceTile != null ? new SourceStorageAdapter(sourceTile, injectOrExtractCallback) : null;
    }

    private record SourceStorageAdapter(ISourceTile sourceTile, Runnable injectOrExtractCallback) implements MEStorage
    {
        public long insert(AEKey what, long amount, Actionable mode, IActionSource actionSource) {
            if (!(what instanceof SourceKey)) {
                return 0L;
            }
            int inserted = (int)Math.min(amount, (long)(this.sourceTile.getMaxSource() - this.sourceTile.getSource()));
            if (inserted > 0 && mode == Actionable.MODULATE) {
                this.sourceTile.addSource(inserted);
                this.injectOrExtractCallback.run();
            }
            return inserted;
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource actionSource) {
            if (!(what instanceof SourceKey)) {
                return 0L;
            }
            int extracted = (int)Math.min(amount, (long)this.sourceTile.getSource());
            if (extracted > 0 && mode == Actionable.MODULATE) {
                this.sourceTile.removeSource(extracted);
                this.injectOrExtractCallback.run();
            }
            return extracted;
        }

        public void getAvailableStacks(KeyCounter out) {
            int currentSource = this.sourceTile.getSource();
            if (currentSource != 0) {
                out.add(SourceKey.KEY, (long)currentSource);
            }
        }

        public Component getDescription() {
            return GuiText.ExternalStorage.text(new Object[]{SourceKeyType.TYPE.getDescription()});
        }
    }
}

