/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.mod;

import com.ldtteam.blockui.BOScreen;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonVanilla;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.hooks.HookManager;
import com.ldtteam.blockui.hooks.HookRegistries;
import com.ldtteam.blockui.mod.BlockStateTestGui;
import com.ldtteam.blockui.mod.DynamicScrollingListGui;
import com.ldtteam.blockui.mod.container.ContainerHook;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.views.BOWindow;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.ModMismatchEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ClientEventSubscriber {
    @SubscribeEvent
    public static void renderWorldLastEvent(@NotNull RenderLevelLastEvent event) {
        PoseStack ps = event.getPoseStack();
        Vec3 viewPosition = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        ps.m_85836_();
        ps.m_85837_(-viewPosition.m_7096_(), -viewPosition.m_7098_(), -viewPosition.m_7094_());
        HookRegistries.render(ps, event.getPartialTick());
        ps.m_85849_();
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Screen.m_96639_() && Screen.m_96637_() && Screen.m_96638_() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)88)) {
            BOWindow window = new BOWindow();
            window.addChild(ClientEventSubscriber.createTestGuiButton(0, "General All-in-one", new ResourceLocation("blockui", "gui/test.xml"), parent -> {
                parent.findPaneOfTypeByID("missing_out_of_jar", Image.class).setImage(OutOfJarResourceLocation.ofMinecraftFolder("blockui", "missing_out_of_jar.png"), false);
                parent.findPaneOfTypeByID("working_out_of_jar", Image.class).setImage(OutOfJarResourceLocation.ofMinecraftFolder("blockui", "../../src/test/resources/button.png"), false);
            }));
            window.addChild(ClientEventSubscriber.createTestGuiButton(1, "Tooltip Positioning", new ResourceLocation("blockui", "gui/test2.xml"), new Consumer[0]));
            window.addChild(ClientEventSubscriber.createTestGuiButton(2, "ItemIcon To BlockState", new ResourceLocation("blockui", "gui/test3.xml"), BlockStateTestGui::setup));
            window.addChild(ClientEventSubscriber.createTestGuiButton(3, "Dynamic ScrollingLists", new ResourceLocation("blockui", "gui/test4.xml"), DynamicScrollingListGui::setup));
            window.open();
        }
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null) {
            Minecraft.m_91087_().m_91307_().m_6180_("hook_manager_tick");
            HookRegistries.tick(Minecraft.m_91087_().f_91073_.m_46467_());
            Minecraft.m_91087_().m_91307_().m_7238_();
        }
    }

    @SafeVarargs
    private static Button createTestGuiButton(int order, String name, ResourceLocation testGuiResLoc, final Consumer<BOWindow> ... setups) {
        ButtonVanilla button = new ButtonVanilla();
        button.setPosition(order % 2 * (button.getWidth() + 20), order / 2 * (button.getHeight() + 10));
        button.setText(Component.m_237113_((String)name));
        button.setHandler(b -> new BOWindow(testGuiResLoc){

            @Override
            public void onOpened() {
                super.onOpened();
                for (Consumer setup : setups) {
                    setup.accept(this);
                }
            }
        }.openAsLayer());
        return button;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMouseScrollEvent(InputEvent.MouseScrollingEvent event) {
        event.setCanceled(HookManager.onScroll(event.getScrollDelta()));
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        ContainerHook.init();
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGuiOverlayEvent event) {
        if (Minecraft.m_91087_().f_91080_ instanceof BOScreen && event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onModMismatch(ModMismatchEvent event) {
        event.markResolved("blockui");
    }
}

