/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util.texture;

import com.google.gson.JsonObject;
import com.ldtteam.blockui.util.cursor.CursorUtils;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorTexture
extends AbstractTexture {
    private static final Logger LOGGER = LoggerFactory.getLogger(CursorTexture.class);
    private final ResourceLocation resourceLocation;
    private int hotspotX = 0;
    private int hotspotY = 0;
    private long glfwCursorAddress = 0L;
    @Nullable
    protected NativeImage nativeImage = null;

    public CursorTexture(ResourceLocation resLoc) {
        this.resourceLocation = resLoc;
    }

    public void setHotspot(int x, int y) {
        if (this.hotspotX != x || this.hotspotY != y) {
            this.hotspotX = x;
            this.hotspotY = y;
            this.onDataChange();
        }
    }

    public boolean isCursorNow() {
        return CursorUtils.isCurrentCursor(this.glfwCursorAddress) && this.glfwCursorAddress != 0L;
    }

    private void onDataChange() {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(this::onDataChange);
            return;
        }
        if (this.isCursorNow()) {
            this.destroyCursorHandle();
            this.setCursor();
        } else {
            this.destroyCursorHandle();
        }
    }

    protected void destroyCursorHandle() {
        if (this.glfwCursorAddress != 0L) {
            RenderSystem.m_187554_();
            if (this.isCursorNow()) {
                CursorUtils.resetCursor();
            }
            GLFW.glfwDestroyCursor((long)this.glfwCursorAddress);
            this.glfwCursorAddress = 0L;
        }
    }

    public void setCursor() {
        if (this.glfwCursorAddress == 0L && this.nativeImage != null) {
            RenderSystem.m_187554_();
            try (MemoryStack stack = MemoryStack.stackPush();){
                GLFWImage image = GLFWImage.malloc((MemoryStack)stack);
                image.width(this.nativeImage.m_84982_());
                image.height(this.nativeImage.m_85084_());
                MemoryUtil.memPutAddress((long)(image.address() + (long)GLFWImage.PIXELS), (long)this.nativeImage.f_84964_);
                this.glfwCursorAddress = GLFW.glfwCreateCursor((GLFWImage)image, (int)this.hotspotX, (int)this.hotspotY);
            }
            if (this.glfwCursorAddress == 0L) {
                LOGGER.error("Cannot create textured cursor for resource location: " + this.resourceLocation);
            }
        }
        if (this.glfwCursorAddress != 0L) {
            CursorUtils.setCursorAddress(this.glfwCursorAddress);
        } else {
            CursorUtils.resetCursor();
        }
    }

    public void m_6704_(ResourceManager resourceManager) throws IOException {
        if (this.nativeImage != null) {
            this.close();
        }
        Resource resource = OutOfJarResourceLocation.getResourceHandle(this.resourceLocation, resourceManager);
        try (InputStream is = resource.m_215507_();){
            this.nativeImage = NativeImage.m_85058_((InputStream)is);
        }
        if (this.nativeImage.m_85102_() != NativeImage.Format.RGBA) {
            LOGGER.error("Cannot load texture for cursor as it is not in RGBA format, resource location: " + this.resourceLocation);
            this.close();
        }
        resource.m_215509_().m_214059_((MetadataSectionSerializer)CursorMetadataSection.SERIALIZER).ifPresent(metadata -> {
            this.hotspotX = metadata.hotspotX;
            this.hotspotY = metadata.hotspotY;
        });
        this.onDataChange();
    }

    public void close() {
        this.destroyCursorHandle();
        if (this.nativeImage != null) {
            this.nativeImage.close();
            this.nativeImage = null;
        }
    }

    public record CursorMetadataSection(int hotspotX, int hotspotY) {
        public static final CursorMetadataSectionSerializer SERIALIZER = new CursorMetadataSectionSerializer();
    }

    private static class CursorMetadataSectionSerializer
    implements MetadataSectionSerializer<CursorMetadataSection> {
        private CursorMetadataSectionSerializer() {
        }

        public String m_7991_() {
            return "ldtteam.blockui.cursor";
        }

        public CursorMetadataSection fromJson(JsonObject jsonObject) {
            return new CursorMetadataSection(GsonHelper.m_13824_((JsonObject)jsonObject, (String)"hotspot.x", (int)0), GsonHelper.m_13824_((JsonObject)jsonObject, (String)"hotspot.y", (int)0));
        }
    }
}

