/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.views.View;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class SwitchView
extends View {
    @Nullable
    private Pane currentView;
    protected boolean endlessScrolling = false;

    public SwitchView() {
    }

    public SwitchView(PaneParams params) {
        super(params);
    }

    @Override
    public void parseChildren(PaneParams params) {
        super.parseChildren(params);
        String defaultView = params.getString("default");
        if (defaultView != null) {
            this.setView(defaultView);
        }
        this.endlessScrolling = params.getBoolean("endless", this.endlessScrolling);
    }

    public boolean setView(String name) {
        for (Pane child : this.children) {
            if (!child.getID().equals(name)) continue;
            this.setCurrentView(child);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Pane findPaneForClick(double mx, double my) {
        if (this.currentView != null && this.currentView.canHandleClick(mx, my)) {
            return this.currentView;
        }
        return null;
    }

    @Override
    protected boolean childIsVisible(Pane child) {
        return child == this.currentView && super.childIsVisible(child);
    }

    @Override
    public void addChild(Pane child) {
        super.addChild(child);
        if (this.children.size() == 1) {
            this.currentView = child;
            child.setVisible(true);
        } else {
            child.setVisible(false);
        }
    }

    @Override
    public void adjustChild(Pane child) {
        if (child.getWidth() == 0 || child.getHeight() == 0) {
            child.setSize(this.width - child.getX(), this.height - child.getY());
        }
        super.adjustChild(child);
    }

    @Override
    public void removeChild(Pane child) {
        super.removeChild(child);
        if (child == this.currentView) {
            if (this.children.isEmpty()) {
                this.currentView = null;
            } else {
                this.currentView = (Pane)this.children.get(0);
                this.currentView.setVisible(true);
            }
        }
    }

    @Nullable
    public Pane getCurrentView() {
        return this.currentView;
    }

    private void setCurrentView(Pane pane) {
        if (this.currentView != null) {
            this.currentView.setVisible(false);
        }
        this.currentView = pane;
        this.currentView.setVisible(true);
    }

    public void nextView() {
        this.setView(true, 1);
    }

    public void previousView() {
        this.setView(true, -1);
    }

    public int setView(boolean relative, int shift) {
        if (this.children.isEmpty()) {
            return -1;
        }
        int newIndex = relative ? this.children.indexOf(this.currentView) + shift : shift;
        newIndex = this.endlessScrolling ? Math.floorMod(newIndex, this.getChildrenSize()) : newIndex;
        newIndex = Mth.m_14045_((int)newIndex, (int)0, (int)(this.getChildrenSize() - 1));
        this.setCurrentView((Pane)this.children.get(newIndex));
        return newIndex;
    }

    public int getChildrenSize() {
        return this.children.size();
    }

    public boolean isEndlessScrollingEnabled() {
        return this.endlessScrolling;
    }

    public void setEndlessScrolling(boolean endlessScrolling) {
        this.endlessScrolling = endlessScrolling;
    }
}

