/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.cache;

import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketSetRemoteInventoryCache;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Multiset;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class RemoteInventoryCache {
    private boolean isCopyPaste;
    private boolean forceUpdate;
    private Pair<BlockPos, ResourceKey<Level>> locCached;
    private Multiset<UniqueItem> cache;
    private Stopwatch timer;

    public RemoteInventoryCache(boolean isCopyPaste) {
        this.isCopyPaste = isCopyPaste;
    }

    public void setCache(Multiset<UniqueItem> cache) {
        this.cache = cache;
    }

    public void forceUpdate() {
        this.forceUpdate = true;
    }

    public boolean maintainCache(ItemStack tool) {
        Pair<BlockPos, ResourceKey<Level>> loc = InventoryLinker.getDataFromStack(tool);
        if (this.isCacheOld(loc)) {
            this.updateCache(loc);
        }
        return loc != null;
    }

    public Multiset<UniqueItem> getCache() {
        return this.cache;
    }

    private void updateCache(Pair<BlockPos, ResourceKey<Level>> loc) {
        this.locCached = loc;
        if (loc == null) {
            this.cache = null;
        } else {
            PacketHandler.sendToServer(new PacketSetRemoteInventoryCache(loc, this.isCopyPaste));
        }
    }

    private boolean isCacheOld(@Nullable Pair<BlockPos, ResourceKey<Level>> loc) {
        if (!Objects.equals(this.locCached, loc)) {
            this.timer = loc == null ? null : Stopwatch.createStarted();
            return true;
        }
        if (this.timer != null) {
            boolean overtime;
            boolean bl = overtime = this.forceUpdate || this.timer.elapsed(TimeUnit.MILLISECONDS) >= 5000L;
            if (overtime) {
                this.timer.reset();
                this.timer.start();
                this.forceUpdate = false;
            }
            return overtime;
        }
        return false;
    }
}

