/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.widgets.GuiIncrementer;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketCopyCoords;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class CopyGUI
extends Screen {
    private GuiIncrementer startX;
    private GuiIncrementer startY;
    private GuiIncrementer startZ;
    private GuiIncrementer endX;
    private GuiIncrementer endY;
    private GuiIncrementer endZ;
    private boolean absoluteCoords;
    private int x;
    private int y;
    private ItemStack copyPasteTool;
    private BlockPos startPos;
    private BlockPos endPos;
    private List<GuiIncrementer> fields;

    public CopyGUI(ItemStack tool) {
        super((Component)Component.m_237113_((String)""));
        this.absoluteCoords = (Boolean)Config.GENERAL.absoluteCoordDefault.get() != false && (Boolean)Config.GENERAL.allowAbsoluteCoords.get() != false;
        this.fields = new ArrayList<GuiIncrementer>();
        this.copyPasteTool = tool;
    }

    public void m_7856_() {
        super.m_7856_();
        this.fields.clear();
        this.x = this.f_96543_ / 2;
        this.y = this.f_96544_ / 2;
        Region reg = GadgetCopyPaste.getSelectedRegion(this.copyPasteTool).orElse(Region.singleZero());
        this.startPos = reg.getMin();
        this.endPos = reg.getMax();
        int incrementerWidth = 96;
        this.startX = new GuiIncrementer(this.x - incrementerWidth - 35, this.y - 40);
        this.fields.add(this.startX);
        this.startY = new GuiIncrementer(this.x - 32, this.y - 40);
        this.fields.add(this.startY);
        this.startZ = new GuiIncrementer(this.x + 32 + 35, this.y - 40);
        this.fields.add(this.startZ);
        this.endX = new GuiIncrementer(this.x - incrementerWidth - 35, this.y - 15);
        this.fields.add(this.endX);
        this.endY = new GuiIncrementer(this.x - 32, this.y - 15);
        this.fields.add(this.endY);
        this.endZ = new GuiIncrementer(this.x + 32 + 35, this.y - 15);
        this.fields.add(this.endZ);
        this.fields.forEach(x$0 -> {
            GuiIncrementer cfr_ignored_0 = (GuiIncrementer)this.m_142416_((GuiEventListener)x$0);
        });
        this.updateTextFields();
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>(){
            {
                this.add(new CenteredButton(CopyGUI.this.y + 20, 50, (Component)GuiTranslation.SINGLE_CONFIRM.componentTranslation(new Object[0]), button -> {
                    if (CopyGUI.this.absoluteCoords) {
                        CopyGUI.this.startPos = new BlockPos(CopyGUI.this.startX.getValue(), CopyGUI.this.startY.getValue(), CopyGUI.this.startZ.getValue());
                        CopyGUI.this.endPos = new BlockPos(CopyGUI.this.endX.getValue(), CopyGUI.this.endY.getValue(), CopyGUI.this.endZ.getValue());
                    } else {
                        CopyGUI.this.startPos = new BlockPos(CopyGUI.this.startPos.m_123341_() + CopyGUI.this.startX.getValue(), CopyGUI.this.startPos.m_123342_() + CopyGUI.this.startY.getValue(), CopyGUI.this.startPos.m_123343_() + CopyGUI.this.startZ.getValue());
                        CopyGUI.this.endPos = new BlockPos(CopyGUI.this.startPos.m_123341_() + CopyGUI.this.endX.getValue(), CopyGUI.this.startPos.m_123342_() + CopyGUI.this.endY.getValue(), CopyGUI.this.startPos.m_123343_() + CopyGUI.this.endZ.getValue());
                    }
                    PacketHandler.sendToServer(new PacketCopyCoords(CopyGUI.this.startPos, CopyGUI.this.endPos));
                }));
                this.add(new CenteredButton(CopyGUI.this.y + 20, 50, (Component)GuiTranslation.SINGLE_CLOSE.componentTranslation(new Object[0]), button -> CopyGUI.this.m_7379_()));
                this.add(new CenteredButton(CopyGUI.this.y + 20, 50, (Component)GuiTranslation.SINGLE_CLEAR.componentTranslation(new Object[0]), button -> {
                    PacketHandler.sendToServer(new PacketCopyCoords(BlockPos.f_121853_, BlockPos.f_121853_));
                    CopyGUI.this.m_7379_();
                }));
                if (((Boolean)Config.GENERAL.allowAbsoluteCoords.get()).booleanValue()) {
                    this.add(new CenteredButton(CopyGUI.this.y + 20, 120, (Component)GuiTranslation.COPY_BUTTON_ABSOLUTE.componentTranslation(new Object[0]), button -> {
                        CopyGUI.this.coordsModeSwitch();
                        CopyGUI.this.updateTextFields();
                    }));
                }
            }
        };
        CenteredButton.centerButtonList((List<AbstractButton>)buttons, this.x);
        buttons.forEach(x$0 -> {
            AbstractButton cfr_ignored_0 = (AbstractButton)this.m_142416_((GuiEventListener)x$0);
        });
    }

    private void drawFieldLabel(PoseStack matrices, String name, int x, int y) {
        this.f_96547_.m_92750_(matrices, name, (float)(this.x + x), (float)(this.y + y), 0xFFFFFF);
    }

    private void coordsModeSwitch() {
        this.absoluteCoords = !this.absoluteCoords;
    }

    private void updateTextFields() {
        if (this.absoluteCoords) {
            BlockPos start = this.startX.getValue() != 0 ? new BlockPos(this.startPos.m_123341_() + this.startX.getValue(), this.startPos.m_123342_() + this.startY.getValue(), this.startPos.m_123343_() + this.startZ.getValue()) : this.startPos;
            BlockPos end = this.endX.getValue() != 0 ? new BlockPos(this.startPos.m_123341_() + this.endX.getValue(), this.startPos.m_123342_() + this.endY.getValue(), this.startPos.m_123343_() + this.endZ.getValue()) : this.endPos;
            this.startX.setValue(start.m_123341_());
            this.startY.setValue(start.m_123342_());
            this.startZ.setValue(start.m_123343_());
            this.endX.setValue(end.m_123341_());
            this.endY.setValue(end.m_123342_());
            this.endZ.setValue(end.m_123343_());
        } else {
            this.startX.setValue(this.startX.getValue() != 0 ? this.startX.getValue() - this.startPos.m_123341_() : 0);
            this.startY.setValue(this.startY.getValue() != 0 ? this.startY.getValue() - this.startPos.m_123342_() : 0);
            this.startZ.setValue(this.startZ.getValue() != 0 ? this.startZ.getValue() - this.startPos.m_123343_() : 0);
            this.endX.setValue(this.endX.getValue() != 0 ? this.endX.getValue() - this.startPos.m_123341_() : this.endPos.m_123341_() - this.startPos.m_123341_());
            this.endY.setValue(this.endY.getValue() != 0 ? this.endY.getValue() - this.startPos.m_123342_() : this.endPos.m_123342_() - this.startPos.m_123342_());
            this.endZ.setValue(this.endZ.getValue() != 0 ? this.endZ.getValue() - this.startPos.m_123343_() : this.endPos.m_123343_() - this.startPos.m_123343_());
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        this.drawFieldLabel(matrices, GuiTranslation.FIELD_START.format(new Object[0]) + " X", -175, -36);
        this.drawFieldLabel(matrices, "Y", -45, -36);
        this.drawFieldLabel(matrices, "Z", 55, -36);
        this.drawFieldLabel(matrices, GuiTranslation.FIELD_END.format(new Object[0]) + " X", -167, -11);
        this.drawFieldLabel(matrices, "Y", -45, -11);
        this.drawFieldLabel(matrices, "Z", 55, -11);
        CopyGUI.m_93208_((PoseStack)matrices, (Font)Minecraft.m_91087_().f_91062_, (String)I18n.m_118938_((String)GuiTranslation.COPY_LABEL_HEADING.getTranslationKey(), (Object[])new Object[0]), (int)this.x, (int)(this.y - 80), (int)0xFFFFFF);
        CopyGUI.m_93208_((PoseStack)matrices, (Font)Minecraft.m_91087_().f_91062_, (String)I18n.m_118938_((String)GuiTranslation.COPY_LABEL_SUBHEADING.getTranslationKey(), (Object[])new Object[0]), (int)this.x, (int)(this.y - 68), (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int mouseX, int mouseY, int __unused) {
        this.fields.forEach(button -> button.m_7933_(mouseX, mouseY, __unused));
        return super.m_7933_(mouseX, mouseY, __unused);
    }

    public boolean m_5534_(char charTyped, int __unused) {
        this.fields.forEach(button -> button.m_5534_(charTyped, __unused));
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    static class CenteredButton
    extends Button {
        CenteredButton(int y, int width, Component text, Button.OnPress onPress) {
            super(0, y, width, 20, text, onPress);
        }

        static void centerButtonList(List<AbstractButton> buttons, int startX) {
            int collectiveWidth = buttons.stream().mapToInt(AbstractWidget::m_5711_).sum() + (buttons.size() - 1) * 5;
            int nextX = startX - collectiveWidth / 2;
            for (AbstractButton button : buttons) {
                button.f_93620_ = nextX;
                nextX += button.m_5711_() + 5;
            }
        }
    }
}

