/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.blocks;

import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.entities.ConstructionBlockEntity;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.tileentities.EffectBlockTileEntity;
import com.direwolf20.buildinggadgets.common.tileentities.OurTileEntities;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EffectBlock
extends BaseEntityBlock {
    private static final Material EFFECT_BLOCK_MATERIAL = new Material.Builder(MaterialColor.f_76398_).m_76353_().m_76359_();

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return EffectBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)OurTileEntities.EFFECT_BLOCK_TILE_ENTITY.get()), EffectBlockTileEntity::tick);
    }

    public static void spawnUndoBlock(BuildContext context, PlacementTarget target) {
        BlockState state = context.getWorld().m_8055_(target.getPos());
        BlockEntity curTe = context.getWorld().m_7702_(target.getPos());
        if (target.getData().getState() != Blocks.f_50016_.m_49966_()) {
            Mode mode = state.m_60795_() ? Mode.PLACE : Mode.REPLACE;
            EffectBlock.spawnEffectBlock(curTe, state, context.getWorld(), target.getPos(), target.getData(), mode, false);
        } else if (!state.m_60795_()) {
            EffectBlock.spawnEffectBlock(curTe, state, context.getWorld(), target.getPos(), TileSupport.createBlockData(state, curTe), Mode.REMOVE, false);
        }
    }

    public static void spawnEffectBlock(BuildContext context, PlacementTarget target, Mode mode, boolean usePaste) {
        EffectBlock.spawnEffectBlock(context.getWorld(), target.getPos(), target.getData(), mode, usePaste);
    }

    public static void spawnEffectBlock(LevelAccessor world, BlockPos spawnPos, BlockData spawnBlock, Mode mode, boolean usePaste) {
        BlockState state = world.m_8055_(spawnPos);
        BlockEntity curTe = world.m_7702_(spawnPos);
        EffectBlock.spawnEffectBlock(curTe, state, world, spawnPos, spawnBlock, mode, usePaste);
    }

    private static void spawnEffectBlock(@Nullable BlockEntity curTe, BlockState curState, LevelAccessor world, BlockPos spawnPos, BlockData spawnBlock, Mode mode, boolean usePaste) {
        BlockState state = ((Block)OurBlocks.EFFECT_BLOCK.get()).m_49966_();
        world.m_7731_(spawnPos, state, 3);
        BlockEntity tile = world.m_7702_(spawnPos);
        if (!(tile instanceof EffectBlockTileEntity)) {
            world.m_7731_(spawnPos, Blocks.f_50016_.m_49966_(), 3);
            return;
        }
        ((EffectBlockTileEntity)tile).initializeData(curState, curTe, spawnBlock, mode, usePaste);
        if (world instanceof Level) {
            ((Level)world).m_7260_(spawnPos, state, state, 11);
        }
    }

    public EffectBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)EFFECT_BLOCK_MATERIAL).m_60978_(20.0f));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)OurTileEntities.EFFECT_BLOCK_TILE_ENTITY.get()).m_155264_(pos, state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    @Deprecated
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean m_6104_(BlockState p_200122_1_, BlockState p_200122_2_, Direction p_200122_3_) {
        return true;
    }

    public List<ItemStack> m_7381_(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        return new ArrayList<ItemStack>();
    }

    @Deprecated
    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Mode {
        PLACE{

            @Override
            public void onBuilderRemoved(EffectBlockTileEntity builder) {
                Level world = builder.m_58904_();
                if (world == null) {
                    return;
                }
                BlockPos targetPos = builder.m_58899_();
                BlockData targetBlock = builder.getRenderedBlock();
                if (builder.isUsingPaste()) {
                    world.m_46597_(targetPos, ((Block)OurBlocks.CONSTRUCTION_BLOCK.get()).m_49966_());
                    BlockEntity te = world.m_7702_(targetPos);
                    if (te instanceof ConstructionBlockTileEntity) {
                        ((ConstructionBlockTileEntity)te).setBlockState(targetBlock);
                    }
                    world.m_7967_((Entity)new ConstructionBlockEntity(world, targetPos, false));
                } else {
                    if (targetBlock.getState().m_60734_() instanceof LeavesBlock) {
                        targetBlock = new BlockData((BlockState)targetBlock.getState().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)), targetBlock.getTileData());
                    }
                    targetBlock.placeIn(BuildContext.builder().build((LevelAccessor)world), targetPos);
                    world.m_7260_(targetPos, targetBlock.getState(), targetBlock.getState(), 11);
                    BlockPos upPos = targetPos.m_7494_();
                    world.m_8055_(targetPos).m_60690_(world, targetPos, world.m_8055_(upPos).m_60734_(), upPos, false);
                }
            }
        }
        ,
        REMOVE{

            @Override
            public void onBuilderRemoved(EffectBlockTileEntity builder) {
                builder.m_58904_().m_7471_(builder.m_58899_(), false);
            }
        }
        ,
        REPLACE{

            @Override
            public void onBuilderRemoved(EffectBlockTileEntity builder) {
                EffectBlock.spawnEffectBlock((LevelAccessor)builder.m_58904_(), builder.m_58899_(), builder.getSourceBlock(), PLACE, builder.isUsingPaste());
            }
        };

        public static final Mode[] VALUES;

        public abstract void onBuilderRemoved(EffectBlockTileEntity var1);

        static {
            VALUES = Mode.values();
        }
    }
}

