/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory.handle;

import com.direwolf20.buildinggadgets.common.tainted.inventory.handle.IObjectHandle;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public final class StackHandlerItemHandle
implements IObjectHandle<Item> {
    private final IItemHandler handler;
    private final int slot;

    public StackHandlerItemHandle(IItemHandler handler, int slot) {
        this.handler = handler;
        this.slot = slot;
    }

    @Override
    public Class<Item> getIndexClass() {
        return Item.class;
    }

    @Override
    public boolean shouldCleanup() {
        return this.getStack().m_41619_();
    }

    @Override
    public int match(IUniqueObject<?> item, int count, boolean simulate) {
        ItemStack stack = this.getStack();
        if (item.matches(stack)) {
            ItemStack resultStack = this.handler.extractItem(this.slot, count, simulate);
            return resultStack.m_41613_();
        }
        return 0;
    }

    @Override
    public Item getIndexObject() {
        return this.getStack().m_41720_();
    }

    @Override
    public int insert(IUniqueObject<?> item, int count, boolean simulate) {
        if (this.handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)this.handler;
            ItemStack stack = this.getStack();
            if (!stack.m_41619_() && !item.matches(stack)) {
                return 0;
            }
            ItemStack res = item.insertInto(stack, count);
            if (!simulate) {
                modifiable.setStackInSlot(this.slot, res);
            }
            return res.m_41613_() - stack.m_41613_();
        }
        return 0;
    }

    private ItemStack getStack() {
        return this.handler.getStackInSlot(this.slot);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StackHandlerItemHandle)) {
            return false;
        }
        StackHandlerItemHandle that = (StackHandlerItemHandle)o;
        if (this.slot != that.slot) {
            return false;
        }
        return this.handler.equals(that.handler);
    }

    public int hashCode() {
        int result = this.handler.hashCode();
        result = 31 * result + this.slot;
        return result;
    }
}

