/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.api.addons.datagen;

import com.smashingmods.chemlib.api.addons.registry.AddonRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.text.WordUtils;

public class ModLocalizationGenerator
extends LanguageProvider {
    private final AddonRegistry addonRegistry;

    public ModLocalizationGenerator(DataGenerator gen, AddonRegistry pAddonRegistry, String locale) {
        super(gen, pAddonRegistry.getModID(), locale);
        this.addonRegistry = pAddonRegistry;
    }

    protected void addTranslations() {
        String rawName;
        this.addonRegistry.getCompounds().forEach(compound -> {
            this.add(String.format("item.%s.%s", this.addonRegistry.getModID(), compound.getChemicalName()), WordUtils.capitalize((String)compound.getChemicalName().replace("_", " ")));
            if (!compound.getChemicalDescription().isEmpty()) {
                this.add(String.format("%s.jei.compound.%s.description", this.addonRegistry.getModID(), compound.getChemicalName()), compound.getChemicalDescription());
            }
        });
        this.addonRegistry.getCompoundItemsAsStream().forEach(item -> {
            String name = item.getChemicalName();
            String itemType = item.getItemType().m_7912_();
            this.add(String.format("item.%s.%s_%s", this.addonRegistry.getModID(), name, itemType), WordUtils.capitalize((String)String.format("%s %s", name.replace("_", " "), itemType)));
        });
        this.addonRegistry.FLUID_TYPES.getEntries().stream().map(RegistryObject::get).forEach(fluidType -> {
            int density = fluidType.getDensity();
            String key = fluidType.getDescriptionId();
            String value = key.split("\\.")[key.split("\\.").length - 1];
            String translation = WordUtils.capitalize((String)String.format("%s%s", value.replace("_", " "), density < 0 ? " gas" : ""));
            this.add(key, translation);
            this.add(String.format("item.%s.%s_bucket", this.addonRegistry.getModID(), value), translation + " Bucket");
        });
        if (!this.addonRegistry.usedCustomCompoundsTab() && (rawName = this.addonRegistry.getCompoundsTab().m_40786_().getString()).startsWith("itemGroup.")) {
            this.add(rawName, String.format("%s Compounds", WordUtils.capitalize((String)this.addonRegistry.getModID())));
        }
        if (!this.addonRegistry.usedCustomCompoundsTab() && (rawName = this.addonRegistry.getBucketsTab().m_40786_().getString()).startsWith("itemGroup.")) {
            this.add(rawName, String.format("%s Fluids", WordUtils.capitalize((String)this.addonRegistry.getModID())));
        }
    }
}

