/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.registry;

import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistries;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import earth.terrarium.chipped.common.block.SpecialLanternBlock;
import earth.terrarium.chipped.common.block.SpecialPointedDripstoneBlock;
import earth.terrarium.chipped.common.block.WorkbenchBlock;
import earth.terrarium.chipped.common.menu.ChippedMenu;
import earth.terrarium.chipped.common.palette.Palette;
import earth.terrarium.chipped.common.registry.ModItems;
import earth.terrarium.chipped.common.registry.ModMenus;
import earth.terrarium.chipped.common.registry.ModRecipeTypes;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.CryingObsidianBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.MelonBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.MudBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RootsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.SpongeBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModBlocks {
    public static final ResourcefulRegistry<Block> BLOCKS = ResourcefulRegistries.create((Registry)Registry.f_122824_, (String)"chipped");
    public static final ResourcefulRegistry<Block> BENCHES = ResourcefulRegistries.create(BLOCKS);
    public static final TagKey<Block> SOUL_SAND_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("chipped", "soul_sand"));
    public static final TagKey<Block> BOOKSHELF_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("chipped", "bookshelf"));
    public static final RegistryEntry<Block> BOTANIST_WORKBENCH = BENCHES.register("botanist_workbench", () -> new WorkbenchBlock((id, inventory, access) -> new ChippedMenu(id, inventory, access, ModMenus.BOTANIST_WORKBENCH.get(), ModRecipeTypes.BOTANIST_WORKBENCH_TYPE.get(), (Block)BOTANIST_WORKBENCH.get()), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_()));
    public static final RegistryEntry<Block> GLASSBLOWER = BENCHES.register("glassblower", () -> new WorkbenchBlock((id, inventory, access) -> new ChippedMenu(id, inventory, access, ModMenus.GLASSBLOWER.get(), ModRecipeTypes.GLASSBLOWER_TYPE.get(), (Block)GLASSBLOWER.get()), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_()));
    public static final RegistryEntry<Block> CARPENTERS_TABLE = BENCHES.register("carpenters_table", () -> new WorkbenchBlock((id, inventory, access) -> new ChippedMenu(id, inventory, access, ModMenus.CARPENTERS_TABLE.get(), ModRecipeTypes.CARPENTERS_TABLE_TYPE.get(), (Block)CARPENTERS_TABLE.get()), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_()));
    public static final RegistryEntry<Block> LOOM_TABLE = BENCHES.register("loom_table", () -> new WorkbenchBlock((id, inventory, access) -> new ChippedMenu(id, inventory, access, ModMenus.LOOM_TABLE.get(), ModRecipeTypes.LOOM_TABLE_TYPE.get(), (Block)LOOM_TABLE.get()), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_()));
    public static final RegistryEntry<Block> MASON_TABLE = BENCHES.register("mason_table", () -> new WorkbenchBlock((id, inventory, access) -> new ChippedMenu(id, inventory, access, ModMenus.MASON_TABLE.get(), ModRecipeTypes.MASON_TABLE_TYPE.get(), (Block)MASON_TABLE.get()), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_()));
    public static final RegistryEntry<Block> ALCHEMY_BENCH = BENCHES.register("alchemy_bench", () -> new WorkbenchBlock((id, inventory, access) -> new ChippedMenu(id, inventory, access, ModMenus.ALCHEMY_BENCH.get(), ModRecipeTypes.ALCHEMY_BENCH_TYPE.get(), (Block)ALCHEMY_BENCH.get()), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_()));
    public static final RegistryEntry<Block> TINKERING_TABLE = BENCHES.register("tinkering_table", () -> new WorkbenchBlock((id, inventory, access) -> new ChippedMenu(id, inventory, access, ModMenus.TINKERING_TABLE.get(), ModRecipeTypes.TINKERING_TABLE_TYPE.get(), (Block)TINKERING_TABLE.get()), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_()));
    public static final ResourcefulRegistry<Block> AMETHYST_BLOCK = ModBlocks.createRegistry(Blocks.f_152490_, Palette.STONE);
    public static final ResourcefulRegistry<Block> COAL_BLOCK = ModBlocks.createRegistry(Blocks.f_50353_, Palette.STONE);
    public static final ResourcefulRegistry<Block> CRYING_OBSIDIAN = ModBlocks.createRegistry(Blocks.f_50723_, Palette.STONE, CryingObsidianBlock::new);
    public static final ResourcefulRegistry<Block> LODESTONE = ModBlocks.createRegistry(Blocks.f_50729_, Palette.LODESTONE);
    public static final ResourcefulRegistry<Block> LAPIS_BLOCK = ModBlocks.createRegistry(Blocks.f_50060_, Palette.STONE);
    public static final ResourcefulRegistry<Block> DIAMOND_BLOCK = ModBlocks.createRegistry(Blocks.f_50090_, Palette.DIAMOND_BLOCK);
    public static final ResourcefulRegistry<Block> EMERALD_BLOCK = ModBlocks.createRegistry(Blocks.f_50268_, Palette.EMERALD_BLOCK);
    public static final ResourcefulRegistry<Block> GOLD_BLOCK = ModBlocks.createRegistry(Blocks.f_50074_, Palette.DIAMOND_BLOCK);
    public static final ResourcefulRegistry<Block> IRON_BLOCK = ModBlocks.createRegistry(Blocks.f_50075_, Palette.METAL);
    public static final ResourcefulRegistry<Block> NETHERITE_BLOCK = ModBlocks.createRegistry(Blocks.f_50721_, Palette.NETHERITE_BLOCK);
    public static final ResourcefulRegistry<Block> SPONGE = ModBlocks.createRegistry(Blocks.f_50056_, Palette.SPONGE, SpongeBlock::new);
    public static final ResourcefulRegistry<Block> GLOWSTONE = ModBlocks.createRegistry(Blocks.f_50141_, Palette.GLOWSTONE);
    public static final ResourcefulRegistry<Block> WAXED_COPPER_BLOCK = ModBlocks.createRegistry(Blocks.f_152571_, Palette.COPPER_BLOCK);
    public static final ResourcefulRegistry<Block> WAXED_EXPOSED_COPPER = ModBlocks.createRegistry(Blocks.f_152573_, Palette.COPPER_BLOCK);
    public static final ResourcefulRegistry<Block> WAXED_WEATHERED_COPPER = ModBlocks.createRegistry(Blocks.f_152572_, Palette.COPPER_BLOCK);
    public static final ResourcefulRegistry<Block> WAXED_OXIDIZED_COPPER = ModBlocks.createRegistry(Blocks.f_152574_, Palette.COPPER_BLOCK);
    public static final ResourcefulRegistry<Block> BLUE_ICE = ModBlocks.createRegistry(Blocks.f_50568_, Palette.STONE);
    public static final ResourcefulRegistry<Block> DIRT = ModBlocks.createRegistry(Blocks.f_50493_, Palette.STONE);
    public static final ResourcefulRegistry<Block> ICE = ModBlocks.createRegistry(Blocks.f_50126_, Palette.STONE);
    public static final ResourcefulRegistry<Block> PACKED_ICE = ModBlocks.createRegistry(Blocks.f_50354_, Palette.STONE);
    public static final ResourcefulRegistry<Block> SNOW_BLOCK = ModBlocks.createRegistry(Blocks.f_50127_, Palette.STONE);
    public static final ResourcefulRegistry<Block> CLAY = ModBlocks.createRegistry(Blocks.f_50129_, Palette.CLAY);
    public static final ResourcefulRegistry<Block> MUD = ModBlocks.createRegistry(Blocks.f_220864_, Palette.MUD, MudBlock::new);
    public static final ResourcefulRegistry<Block> PACKED_MUD = ModBlocks.createRegistry(Blocks.f_220843_, Palette.MUD);
    public static final ResourcefulRegistry<Block> ACACIA_LEAVES = ModBlocks.createRegistry(Blocks.f_50054_, Palette.LEAVES);
    public static final ResourcefulRegistry<Block> BIRCH_LEAVES = ModBlocks.createRegistry(Blocks.f_50052_, Palette.LEAVES);
    public static final ResourcefulRegistry<Block> DARK_OAK_LEAVES = ModBlocks.createRegistry(Blocks.f_50055_, Palette.LEAVES);
    public static final ResourcefulRegistry<Block> JUNGLE_LEAVES = ModBlocks.createRegistry(Blocks.f_50053_, Palette.LEAVES);
    public static final ResourcefulRegistry<Block> MANGROVE_ROOTS = ModBlocks.createRegistry(Blocks.f_220833_, Palette.ROOTS);
    public static final ResourcefulRegistry<Block> OAK_LEAVES = ModBlocks.createRegistry(Blocks.f_50050_, Palette.LEAVES);
    public static final ResourcefulRegistry<Block> SPRUCE_LEAVES = ModBlocks.createRegistry(Blocks.f_50051_, Palette.LEAVES);
    public static final ResourcefulRegistry<Block> OCHRE_FROGLIGHT = ModBlocks.createRegistry(Blocks.f_220859_, Palette.FROGLIGHT);
    public static final ResourcefulRegistry<Block> PEARLESCENT_FROGLIGHT = ModBlocks.createRegistry(Blocks.f_220861_, Palette.FROGLIGHT);
    public static final ResourcefulRegistry<Block> VERDANT_FROGLIGHT = ModBlocks.createRegistry(Blocks.f_220860_, Palette.FROGLIGHT);
    public static final ResourcefulRegistry<Block> BONE_BLOCK = ModBlocks.createRegistry(Blocks.f_50453_, Palette.BONE_BLOCK, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> BROWN_MUSHROOM_BLOCK = ModBlocks.createRegistry(Blocks.f_50180_, Palette.MUSHROOM_BLOCK);
    public static final ResourcefulRegistry<Block> RED_MUSHROOM_BLOCK = ModBlocks.createRegistry(Blocks.f_50181_, Palette.RED_MUSHROOM_BLOCK);
    public static final ResourcefulRegistry<Block> BROWN_MUSHROOM = ModBlocks.createRegistry(Blocks.f_50072_, Palette.MUSHROOM, b -> new MushroomBlock(b, () -> TreeFeatures.f_195121_));
    public static final ResourcefulRegistry<Block> RED_MUSHROOM = ModBlocks.createRegistry(Blocks.f_50073_, Palette.MUSHROOM, b -> new MushroomBlock(b, () -> TreeFeatures.f_195122_));
    public static final ResourcefulRegistry<Block> COBWEB = ModBlocks.createRegistry(Blocks.f_50033_, Palette.COBWEB, WebBlock::new);
    public static final ResourcefulRegistry<Block> MUSHROOM_STEM = ModBlocks.createRegistry(Blocks.f_50182_, Palette.MUSHROOM_STEM, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> GRAVEL = ModBlocks.createRegistry(Blocks.f_49994_, Palette.GRAVEL, FallingBlock::new);
    public static final ResourcefulRegistry<Block> HAY_BLOCK = ModBlocks.createRegistry(Blocks.f_50335_, Palette.HAY_BLOCK, HayBlock::new);
    public static final ResourcefulRegistry<Block> MOSS_BLOCK = ModBlocks.createRegistry(Blocks.f_152544_, Palette.MOSS_BLOCK, MossBlock::new);
    public static final ResourcefulRegistry<Block> MELON = ModBlocks.createRegistry(Blocks.f_50186_, Palette.MELON, MelonBlock::new);
    public static final ResourcefulRegistry<Block> SHROOMLIGHT = ModBlocks.createRegistry(Blocks.f_50701_, Palette.SHROOMLIGHT);
    public static final ResourcefulRegistry<Block> SAND = ModBlocks.createRegistry(Blocks.f_49992_, Palette.SAND, FallingBlock::new);
    public static final ResourcefulRegistry<Block> SOUL_SAND = ModBlocks.createRegistry(Blocks.f_50135_, Palette.SOUL_SAND, SoulSandBlock::new);
    public static final ResourcefulRegistry<Block> CRIMSON_ROOTS = ModBlocks.createRegistry(Blocks.f_50654_, Palette.CRIMSON_ROOTS, RootsBlock::new);
    public static final ResourcefulRegistry<Block> WARPED_ROOTS = ModBlocks.createRegistry(Blocks.f_50693_, Palette.WARPED_ROOTS, RootsBlock::new);
    public static final ResourcefulRegistry<Block> DRIED_KELP_BLOCK = ModBlocks.createRegistry(Blocks.f_50577_, Palette.DRIED_KELP_BLOCK);
    public static final ResourcefulRegistry<Block> LILY_PAD = ModBlocks.createRegistry(Blocks.f_50196_, Palette.LILY_PAD, WaterlilyBlock::new, PlaceOnWaterBlockItem::new);
    public static final ResourcefulRegistry<Block> NETHER_SPROUTS = ModBlocks.createRegistry(Blocks.f_50694_, Palette.NETHER_SPROUTS);
    public static final ResourcefulRegistry<Block> NETHER_WART_BLOCK = ModBlocks.createRegistry(Blocks.f_50451_, Palette.WART_BLOCK);
    public static final ResourcefulRegistry<Block> PUMPKIN = ModBlocks.createRegistry(Blocks.f_50133_, Palette.PUMPKIN, PumpkinBlock::new);
    public static final ResourcefulRegistry<Block> CARVED_PUMPKIN = ModBlocks.createRegistry(Blocks.f_50143_, Palette.CARVED_PUMPKIN, CarvedPumpkinBlock::new);
    public static final ResourcefulRegistry<Block> JACK_O_LANTERN = ModBlocks.createRegistry(Blocks.f_50144_, Palette.CARVED_PUMPKIN, CarvedPumpkinBlock::new);
    public static final ResourcefulRegistry<Block> VINE = ModBlocks.createRegistry(Blocks.f_50191_, Palette.VINE, VineBlock::new);
    public static final ResourcefulRegistry<Block> WARPED_WART_BLOCK = ModBlocks.createRegistry(Blocks.f_50692_, Palette.WART_BLOCK);
    public static final ResourcefulRegistry<Block> CRIMSON_FUNGUS = ModBlocks.createRegistry(Blocks.f_50700_, Palette.MUSHROOM);
    public static final ResourcefulRegistry<Block> WARPED_FUNGUS = ModBlocks.createRegistry(Blocks.f_50691_, Palette.WARPED_FUNGUS);
    public static final ResourcefulRegistry<Block> ACACIA_PLANKS = ModBlocks.createRegistry(Blocks.f_50744_, Palette.PLANKS);
    public static final ResourcefulRegistry<Block> BIRCH_PLANKS = ModBlocks.createRegistry(Blocks.f_50742_, Palette.PLANKS);
    public static final ResourcefulRegistry<Block> DARK_OAK_PLANKS = ModBlocks.createRegistry(Blocks.f_50745_, Palette.PLANKS);
    public static final ResourcefulRegistry<Block> JUNGLE_PLANKS = ModBlocks.createRegistry(Blocks.f_50743_, Palette.PLANKS);
    public static final ResourcefulRegistry<Block> MANGROVE_PLANKS = ModBlocks.createRegistry(Blocks.f_220865_, Palette.MANGROVE_PLANKS);
    public static final ResourcefulRegistry<Block> OAK_PLANKS = ModBlocks.createRegistry(Blocks.f_50705_, Palette.PLANKS);
    public static final ResourcefulRegistry<Block> SPRUCE_PLANKS = ModBlocks.createRegistry(Blocks.f_50741_, Palette.PLANKS);
    public static final ResourcefulRegistry<Block> CRIMSON_PLANKS = ModBlocks.createRegistry(Blocks.f_50655_, Palette.PLANKS);
    public static final ResourcefulRegistry<Block> WARPED_PLANKS = ModBlocks.createRegistry(Blocks.f_50656_, Palette.PLANKS);
    public static final ResourcefulRegistry<Block> ACACIA_LOG = ModBlocks.createRegistry(Blocks.f_50003_, Palette.LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> BIRCH_LOG = ModBlocks.createRegistry(Blocks.f_50001_, Palette.LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> DARK_OAK_LOG = ModBlocks.createRegistry(Blocks.f_50004_, Palette.LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> JUNGLE_LOG = ModBlocks.createRegistry(Blocks.f_50002_, Palette.LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> MANGROVE_LOG = ModBlocks.createRegistry(Blocks.f_220832_, Palette.LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> OAK_LOG = ModBlocks.createRegistry(Blocks.f_49999_, Palette.LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> SPRUCE_LOG = ModBlocks.createRegistry(Blocks.f_50000_, Palette.LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> CRIMSON_STEM = ModBlocks.createRegistry(Blocks.f_50695_, Palette.CRIMSON_STEM, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> WARPED_STEM = ModBlocks.createRegistry(Blocks.f_50686_, Palette.WARPED_STEM, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> BARREL = ModBlocks.createRegistry(Blocks.f_50618_, Palette.BARREL, BarrelBlock::new);
    public static final ResourcefulRegistry<Block> BOOKSHELF = ModBlocks.createRegistry(Blocks.f_50078_, Palette.BOOKSHELF);
    public static final ResourcefulRegistry<Block> LADDER = ModBlocks.createRegistry(Blocks.f_50155_, Palette.LADDER, LadderBlock::new);
    public static final ResourcefulRegistry<Block> STRIPPED_ACACIA_LOG = ModBlocks.createRegistry(Blocks.f_50008_, Palette.STRIPPED_LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> STRIPPED_BIRCH_LOG = ModBlocks.createRegistry(Blocks.f_50006_, Palette.STRIPPED_LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> STRIPPED_DARK_OAK_LOG = ModBlocks.createRegistry(Blocks.f_50009_, Palette.STRIPPED_LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> STRIPPED_JUNGLE_LOG = ModBlocks.createRegistry(Blocks.f_50007_, Palette.STRIPPED_LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> STRIPPED_MANGROVE_LOG = ModBlocks.createRegistry(Blocks.f_220835_, Palette.STRIPPED_MANGROVE_LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> STRIPPED_OAK_LOG = ModBlocks.createRegistry(Blocks.f_50010_, Palette.STRIPPED_LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> STRIPPED_SPRUCE_LOG = ModBlocks.createRegistry(Blocks.f_50005_, Palette.STRIPPED_LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> STRIPPED_WARPED_STEM = ModBlocks.createRegistry(Blocks.f_50687_, Palette.STRIPPED_LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> STRIPPED_CRIMSON_STEM = ModBlocks.createRegistry(Blocks.f_50696_, Palette.STRIPPED_LOG, RotatedPillarBlock::new);
    public static final ResourcefulRegistry<Block> ACACIA_DOOR = ModBlocks.createRegistry(Blocks.f_50487_, Palette.ACACIA_DOOR, DoorBlock::new);
    public static final ResourcefulRegistry<Block> BIRCH_DOOR = ModBlocks.createRegistry(Blocks.f_50485_, Palette.BIRCH_DOOR, DoorBlock::new);
    public static final ResourcefulRegistry<Block> DARK_OAK_DOOR = ModBlocks.createRegistry(Blocks.f_50488_, Palette.DARK_OAK_DOOR, DoorBlock::new);
    public static final ResourcefulRegistry<Block> JUNGLE_DOOR = ModBlocks.createRegistry(Blocks.f_50486_, Palette.JUNGLE_DOOR, DoorBlock::new);
    public static final ResourcefulRegistry<Block> MANGROVE_DOOR = ModBlocks.createRegistry(Blocks.f_220853_, Palette.MANGROVE_DOOR, DoorBlock::new);
    public static final ResourcefulRegistry<Block> OAK_DOOR = ModBlocks.createRegistry(Blocks.f_50154_, Palette.DOOR, DoorBlock::new);
    public static final ResourcefulRegistry<Block> SPRUCE_DOOR = ModBlocks.createRegistry(Blocks.f_50484_, Palette.SPRUCE_DOOR, DoorBlock::new);
    public static final ResourcefulRegistry<Block> CRIMSON_DOOR = ModBlocks.createRegistry(Blocks.f_50671_, Palette.CRIMSON_DOOR, DoorBlock::new);
    public static final ResourcefulRegistry<Block> WARPED_DOOR = ModBlocks.createRegistry(Blocks.f_50672_, Palette.WARPED_DOOR, DoorBlock::new);
    public static final ResourcefulRegistry<Block> ACACIA_TRAPDOOR = ModBlocks.createRegistry(Blocks.f_50220_, Palette.ACACIA_TRAPDOOR, TrapDoorBlock::new);
    public static final ResourcefulRegistry<Block> BIRCH_TRAPDOOR = ModBlocks.createRegistry(Blocks.f_50218_, Palette.TRAPDOOR, TrapDoorBlock::new);
    public static final ResourcefulRegistry<Block> DARK_OAK_TRAPDOOR = ModBlocks.createRegistry(Blocks.f_50221_, Palette.TRAPDOOR, TrapDoorBlock::new);
    public static final ResourcefulRegistry<Block> JUNGLE_TRAPDOOR = ModBlocks.createRegistry(Blocks.f_50219_, Palette.JUNGLE_TRAPDOOR, TrapDoorBlock::new);
    public static final ResourcefulRegistry<Block> MANGROVE_TRAPDOOR = ModBlocks.createRegistry(Blocks.f_220842_, Palette.MANGROVE_TRAPDOOR, TrapDoorBlock::new);
    public static final ResourcefulRegistry<Block> OAK_TRAPDOOR = ModBlocks.createRegistry(Blocks.f_50216_, Palette.OAK_TRAPDOOR, TrapDoorBlock::new);
    public static final ResourcefulRegistry<Block> SPRUCE_TRAPDOOR = ModBlocks.createRegistry(Blocks.f_50217_, Palette.SPRUCE_TRAPDOOR, TrapDoorBlock::new);
    public static final ResourcefulRegistry<Block> CRIMSON_TRAPDOOR = ModBlocks.createRegistry(Blocks.f_50663_, Palette.CRIMSON_TRAPDOOR, TrapDoorBlock::new);
    public static final ResourcefulRegistry<Block> WARPED_TRAPDOOR = ModBlocks.createRegistry(Blocks.f_50664_, Palette.WARPED_TRAPDOOR, TrapDoorBlock::new);
    public static final Pair<ResourcefulRegistry<Block>, ResourcefulRegistry<Block>> TORCH = ModBlocks.createTorchRegistry(Blocks.f_50081_, Blocks.f_50082_, Palette.TORCH, TorchBlock::new, WallTorchBlock::new);
    public static final ResourcefulRegistry<Block> GLASS = ModBlocks.createRegistry(Blocks.f_50058_, Palette.GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50185_, Palette.GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> BLACK_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50215_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> BLACK_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50371_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> BLUE_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50211_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> BLUE_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50367_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> BROWN_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50212_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> BROWN_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50368_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> CYAN_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50209_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> CYAN_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50365_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> GRAY_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50207_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> GRAY_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50363_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> GREEN_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50213_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> GREEN_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50369_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> LIGHT_BLUE_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50203_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> LIGHT_BLUE_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50306_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> LIGHT_GRAY_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50208_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> LIGHT_GRAY_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50364_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> LIME_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50205_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> LIME_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50361_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> MAGENTA_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50202_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> MAGENTA_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50305_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> ORANGE_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50148_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> ORANGE_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50304_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> PINK_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50206_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> PINK_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50362_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> PURPLE_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50210_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> PURPLE_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50366_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> RED_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50214_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> RED_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50370_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> WHITE_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50147_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> WHITE_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50303_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> YELLOW_STAINED_GLASS = ModBlocks.createRegistry(Blocks.f_50204_, Palette.STAINED_GLASS, GlassBlock::new);
    public static final ResourcefulRegistry<Block> YELLOW_STAINED_GLASS_PANE = ModBlocks.createRegistry(Blocks.f_50307_, Palette.STAINED_GLASS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> BLACK_WOOL = ModBlocks.createRegistry(Blocks.f_50109_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> BLUE_WOOL = ModBlocks.createRegistry(Blocks.f_50105_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> BROWN_WOOL = ModBlocks.createRegistry(Blocks.f_50106_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> CYAN_WOOL = ModBlocks.createRegistry(Blocks.f_50103_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> GRAY_WOOL = ModBlocks.createRegistry(Blocks.f_50101_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> GREEN_WOOL = ModBlocks.createRegistry(Blocks.f_50107_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> LIGHT_BLUE_WOOL = ModBlocks.createRegistry(Blocks.f_50097_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> LIGHT_GRAY_WOOL = ModBlocks.createRegistry(Blocks.f_50102_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> LIME_WOOL = ModBlocks.createRegistry(Blocks.f_50099_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> MAGENTA_WOOL = ModBlocks.createRegistry(Blocks.f_50096_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> ORANGE_WOOL = ModBlocks.createRegistry(Blocks.f_50042_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> PINK_WOOL = ModBlocks.createRegistry(Blocks.f_50100_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> PURPLE_WOOL = ModBlocks.createRegistry(Blocks.f_50104_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> RED_WOOL = ModBlocks.createRegistry(Blocks.f_50108_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> WHITE_WOOL = ModBlocks.createRegistry(Blocks.f_50041_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> YELLOW_WOOL = ModBlocks.createRegistry(Blocks.f_50098_, Palette.WOOL);
    public static final ResourcefulRegistry<Block> BLACK_CARPET = ModBlocks.createRegistry(Blocks.f_50351_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> BLUE_CARPET = ModBlocks.createRegistry(Blocks.f_50347_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> BROWN_CARPET = ModBlocks.createRegistry(Blocks.f_50348_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> CYAN_CARPET = ModBlocks.createRegistry(Blocks.f_50345_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> GRAY_CARPET = ModBlocks.createRegistry(Blocks.f_50343_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> GREEN_CARPET = ModBlocks.createRegistry(Blocks.f_50349_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> LIGHT_BLUE_CARPET = ModBlocks.createRegistry(Blocks.f_50339_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> LIGHT_GRAY_CARPET = ModBlocks.createRegistry(Blocks.f_50344_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> LIME_CARPET = ModBlocks.createRegistry(Blocks.f_50341_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> MAGENTA_CARPET = ModBlocks.createRegistry(Blocks.f_50338_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> ORANGE_CARPET = ModBlocks.createRegistry(Blocks.f_50337_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> PINK_CARPET = ModBlocks.createRegistry(Blocks.f_50342_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> PURPLE_CARPET = ModBlocks.createRegistry(Blocks.f_50346_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> RED_CARPET = ModBlocks.createRegistry(Blocks.f_50350_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> WHITE_CARPET = ModBlocks.createRegistry(Blocks.f_50336_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> YELLOW_CARPET = ModBlocks.createRegistry(Blocks.f_50340_, Palette.WOOL, CarpetBlock::new);
    public static final ResourcefulRegistry<Block> ANCIENT_DEBRIS = ModBlocks.createRegistry(Blocks.f_50722_, Palette.STONE);
    public static final ResourcefulRegistry<Block> ANDESITE = ModBlocks.createRegistry(Blocks.f_50334_, Palette.STONE);
    public static final ResourcefulRegistry<Block> BASALT = ModBlocks.createRegistry(Blocks.f_50137_, Palette.BASALT);
    public static final ResourcefulRegistry<Block> BLACKSTONE = ModBlocks.createRegistry(Blocks.f_50730_, Palette.BLACKSTONE);
    public static final ResourcefulRegistry<Block> CALCITE = ModBlocks.createRegistry(Blocks.f_152497_, Palette.STONE);
    public static final ResourcefulRegistry<Block> COBBLESTONE = ModBlocks.createRegistry(Blocks.f_50652_, Palette.STONE);
    public static final ResourcefulRegistry<Block> DARK_PRISMARINE = ModBlocks.createRegistry(Blocks.f_50379_, Palette.DARK_PRISMARINE);
    public static final ResourcefulRegistry<Block> DEEPSLATE = ModBlocks.createRegistry(Blocks.f_152550_, Palette.DEEPSLATE);
    public static final ResourcefulRegistry<Block> DIORITE = ModBlocks.createRegistry(Blocks.f_50228_, Palette.STONE);
    public static final ResourcefulRegistry<Block> DRIPSTONE_BLOCK = ModBlocks.createRegistry(Blocks.f_152537_, Palette.STONE);
    public static final ResourcefulRegistry<Block> END_STONE = ModBlocks.createRegistry(Blocks.f_50259_, Palette.STONE);
    public static final ResourcefulRegistry<Block> GILDED_BLACKSTONE = ModBlocks.createRegistry(Blocks.f_50706_, Palette.GILDED_BLACKSTONE);
    public static final ResourcefulRegistry<Block> GRANITE = ModBlocks.createRegistry(Blocks.f_50122_, Palette.STONE);
    public static final ResourcefulRegistry<Block> MAGMA_BLOCK = ModBlocks.createRegistry(Blocks.f_50450_, Palette.STONE);
    public static final ResourcefulRegistry<Block> MOSSY_COBBLESTONE = ModBlocks.createRegistry(Blocks.f_50079_, Palette.STONE);
    public static final ResourcefulRegistry<Block> MOSSY_STONE_BRICKS = ModBlocks.createRegistry(Blocks.f_50223_, Palette.MOSSY_STONE_BRICKS);
    public static final ResourcefulRegistry<Block> NETHER_BRICKS = ModBlocks.createRegistry(Blocks.f_50197_, Palette.STONE);
    public static final ResourcefulRegistry<Block> NETHERRACK = ModBlocks.createRegistry(Blocks.f_50134_, Palette.STONE);
    public static final ResourcefulRegistry<Block> OBSIDIAN = ModBlocks.createRegistry(Blocks.f_50080_, Palette.STONE);
    public static final ResourcefulRegistry<Block> PRISMARINE = ModBlocks.createRegistry(Blocks.f_50377_, Palette.PRISMARINE);
    public static final ResourcefulRegistry<Block> PURPUR_BLOCK = ModBlocks.createRegistry(Blocks.f_50492_, Palette.PURPUR_BLOCK);
    public static final ResourcefulRegistry<Block> QUARTZ_BLOCK = ModBlocks.createRegistry(Blocks.f_50333_, Palette.QUARTZ_BLOCK);
    public static final ResourcefulRegistry<Block> RAW_COPPER_BLOCK = ModBlocks.createRegistry(Blocks.f_152599_, Palette.STONE);
    public static final ResourcefulRegistry<Block> RAW_GOLD_BLOCK = ModBlocks.createRegistry(Blocks.f_152600_, Palette.STONE);
    public static final ResourcefulRegistry<Block> RAW_IRON_BLOCK = ModBlocks.createRegistry(Blocks.f_152598_, Palette.STONE);
    public static final ResourcefulRegistry<Block> RED_NETHER_BRICKS = ModBlocks.createRegistry(Blocks.f_50452_, Palette.STONE);
    public static final ResourcefulRegistry<Block> RED_SANDSTONE = ModBlocks.createRegistry(Blocks.f_50394_, Palette.STONE);
    public static final ResourcefulRegistry<Block> SANDSTONE = ModBlocks.createRegistry(Blocks.f_50062_, Palette.STONE);
    public static final ResourcefulRegistry<Block> STONE = ModBlocks.createRegistry(Blocks.f_50069_, Palette.BASE_STONE);
    public static final ResourcefulRegistry<Block> SMOOTH_STONE = ModBlocks.createRegistry(Blocks.f_50470_, Palette.STONE);
    public static final ResourcefulRegistry<Block> TUFF = ModBlocks.createRegistry(Blocks.f_152496_, Palette.STONE);
    public static final ResourcefulRegistry<Block> TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50352_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> BLACK_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50302_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> BLUE_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50298_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> BROWN_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50299_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> CYAN_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50296_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> GRAY_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50294_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> GREEN_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50300_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> LIGHT_BLUE_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50290_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> LIGHT_GRAY_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50295_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> LIME_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50292_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> MAGENTA_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50289_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> ORANGE_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50288_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> PINK_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50293_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> PURPLE_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50297_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> RED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50301_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> WHITE_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50287_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> YELLOW_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50291_, Palette.TERRACOTTA);
    public static final ResourcefulRegistry<Block> BLACK_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50541_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> BLUE_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50537_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> BROWN_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50538_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> CYAN_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50535_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> GRAY_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50533_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> GREEN_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50539_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> LIGHT_BLUE_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50529_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> LIGHT_GRAY_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50534_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> LIME_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50531_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> MAGENTA_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50528_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> ORANGE_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50527_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> PINK_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50532_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> PURPLE_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50536_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> RED_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50540_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> WHITE_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50526_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> YELLOW_GLAZED_TERRACOTTA = ModBlocks.createRegistry(Blocks.f_50530_, Palette.GLAZED_TERRACOTTA, GlazedTerracottaBlock::new);
    public static final ResourcefulRegistry<Block> BLACK_CONCRETE = ModBlocks.createRegistry(Blocks.f_50505_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> BLUE_CONCRETE = ModBlocks.createRegistry(Blocks.f_50501_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> BROWN_CONCRETE = ModBlocks.createRegistry(Blocks.f_50502_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> CYAN_CONCRETE = ModBlocks.createRegistry(Blocks.f_50499_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> GRAY_CONCRETE = ModBlocks.createRegistry(Blocks.f_50497_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> GREEN_CONCRETE = ModBlocks.createRegistry(Blocks.f_50503_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> LIGHT_BLUE_CONCRETE = ModBlocks.createRegistry(Blocks.f_50545_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> LIGHT_GRAY_CONCRETE = ModBlocks.createRegistry(Blocks.f_50498_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> LIME_CONCRETE = ModBlocks.createRegistry(Blocks.f_50495_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> MAGENTA_CONCRETE = ModBlocks.createRegistry(Blocks.f_50544_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> ORANGE_CONCRETE = ModBlocks.createRegistry(Blocks.f_50543_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> PINK_CONCRETE = ModBlocks.createRegistry(Blocks.f_50496_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> PURPLE_CONCRETE = ModBlocks.createRegistry(Blocks.f_50500_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> RED_CONCRETE = ModBlocks.createRegistry(Blocks.f_50504_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> WHITE_CONCRETE = ModBlocks.createRegistry(Blocks.f_50542_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> YELLOW_CONCRETE = ModBlocks.createRegistry(Blocks.f_50494_, Palette.CONCRETE);
    public static final ResourcefulRegistry<Block> BRICKS = ModBlocks.createRegistry(Blocks.f_50076_, Palette.BRICKS);
    public static final ResourcefulRegistry<Block> MUD_BRICKS = ModBlocks.createRegistry(Blocks.f_220844_, Palette.MUD);
    public static final ResourcefulRegistry<Block> POINTED_DRIPSTONE = ModBlocks.createRegistry(Blocks.f_152588_, Palette.POINTED_DRIPSTONE, SpecialPointedDripstoneBlock::new);
    public static final ResourcefulRegistry<Block> IRON_BARS = ModBlocks.createRegistry(Blocks.f_50183_, Palette.IRON_BARS, IronBarsBlock::new);
    public static final ResourcefulRegistry<Block> SEA_LANTERN = ModBlocks.createRegistry(Blocks.f_50386_, Palette.SEA_LANTERN);
    public static final ResourcefulRegistry<Block> REDSTONE_LAMP = ModBlocks.createRegistry(Blocks.f_50261_, Palette.REDSTONE_LAMP, RedstoneLampBlock::new);
    public static final ResourcefulRegistry<Block> REDSTONE_BLOCK = ModBlocks.createRegistry(Blocks.f_50330_, Palette.STONE);
    public static final ResourcefulRegistry<Block> LANTERN = ModBlocks.createRegistry(Blocks.f_50681_, Palette.LANTERN, LanternBlock::new);
    public static final ResourcefulRegistry<Block> SOUL_LANTERN = ModBlocks.createRegistry(Blocks.f_50682_, Palette.SOUL_LANTERN, LanternBlock::new);
    public static final ResourcefulRegistry<Block> SPECIAL_LANTERN = ModBlocks.registerSpecialLanterns("special_lantern", Palette.SPECIAL_LANTERN);
    public static final ResourcefulRegistry<Block> SPECIAL_SOUL_LANTERN = ModBlocks.registerSpecialLanterns("special_soul_lantern", Palette.SPECIAL_SOUL_LANTERN);
    public static final Pair<ResourcefulRegistry<Block>, ResourcefulRegistry<Block>> REDSTONE_TORCH = ModBlocks.createTorchRegistry(Blocks.f_50174_, Blocks.f_50123_, Palette.REDSTONE_TORCH, (p, o) -> new RedstoneTorchBlock(p), (p, o) -> new RedstoneWallTorchBlock(p));

    public static ResourcefulRegistry<Block> createRegistry(Block ref, Palette palette) {
        return ModBlocks.createRegistry(ref, palette, Block::new);
    }

    public static ResourcefulRegistry<Block> createRegistry(Block ref, Palette palette, Function<BlockBehaviour.Properties, Block> blockType) {
        return ModBlocks.createRegistry(ref, palette, blockType, BlockItem::new);
    }

    public static ResourcefulRegistry<Block> createRegistry(Block ref, Palette palette, Function<BlockBehaviour.Properties, Block> blockType, BiFunction<Block, Item.Properties, BlockItem> itemType) {
        ResourcefulRegistry registry = ResourcefulRegistries.create(BLOCKS);
        for (int i = 0; i < palette.getNames().length; ++i) {
            String id = palette.getName(i).formatted(Registry.f_122824_.m_7981_((Object)ref).m_135815_().toLowerCase(Locale.ROOT));
            registry.register(id, () -> (Block)blockType.apply(ModBlocks.createProperties(ref)));
        }
        ModItems.createItemRegistry((ResourcefulRegistry<Block>)registry, itemType);
        return registry;
    }

    public static Pair<ResourcefulRegistry<Block>, ResourcefulRegistry<Block>> createTorchRegistry(Block ref1, Block ref2, Palette palette, BiFunction<BlockBehaviour.Properties, ParticleOptions, Block> blockType1, BiFunction<BlockBehaviour.Properties, ParticleOptions, Block> blockType2) {
        ResourcefulRegistry registry1 = ResourcefulRegistries.create(BLOCKS);
        ResourcefulRegistry registry2 = ResourcefulRegistries.create(BLOCKS);
        ResourcefulRegistry itemRegistry = ResourcefulRegistries.create(ModItems.ITEMS);
        for (int i = 0; i < palette.getNames().length; ++i) {
            String id1 = palette.getName(i).formatted(Registry.f_122824_.m_7981_((Object)ref1).m_135815_().toLowerCase(Locale.ROOT));
            RegistryEntry torch1 = registry1.register(id1, () -> (Block)blockType1.apply(ModBlocks.createProperties(ref1), (ParticleOptions)ParticleTypes.f_123744_));
            String id2 = palette.getName(i).formatted(Registry.f_122824_.m_7981_((Object)ref2).m_135815_().toLowerCase(Locale.ROOT));
            RegistryEntry torch2 = registry2.register(id2, () -> (Block)blockType2.apply(ModBlocks.createProperties(ref2), (ParticleOptions)ParticleTypes.f_123744_));
            itemRegistry.register(torch1.getId().m_135815_(), () -> new StandingAndWallBlockItem((Block)torch1.get(), (Block)torch2.get(), new Item.Properties().m_41491_(ModItems.ITEM_GROUP)));
        }
        return Pair.of((Object)registry1, (Object)registry2);
    }

    public static ResourcefulRegistry<Block> registerSpecialLanterns(String block, Palette palette) {
        ResourcefulRegistry registry = ResourcefulRegistries.create(BLOCKS);
        String[] names = palette.getNames();
        registry.register(names[0].formatted(block), () -> new SpecialLanternBlock(ModBlocks.createProperties(Blocks.f_50681_), SpecialLanternBlock.CHONK_LANTERN_SHAPE));
        registry.register(names[1].formatted(block), () -> new SpecialLanternBlock(ModBlocks.createProperties(Blocks.f_50681_), SpecialLanternBlock.DONUT_LANTERN_SHAPE_EAST, SpecialLanternBlock.DONUT_LANTERN_SHAPE_NORTH));
        registry.register(names[2].formatted(block), () -> new SpecialLanternBlock(ModBlocks.createProperties(Blocks.f_50681_), SpecialLanternBlock.TALL_LANTERN_SHAPE));
        registry.register(names[3].formatted(block), () -> new SpecialLanternBlock(ModBlocks.createProperties(Blocks.f_50681_), SpecialLanternBlock.THICC_LANTERN_SHAPE));
        ModItems.createItemRegistry((ResourcefulRegistry<Block>)registry, BlockItem::new);
        return registry;
    }

    private static BlockBehaviour.Properties createProperties(Block ref) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)ref).m_222994_();
    }
}

