/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.init.CoreMobEffects;
import cofh.core.network.packet.client.EffectAddedPacket;
import cofh.core.network.packet.client.EffectRemovedPacket;
import cofh.lib.effect.CustomParticleMobEffect;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class EffectEvents {
    private static final int CLARITY_MOD = 20;

    private EffectEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleChorusFruitTeleportEvent(EntityTeleportEvent.ChorusFruit event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (entity.m_21023_((MobEffect)CoreMobEffects.ENDERFERENCE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEnderEntityTeleportEvent(EntityTeleportEvent.EnderEntity event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (entity.m_21023_((MobEffect)CoreMobEffects.ENDERFERENCE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEnderPearlTeleportEvent(EntityTeleportEvent.EnderPearl event) {
        if (event.isCanceled()) {
            return;
        }
        ServerPlayer entity = event.getPlayer();
        if (entity.m_21023_((MobEffect)CoreMobEffects.ENDERFERENCE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityStruckByLightningEvent(EntityStruckByLightningEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.m_21023_((MobEffect)CoreMobEffects.LIGHTNING_RESISTANCE.get())) {
                event.setCanceled(true);
            } else {
                living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SHOCKED.get(), 100, 0));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePotionColorEvent(PotionColorCalculationEvent event) {
        Collection effects = event.getEffects();
        if (effects.isEmpty()) {
            return;
        }
        Predicate<MobEffectInstance> hasCustomParticle = effect -> effect.m_19544_() instanceof CustomParticleMobEffect;
        if (effects.stream().anyMatch(hasCustomParticle)) {
            List nonCustom = effects.stream().filter(hasCustomParticle.negate()).collect(Collectors.toList());
            if (nonCustom.isEmpty()) {
                event.shouldHideParticles(true);
            } else {
                event.setColor(PotionUtils.m_43564_(nonCustom));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePotionAddEvent(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() instanceof CustomParticleMobEffect) {
            EffectAddedPacket.sendToClient(event.getEntity(), event.getEffectInstance());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePotionRemoveEvent(MobEffectEvent.Remove event) {
        MobEffectInstance effect = event.getEffectInstance();
        if (effect != null && effect.m_19544_() instanceof CustomParticleMobEffect) {
            EffectRemovedPacket.sendToClient(event.getEntity(), event.getEffectInstance());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleTargetChangeEvent(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)CoreMobEffects.TRUE_INVISIBILITY.get())) {
            float armor = Math.max(entity.m_21207_(), 0.1f) * 0.7f;
            event.modifyVisibility((double)(0.07f / armor));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleXpChangeEvent(PlayerXpEvent.XpChange event) {
        if (event.isCanceled() || event.getAmount() <= 0) {
            return;
        }
        Player player = event.getEntity();
        MobEffectInstance clarityEffect = player.m_21124_((MobEffect)CoreMobEffects.CLARITY.get());
        if (clarityEffect == null) {
            return;
        }
        event.setAmount(EffectEvents.getXPValue(event.getAmount(), clarityEffect.m_19564_()));
    }

    private static int getXPValue(int baseExp, int amplifier) {
        return baseExp * (100 + 20 * (1 + amplifier)) / 100;
    }
}

