/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.init.CoreBlocks;
import cofh.core.init.CoreMobEffects;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AreaUtils {
    public static final int HORZ_MAX = 32;
    public static final int VERT_MAX = 16;
    public static final Set<BlockState> REPLACEABLE_AIR = new ObjectOpenHashSet((Object[])new BlockState[]{Blocks.f_50016_.m_49966_(), Blocks.f_50627_.m_49966_()});
    public static final IEffectApplier IGNITE_ENTITIES = (target, duration, power, source) -> {
        if (!target.m_5825_() && !target.m_20069_() && target.m_20094_() <= 0) {
            target.m_20254_(duration / 20);
        }
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_21195_((MobEffect)CoreMobEffects.CHILLED.get());
        }
    };
    public static final IEffectApplier CHILL_ENTITIES = (target, duration, power, source) -> {
        if (target.m_20094_() > 0) {
            target.m_7311_(0);
        }
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.CHILLED.get(), duration, power));
        }
    };
    public static final IEffectApplier SUNDER_ENTITIES = (target, duration, power, source) -> {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SUNDERED.get(), duration, power));
        }
    };
    public static final IEffectApplier SHOCK_ENTITIES = (target, duration, power, source) -> {
        LivingEntity living;
        if (target instanceof LivingEntity && !(living = (LivingEntity)target).m_21023_((MobEffect)CoreMobEffects.LIGHTNING_RESISTANCE.get())) {
            living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SHOCKED.get(), duration, power));
        }
    };
    public static final IBlockTransformer FIRE_TRANSFORM = (world, pos, face, entity) -> {
        boolean succeeded = false;
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_() && BaseFireBlock.m_49255_((Level)world, (BlockPos)pos, (Direction)face)) {
            succeeded |= world.m_7731_(pos, BaseFireBlock.m_49245_((BlockGetter)world, (BlockPos)pos), 11);
        }
        return succeeded;
    };
    public static final IBlockTransformer FIRE_TRANSFORM_SPECIAL = (world, pos, face, entity) -> {
        boolean succeeded = false;
        BlockState state = world.m_8055_(pos);
        if (AreaUtils.isUnlitCampfire(state)) {
            succeeded = world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
        } else if (AreaUtils.isUnlitTNT(state)) {
            state.m_60734_().onCaughtFire(state, world, pos, Direction.UP, entity instanceof LivingEntity ? (LivingEntity)entity : null);
            succeeded = world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        } else if (state.m_60734_() == Blocks.f_50126_ || state.m_60734_() == Blocks.f_50449_) {
            succeeded = world.m_46597_(pos, Blocks.f_49990_.m_49966_());
        } else if (state.m_60734_() == Blocks.f_50125_) {
            succeeded = world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        return succeeded;
    };
    public static final IBlockTransformer ICE_TRANSFORM_TEMPORARY = (world, pos, face, entity) -> {
        boolean isFull;
        boolean succeeded = false;
        BlockState state = world.m_8055_(pos);
        if (AreaUtils.isLitCampfire(state)) {
            succeeded |= world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
        }
        if (world.m_46859_(pos) && AreaUtils.isValidSnowPosition(world, pos)) {
            succeeded |= world.m_46597_(pos, Blocks.f_50125_.m_49966_());
        }
        if (state.m_60734_() == Blocks.f_50083_) {
            succeeded |= world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        boolean bl = isFull = state.m_60734_() == Blocks.f_49990_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
        if (state.m_60767_() == Material.f_76305_ && isFull && state.m_60710_((LevelReader)world, pos) && world.m_45752_(state, pos, CollisionContext.m_82749_())) {
            succeeded |= world.m_46597_(pos, Blocks.f_50449_.m_49966_());
            world.m_186460_(pos, Blocks.f_50449_, MathHelper.nextInt(world.f_46441_, 60, 120));
        }
        boolean bl2 = isFull = state.m_60734_() == Blocks.f_49991_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
        if (state.m_60767_() == Material.f_76307_ && isFull && state.m_60710_((LevelReader)world, pos) && world.m_45752_(state, pos, CollisionContext.m_82749_())) {
            succeeded |= world.m_46597_(pos, ((Block)CoreBlocks.GLOSSED_MAGMA.get()).m_49966_());
            world.m_186460_(pos, (Block)CoreBlocks.GLOSSED_MAGMA.get(), MathHelper.nextInt(world.f_46441_, 60, 120));
        }
        return succeeded;
    };
    public static final IBlockTransformer ICE_TRANSFORM = (world, pos, face, entity) -> {
        boolean isFull;
        boolean succeeded = false;
        BlockState state = world.m_8055_(pos);
        if (AreaUtils.isLitCampfire(state)) {
            succeeded |= world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
        }
        if (world.m_46859_(pos) && AreaUtils.isValidSnowPosition(world, pos)) {
            succeeded |= world.m_46597_(pos, Blocks.f_50125_.m_49966_());
        }
        if (state.m_60734_() == Blocks.f_50083_) {
            succeeded |= world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        boolean bl = isFull = state.m_60734_() == Blocks.f_49990_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
        if (state.m_60767_() == Material.f_76305_ && isFull && state.m_60710_((LevelReader)world, pos) && world.m_45752_(state, pos, CollisionContext.m_82749_())) {
            succeeded |= world.m_46597_(pos, Blocks.f_50126_.m_49966_());
        }
        boolean bl2 = isFull = state.m_60734_() == Blocks.f_49991_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
        if (state.m_60767_() == Material.f_76307_ && isFull && state.m_60710_((LevelReader)world, pos) && world.m_45752_(state, pos, CollisionContext.m_82749_())) {
            succeeded |= world.m_46597_(pos, Blocks.f_50080_.m_49966_());
        }
        return succeeded;
    };
    public static final IBlockTransformer ICE_TRANSFORM_SURFACE = (world, pos, face, entity) -> {
        BlockPos above;
        BlockState frozenLava;
        boolean succeeded = false;
        BlockState state = world.m_8055_(pos);
        boolean permanentWater = true;
        boolean permanentLava = true;
        BlockState frozenWater = permanentWater ? Blocks.f_50126_.m_49966_() : Blocks.f_50449_.m_49966_();
        BlockState blockState = frozenLava = permanentLava ? Blocks.f_50080_.m_49966_() : ((Block)CoreBlocks.GLOSSED_MAGMA.get()).m_49966_();
        if (world.m_46859_(pos) && AreaUtils.isValidSnowPosition(world, pos)) {
            succeeded |= world.m_46597_(pos, Blocks.f_50125_.m_49966_());
        }
        if (world.m_8055_(above = pos.m_121945_(Direction.UP)).m_60795_()) {
            boolean isFull;
            boolean bl = isFull = state.m_60734_() == Blocks.f_49990_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            if (state.m_60767_() == Material.f_76305_ && isFull && state.m_60710_((LevelReader)world, pos) && world.m_45752_(state, pos, CollisionContext.m_82749_())) {
                succeeded |= world.m_46597_(pos, frozenWater);
                if (!permanentWater) {
                    world.m_186460_(pos, Blocks.f_50449_, MathHelper.nextInt(world.f_46441_, 60, 120));
                }
            }
            boolean bl2 = isFull = state.m_60734_() == Blocks.f_49991_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            if (state.m_60767_() == Material.f_76307_ && isFull && state.m_60710_((LevelReader)world, pos) && world.m_45752_(state, pos, CollisionContext.m_82749_())) {
                succeeded |= world.m_46597_(pos, frozenLava);
                if (!permanentLava) {
                    world.m_186460_(pos, (Block)CoreBlocks.GLOSSED_MAGMA.get(), MathHelper.nextInt(world.f_46441_, 60, 120));
                }
            }
        }
        return succeeded;
    };
    public static final IBlockTransformer SNOW_LAYER_TRANSFORM = (world, pos, face, entity) -> {
        boolean succeeded = false;
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == Blocks.f_50125_ && state.m_61138_((Property)BlockStateProperties.f_61417_)) {
            int val = (Integer)state.m_61143_((Property)BlockStateProperties.f_61417_) + 1;
            if (BlockStateProperties.f_61417_.m_6908_().contains(val)) {
                succeeded = world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(val)));
            }
        }
        return succeeded;
    };
    public static final IBlockTransformer EARTH_TRANSFORM = (world, pos, face, entity) -> {
        boolean succeeded = false;
        BlockState state = world.m_8055_(pos);
        Material material = state.m_60767_();
        if (material == Material.f_76278_ || material == Material.f_76314_ || state.m_60734_() instanceof SnowyDirtBlock) {
            succeeded |= Utils.destroyBlock(world, pos, true, entity);
        }
        return succeeded;
    };
    public static final IBlockTransformer LIGHTNING_TRANSFORM = (world, pos, face, entity) -> {
        boolean succeeded = false;
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_() && AreaUtils.isValidLightningBoltPosition(world, pos, 1.0)) {
            succeeded |= world.m_46597_(pos, ((Block)CoreBlocks.LIGHTNING_AIR.get()).m_49966_());
        }
        return succeeded;
    };
    public static final IBlockTransformer SIGNAL_AIR_TRANSFORM = AreaUtils.getConversionTransform(REPLACEABLE_AIR, ((Block)CoreBlocks.SIGNAL_AIR.get()).m_49966_(), false);
    public static final IBlockTransformer GLOW_AIR_TRANSFORM = AreaUtils.getConversionTransform(REPLACEABLE_AIR, ((Block)CoreBlocks.GLOW_AIR.get()).m_49966_(), false);
    public static final IEffectApplier GLOW_ENTITIES = (target, duration, power, source) -> {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19619_, duration, power));
            if (living.m_6336_() == MobType.f_21641_) {
                living.m_6469_(DamageSource.m_19373_((LivingEntity)(source instanceof LivingEntity ? (LivingEntity)source : null)), 4.0f);
                living.m_20254_(duration / 20);
            }
        }
    };
    public static final IBlockTransformer ENDER_AIR_TRANSFORM = AreaUtils.getConversionTransform(REPLACEABLE_AIR, ((Block)CoreBlocks.ENDER_AIR.get()).m_49966_(), false);
    public static final IEffectApplier ENDERFERE_ENTITIES = (target, duration, power, source) -> {
        if (target instanceof EnderMan || target instanceof Endermite) {
            LivingEntity living = (LivingEntity)target;
            living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.ENDERFERENCE.get(), duration, power));
            living.m_6469_(DamageSource.m_19373_((LivingEntity)(source instanceof LivingEntity ? (LivingEntity)source : null)), 4.0f);
        }
    };
    public static final IBlockTransformer MYCELIUM_TRANSFORM = AreaUtils.getConversionTransform((Set<BlockState>)new ObjectOpenHashSet((Object[])new BlockState[]{Blocks.f_50493_.m_49966_(), Blocks.f_50440_.m_49966_()}), Blocks.f_50195_.m_49966_(), true);
    public static final IBlockTransformer GRASS_TRANSFORM = AreaUtils.getConversionTransform(Blocks.f_50493_.m_49966_(), Blocks.f_50440_.m_49966_(), true);
    public static final IBlockTransformer GROW_MUSHROOMS = new IBlockTransformer(){

        @Override
        public boolean transformBlock(Level level, BlockPos pos, Direction face, @Nullable Entity entity) {
            Block below = level.m_8055_(pos.m_121945_(Direction.DOWN)).m_60734_();
            if (level.m_8055_(pos).m_60795_() && (below.equals(Blocks.f_50195_) || below.equals(Blocks.f_50599_))) {
                return level.m_46597_(pos, level.f_46441_.m_188499_() ? Blocks.f_50072_.m_49966_() : Blocks.f_50073_.m_49966_());
            }
            return false;
        }

        @Override
        public void transformSphere(Level levelIn, Vec3 pos, float radius, float chance, int max, @Nullable Entity entity) {
            float f = Math.min(32.0f, radius);
            float v = Math.min(16.0f, radius);
            float f2 = f * f;
            BlockPos origin = new BlockPos(pos);
            if (this.transformBlock(levelIn, origin.m_121945_(Direction.UP), Direction.DOWN, entity)) {
                --max;
            }
            for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)origin.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)origin.m_7637_((double)(f + 1.0f), (double)(v + 1.0f), (double)(f + 1.0f)))) {
                if (max <= 0) {
                    return;
                }
                double distance = iterPos.m_123331_((Vec3i)origin);
                if (!(distance < (double)f2) || !(levelIn.f_46441_.m_188500_() < 0.5 - distance / (double)f2) || !this.transformBlock(levelIn, iterPos, Direction.DOWN, entity)) continue;
                --max;
            }
        }
    };
    public static final IBlockTransformer GROW_PLANTS = (world, pos, face, entity) -> {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof BonemealableBlock) {
            BonemealableBlock growable = (BonemealableBlock)state.m_60734_();
            if (!world.f_46443_ && growable.m_7370_((BlockGetter)world, pos, state, world.f_46443_) && growable.m_214167_(world, world.f_46441_, pos, state)) {
                block4: {
                    try {
                        growable.m_214148_((ServerLevel)world, world.f_46441_, pos, state);
                    }
                    catch (Exception e) {
                        if (growable instanceof BambooBlock) break block4;
                        throw e;
                    }
                }
                return true;
            }
        }
        return false;
    };

    private AreaUtils() {
    }

    private static IBlockTransformer getConversionTransform(Set<BlockState> replaceable, BlockState replacement, boolean requireAir) {
        if (requireAir) {
            return (levelIn, pos, face, entity) -> {
                BlockPos above = pos.m_121945_(Direction.UP);
                if (levelIn.m_8055_(above).m_60795_() && replaceable.contains(levelIn.m_8055_(pos))) {
                    return levelIn.m_46597_(pos, replacement);
                }
                return false;
            };
        }
        return (levelIn, pos, face, entity) -> {
            if (replaceable.contains(levelIn.m_8055_(pos))) {
                return levelIn.m_46597_(pos, replacement);
            }
            return false;
        };
    }

    private static IBlockTransformer getConversionTransform(BlockState replaceable, BlockState replacement, boolean requireAir) {
        if (requireAir) {
            return (levelIn, pos, face, entity) -> {
                BlockPos above = pos.m_121945_(Direction.UP);
                if (levelIn.m_8055_(above).m_60795_() && replaceable.equals(levelIn.m_8055_(pos))) {
                    return levelIn.m_46597_(pos, replacement);
                }
                return false;
            };
        }
        return (levelIn, pos, face, entity) -> {
            if (replaceable.equals(levelIn.m_8055_(pos))) {
                return levelIn.m_46597_(pos, replacement);
            }
            return false;
        };
    }

    public static boolean isLitCampfire(BlockState state) {
        return state.m_60734_() instanceof CampfireBlock && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false;
    }

    public static boolean isUnlitCampfire(BlockState state) {
        return state.m_60734_() instanceof CampfireBlock && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) == false;
    }

    public static boolean isUnlitTNT(BlockState state) {
        return state.m_60734_() instanceof TntBlock;
    }

    public static List<Entity> getEntitiesInSphere(Level level, Vec3 center, double radius, @Nullable Entity exclude, Predicate<Entity> filter) {
        double r2 = radius * radius;
        Predicate<Entity> inSphere = entity -> AreaUtils.closestPointOnAABB(center, entity.m_20191_()).m_82546_(center).m_82556_() <= r2;
        return level.m_6249_(exclude, new AABB(center.f_82479_ - radius, center.f_82480_ - radius, center.f_82481_ - radius, center.f_82479_ + radius, center.f_82480_ + radius, center.f_82481_ + radius), inSphere.and(filter));
    }

    public static List<Entity> getEntitiesInCylinder(Level level, Vec3 center, double radius, double height, @Nullable Entity exclude, Predicate<Entity> filter) {
        double halfHeight = 0.5 * height;
        double r2 = radius * radius;
        Predicate<Entity> inCylinder = entity -> {
            Vec3 diff = AreaUtils.closestPointOnAABB(center, entity.m_20191_()).m_82546_(center);
            return Math.abs(diff.f_82480_) <= halfHeight && diff.m_165925_() <= r2;
        };
        return level.m_6249_(exclude, new AABB(center.f_82479_ - radius, center.f_82480_ - halfHeight, center.f_82481_ - radius, center.f_82479_ + radius, center.f_82480_ + halfHeight, center.f_82481_ + radius), inCylinder.and(filter));
    }

    public static Vec3 closestPointOnAABB(Vec3 point, AABB box) {
        return new Vec3(MathHelper.clamp(point.f_82479_, box.f_82288_, box.f_82291_), MathHelper.clamp(point.f_82480_, box.f_82289_, box.f_82292_), MathHelper.clamp(point.f_82481_, box.f_82290_, box.f_82293_));
    }

    public static void igniteNearbyEntities(Entity entity, Level levelIn, BlockPos pos, int radius, int duration) {
        AABB area = new AABB(pos.m_7918_(-radius, -radius, -radius), pos.m_7918_(1 + radius, 1 + radius, 1 + radius));
        List mobs = levelIn.m_6443_(LivingEntity.class, area, EntitySelector.f_20402_);
        mobs.removeIf(Entity::m_20069_);
        mobs.removeIf(Entity::m_5825_);
        mobs.removeIf(mob -> mob instanceof EnderMan);
        for (LivingEntity mob2 : mobs) {
            mob2.m_20254_(duration);
        }
    }

    public static void igniteNearbyGround(Entity entity, Level levelIn, BlockPos pos, int radius, double chance) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            double distance = blockpos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2)) continue;
            mutable.m_122178_(blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_());
            BlockState blockstate1 = levelIn.m_8055_((BlockPos)mutable);
            if (!blockstate1.m_60795_() || !AreaUtils.isValidFirePosition(levelIn, (BlockPos)mutable, chance)) continue;
            levelIn.m_46597_((BlockPos)mutable, ((FireBlock)Blocks.f_50083_).m_53470_((BlockGetter)levelIn, (BlockPos)mutable));
        }
    }

    public static void igniteSpecial(Entity entity, Level levelIn, BlockPos pos, int radius, boolean campfire, boolean tnt, @Nullable Entity igniter) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            double distance = blockpos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2)) continue;
            BlockState state = levelIn.m_8055_(blockpos);
            if (campfire && AreaUtils.isUnlitCampfire(state)) {
                levelIn.m_46597_(blockpos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
                continue;
            }
            if (!tnt || !AreaUtils.isUnlitTNT(state)) continue;
            state.m_60734_().onCaughtFire(state, levelIn, blockpos, Direction.UP, igniter instanceof LivingEntity ? (LivingEntity)igniter : null);
            levelIn.m_46597_(blockpos, Blocks.f_50016_.m_49966_());
        }
    }

    public static boolean isValidFirePosition(Level levelIn, BlockPos pos, double chance) {
        BlockPos below = pos.m_7495_();
        BlockState state = levelIn.m_8055_(below);
        if (Block.m_49918_((VoxelShape)state.m_60812_((BlockGetter)levelIn, below), (Direction)Direction.UP)) {
            return state.m_60767_().m_76335_() || levelIn.f_46441_.m_188500_() < chance;
        }
        return false;
    }

    public static void freezeNearbyGround(Entity entity, Level levelIn, BlockPos pos, int radius) {
        BlockState state = Blocks.f_50125_.m_49966_();
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            double distance = blockpos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2)) continue;
            mutable.m_122178_(blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_());
            BlockState blockstate1 = levelIn.m_8055_((BlockPos)mutable);
            if (!blockstate1.m_60795_() || !(((Biome)levelIn.m_204166_((BlockPos)mutable).m_203334_()).m_47505_(blockpos) < 0.8f) || !AreaUtils.isValidSnowPosition(levelIn, (BlockPos)mutable)) continue;
            levelIn.m_46597_((BlockPos)mutable, state);
        }
    }

    public static void freezeSpecial(Entity entity, Level levelIn, BlockPos pos, int radius, boolean campfire, boolean fire) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            double distance = blockpos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2)) continue;
            BlockState state = levelIn.m_8055_(blockpos);
            if (campfire && AreaUtils.isLitCampfire(state)) {
                levelIn.m_46597_(blockpos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
                continue;
            }
            if (!fire || state.m_60734_() != Blocks.f_50083_) continue;
            levelIn.m_46597_(blockpos, Blocks.f_50016_.m_49966_());
        }
    }

    public static void freezeSurfaceWater(Entity entity, Level level, BlockPos pos, int radius, boolean permanent) {
        BlockState state = permanent ? Blocks.f_50126_.m_49966_() : Blocks.f_50449_.m_49966_();
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2)) continue;
            mutable.m_122178_(blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_());
            BlockState blockstate1 = level.m_8055_((BlockPos)mutable);
            if (!blockstate1.m_60795_()) continue;
            BlockState blockstate2 = level.m_8055_(blockpos);
            boolean bl = isFull = blockstate2.m_60734_() == Blocks.f_49990_ && (Integer)blockstate2.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            if (blockstate2.m_60767_() != Material.f_76305_ || !isFull || !state.m_60710_((LevelReader)level, blockpos) || !level.m_45752_(state, blockpos, CollisionContext.m_82749_())) continue;
            level.m_46597_(blockpos, state);
            if (permanent) continue;
            level.m_186460_(blockpos, Blocks.f_50449_, MathHelper.nextInt(level.f_46441_, 60, 120));
        }
    }

    public static void freezeAllWater(Entity entity, Level levelIn, BlockPos pos, int radius, boolean permanent) {
        BlockState state = permanent ? Blocks.f_50126_.m_49966_() : Blocks.f_50449_.m_49966_();
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2)) continue;
            BlockState blockstate2 = levelIn.m_8055_(blockpos);
            boolean bl = isFull = blockstate2.m_60734_() == Blocks.f_49990_ && (Integer)blockstate2.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            if (blockstate2.m_60767_() != Material.f_76305_ || !isFull || !state.m_60710_((LevelReader)levelIn, blockpos) || !levelIn.m_45752_(state, blockpos, CollisionContext.m_82749_())) continue;
            levelIn.m_46597_(blockpos, state);
            if (permanent) continue;
            levelIn.m_186460_(blockpos, Blocks.f_50449_, MathHelper.nextInt(levelIn.f_46441_, 60, 120));
        }
    }

    public static void freezeSurfaceLava(Entity entity, Level levelIn, BlockPos pos, int radius, boolean permanent) {
        if (CoreBlocks.GLOSSED_MAGMA == null && !permanent) {
            return;
        }
        BlockState state = permanent ? Blocks.f_50080_.m_49966_() : ((Block)CoreBlocks.GLOSSED_MAGMA.get()).m_49966_();
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2)) continue;
            mutable.m_122178_(blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_());
            BlockState blockstate1 = levelIn.m_8055_((BlockPos)mutable);
            if (!blockstate1.m_60795_()) continue;
            BlockState blockstate2 = levelIn.m_8055_(blockpos);
            boolean bl = isFull = blockstate2.m_60734_() == Blocks.f_49991_ && (Integer)blockstate2.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            if (blockstate2.m_60767_() != Material.f_76307_ || !isFull || !state.m_60710_((LevelReader)levelIn, blockpos) || !levelIn.m_45752_(state, blockpos, CollisionContext.m_82749_())) continue;
            levelIn.m_46597_(blockpos, state);
            if (permanent) continue;
            levelIn.m_186460_(blockpos, (Block)CoreBlocks.GLOSSED_MAGMA.get(), MathHelper.nextInt(levelIn.f_46441_, 60, 120));
        }
    }

    public static void freezeAllLava(Entity entity, Level levelIn, BlockPos pos, int radius, boolean permanent) {
        if (CoreBlocks.GLOSSED_MAGMA == null && !permanent) {
            return;
        }
        BlockState state = permanent ? Blocks.f_50080_.m_49966_() : ((Block)CoreBlocks.GLOSSED_MAGMA.get()).m_49966_();
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2)) continue;
            BlockState blockstate2 = levelIn.m_8055_(blockpos);
            boolean bl = isFull = blockstate2.m_60734_() == Blocks.f_49991_ && (Integer)blockstate2.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            if (blockstate2.m_60767_() != Material.f_76307_ || !isFull || !state.m_60710_((LevelReader)levelIn, blockpos) || !levelIn.m_45752_(state, blockpos, CollisionContext.m_82749_())) continue;
            levelIn.m_46597_(blockpos, state);
            if (permanent) continue;
            levelIn.m_186460_(blockpos, (Block)CoreBlocks.GLOSSED_MAGMA.get(), MathHelper.nextInt(levelIn.f_46441_, 60, 120));
        }
    }

    public static boolean isValidSnowPosition(Level levelIn, BlockPos pos) {
        BlockState state = levelIn.m_8055_(pos.m_7495_());
        Block block = state.m_60734_();
        if (block == Blocks.f_50126_ || block == Blocks.f_50354_ || block == Blocks.f_50375_ || block == Blocks.f_50449_ || block == CoreBlocks.GLOSSED_MAGMA.get()) {
            return false;
        }
        return Block.m_49918_((VoxelShape)state.m_60812_((BlockGetter)levelIn, pos.m_7495_()), (Direction)Direction.UP) || block == Blocks.f_50125_ && (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) == 8;
    }

    private static boolean isValidLightningBoltPosition(Level levelIn, BlockPos pos, double chance) {
        BlockPos below = pos.m_7495_();
        BlockState state = levelIn.m_8055_(below);
        if (levelIn.m_45527_(pos) && Block.m_49918_((VoxelShape)state.m_60812_((BlockGetter)levelIn, below), (Direction)Direction.UP)) {
            return levelIn.f_46441_.m_188500_() < chance;
        }
        return false;
    }

    public static void transformArea(Entity entity, Level levelIn, BlockPos pos, BlockState replaceable, BlockState replacement, int radius, boolean requireAir) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (requireAir) {
            for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
                double distance = iterPos.m_203193_((Position)entity.m_20182_());
                if (!(distance < (double)f2)) continue;
                mutable.m_122178_(iterPos.m_123341_(), iterPos.m_123342_() + 1, iterPos.m_123343_());
                BlockState blockstate1 = levelIn.m_8055_((BlockPos)mutable);
                if (!blockstate1.m_60795_() || levelIn.m_8055_(iterPos) != replaceable) continue;
                levelIn.m_46597_(iterPos, replacement);
            }
        } else {
            for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
                double distance = iterPos.m_203193_((Position)entity.m_20182_());
                if (!(distance < (double)f2) || levelIn.m_8055_(iterPos) != replaceable) continue;
                levelIn.m_46597_(iterPos, replacement);
            }
        }
    }

    public static void transformArea(Entity entity, Level levelIn, BlockPos pos, Set<BlockState> replaceable, BlockState replacement, int radius, boolean requireAir) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (requireAir) {
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
                double distance = blockpos.m_203193_((Position)entity.m_20182_());
                if (!(distance < (double)f2)) continue;
                mutable.m_122178_(blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_());
                BlockState blockstate1 = levelIn.m_8055_((BlockPos)mutable);
                if (!blockstate1.m_60795_() || !replaceable.contains(levelIn.m_8055_(blockpos))) continue;
                levelIn.m_46597_(blockpos, replacement);
            }
        } else {
            for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
                if (!iterPos.m_123314_((Vec3i)pos, (double)f) || !replaceable.contains(levelIn.m_8055_(iterPos))) continue;
                levelIn.m_46597_(iterPos, replacement);
            }
        }
    }

    public static void transformGrass(Entity entity, Level levelIn, BlockPos pos, int radius) {
        AreaUtils.transformArea(entity, levelIn, pos, Blocks.f_50493_.m_49966_(), Blocks.f_50440_.m_49966_(), radius, true);
    }

    public static void transformMycelium(Entity entity, Level levelIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.f_50493_.m_49966_(), Blocks.f_50440_.m_49966_()});
        AreaUtils.transformArea(entity, levelIn, pos, (Set<BlockState>)replaceable, Blocks.f_50195_.m_49966_(), radius, true);
    }

    public static void transformSignalAir(Entity entity, Level levelIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.f_50016_.m_49966_(), Blocks.f_50627_.m_49966_()});
        AreaUtils.transformArea(entity, levelIn, pos, (Set<BlockState>)replaceable, ((Block)CoreBlocks.SIGNAL_AIR.get()).m_49966_(), radius, false);
    }

    public static void transformGlowAir(Entity entity, Level levelIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.f_50016_.m_49966_(), Blocks.f_50627_.m_49966_()});
        AreaUtils.transformArea(entity, levelIn, pos, (Set<BlockState>)replaceable, ((Block)CoreBlocks.GLOW_AIR.get()).m_49966_(), radius, false);
    }

    public static void transformEnderAir(Entity entity, Level levelIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.f_50016_.m_49966_(), Blocks.f_50627_.m_49966_()});
        AreaUtils.transformArea(entity, levelIn, pos, (Set<BlockState>)replaceable, ((Block)CoreBlocks.ENDER_AIR.get()).m_49966_(), radius, false);
    }

    public static void zapNearbyGround(Entity entity, Level levelIn, BlockPos pos, int radius, double chance, int max) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int count = 0;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            if (count >= max) {
                return;
            }
            double distance = blockpos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2)) continue;
            mutable.m_122178_(blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_());
            BlockState blockstate1 = levelIn.m_8055_((BlockPos)mutable);
            if (!blockstate1.m_60795_() || !AreaUtils.isValidLightningBoltPosition(levelIn, (BlockPos)mutable, chance)) continue;
            levelIn.m_46597_((BlockPos)mutable, ((Block)CoreBlocks.LIGHTNING_AIR.get()).m_49966_());
            ++count;
        }
    }

    public static void growMushrooms(Entity entity, Level levelIn, BlockPos pos, int radius, int count) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        int grow = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)entity.m_20183_().m_7494_());
        BlockState blockstate1 = levelIn.m_8055_((BlockPos)mutable);
        if (blockstate1.m_60795_() && AreaUtils.isValidMushroomPosition(levelIn, entity.m_20183_(), 1.0)) {
            levelIn.m_46597_((BlockPos)mutable, levelIn.f_46441_.m_188499_() ? Blocks.f_50072_.m_49966_() : Blocks.f_50073_.m_49966_());
            ++grow;
        }
        for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            if (grow >= count) {
                return;
            }
            double distance = iterPos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2)) continue;
            mutable.m_122178_(iterPos.m_123341_(), iterPos.m_123342_() + 1, iterPos.m_123343_());
            blockstate1 = levelIn.m_8055_((BlockPos)mutable);
            if (!blockstate1.m_60795_() || !AreaUtils.isValidMushroomPosition(levelIn, iterPos, 0.5 - distance / (double)f2)) continue;
            levelIn.m_46597_((BlockPos)mutable, levelIn.f_46441_.m_188499_() ? Blocks.f_50072_.m_49966_() : Blocks.f_50073_.m_49966_());
            ++grow;
        }
    }

    private static boolean isValidMushroomPosition(Level levelIn, BlockPos pos, double chance) {
        Block block = levelIn.m_8055_(pos).m_60734_();
        return levelIn.f_46441_.m_188500_() < chance && (block == Blocks.f_50195_ || block == Blocks.f_50599_);
    }

    public static void growPlants(Entity entity, Level levelIn, BlockPos pos, int radius) {
        float f = Math.min(32, radius);
        float v = Math.min(16, radius);
        float f2 = f * f;
        for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            BonemealableBlock growable;
            BlockState state;
            double distance = iterPos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2) || !((state = levelIn.m_8055_(iterPos)).m_60734_() instanceof BonemealableBlock) || !(growable = (BonemealableBlock)state.m_60734_()).m_7370_((BlockGetter)levelIn, iterPos, state, levelIn.f_46443_) || levelIn.f_46443_ || !growable.m_214167_(levelIn, levelIn.f_46441_, iterPos, state)) continue;
            try {
                growable.m_214148_((ServerLevel)levelIn, levelIn.f_46441_, iterPos, state);
            }
            catch (Exception e) {
                if (growable instanceof BambooBlock) continue;
                throw e;
            }
        }
    }

    public static void growPlants(Entity entity, Level levelIn, BlockPos pos, int radius, int count) {
        BlockState state;
        int grow;
        float f2;
        float v;
        float f;
        block7: {
            BonemealableBlock growable;
            f = Math.min(32, radius);
            v = Math.min(16, radius);
            f2 = f * f;
            grow = 0;
            state = levelIn.m_8055_(entity.m_20183_());
            if (state.m_60734_() instanceof BonemealableBlock && (growable = (BonemealableBlock)state.m_60734_()).m_7370_((BlockGetter)levelIn, pos, state, levelIn.f_46443_) && !levelIn.f_46443_ && growable.m_214167_(levelIn, levelIn.f_46441_, pos, state)) {
                try {
                    growable.m_214148_((ServerLevel)levelIn, levelIn.f_46441_, pos, state);
                    ++grow;
                }
                catch (Exception e) {
                    if (growable instanceof BambooBlock) break block7;
                    throw e;
                }
            }
        }
        for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)pos.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.m_7637_((double)f, (double)v, (double)f))) {
            BonemealableBlock growable;
            if (grow >= count) {
                return;
            }
            double distance = iterPos.m_203193_((Position)entity.m_20182_());
            if (!(distance < (double)f2) || !((state = levelIn.m_8055_(iterPos)).m_60734_() instanceof BonemealableBlock) || !(growable = (BonemealableBlock)state.m_60734_()).m_7370_((BlockGetter)levelIn, iterPos, state, levelIn.f_46443_) || levelIn.f_46443_ || !growable.m_214167_(levelIn, levelIn.f_46441_, iterPos, state)) continue;
            try {
                growable.m_214148_((ServerLevel)levelIn, levelIn.f_46441_, iterPos, state);
                ++grow;
            }
            catch (Exception e) {
                if (growable instanceof BambooBlock) continue;
                throw e;
            }
        }
    }

    public static interface IBlockTransformer {
        public boolean transformBlock(Level var1, BlockPos var2, Direction var3, @Nullable Entity var4);

        default public void transformSphere(Level level, Vec3 pos, float radius, @Nullable Entity entity) {
            float f = Math.min(32.0f, radius);
            float v = Math.min(16.0f, radius);
            float f2 = f * f;
            BlockPos origin = new BlockPos(pos);
            for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)origin.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)origin.m_7637_((double)(f + 1.0f), (double)(v + 1.0f), (double)(f + 1.0f)))) {
                if (!(iterPos.m_123331_((Vec3i)origin) < (double)f2)) continue;
                this.transformBlock(level, iterPos, Direction.DOWN, entity);
            }
        }

        default public void transformSphere(Level levelIn, Vec3 pos, float radius, float chance, @Nullable Entity entity) {
            float f = Math.min(32.0f, radius);
            float v = Math.min(16.0f, radius);
            float f2 = f * f;
            BlockPos origin = new BlockPos(pos);
            for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)origin.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)origin.m_7637_((double)f, (double)v, (double)f))) {
                double distSqr = iterPos.m_123331_((Vec3i)origin);
                if (!(distSqr < (double)f2) || !(chance > 0.99999f) && !(levelIn.f_46441_.m_188500_() < (double)chance)) continue;
                this.transformBlock(levelIn, iterPos, Direction.DOWN, entity);
            }
        }

        default public void transformSphere(Level levelIn, Vec3 pos, float radius, float chance, int max, @Nullable Entity entity) {
            float f = Math.min(32.0f, radius);
            float v = Math.min(16.0f, radius);
            float f2 = f * f;
            BlockPos origin = new BlockPos(pos);
            if (this.transformBlock(levelIn, origin, Direction.DOWN, entity)) {
                --max;
            }
            for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)origin.m_7637_((double)(-f), (double)(-v), (double)(-f)), (BlockPos)origin.m_7637_((double)f, (double)v, (double)f))) {
                if (max <= 0) {
                    return;
                }
                double distSqr = iterPos.m_123331_((Vec3i)origin);
                if (!(distSqr < (double)f2) || !(chance > 0.99999f) && !(levelIn.f_46441_.m_188500_() < (double)chance) || !this.transformBlock(levelIn, iterPos, Direction.DOWN, entity)) continue;
                --max;
            }
        }
    }

    public static interface IEffectApplier {
        public void applyEffect(Entity var1, int var2, int var3, @Nullable Entity var4);

        default public void applyEffectNearby(Level levelIn, Vec3 pos, Predicate<? super Entity> filter, float radius, int duration, int amplifier, @Nullable Entity source) {
            levelIn.m_6249_(source, new AABB(pos.m_82492_((double)radius, (double)radius, (double)radius), pos.m_82520_((double)radius, (double)radius, (double)radius)).m_82400_(1.0), filter).forEach(livingEntity -> this.applyEffect((Entity)livingEntity, duration, amplifier, source));
        }

        default public void applyEffectNearby(Level levelIn, Vec3 pos, float radius, int duration, int amplifier, @Nullable Entity source) {
            this.applyEffectNearby(levelIn, pos, EntitySelector.f_20402_, radius, duration, amplifier, source);
        }

        default public void applyEffectNearby(Level levelIn, Vec3 pos, float radius, int duration, int amplifier) {
            this.applyEffectNearby(levelIn, pos, radius, duration, amplifier, null);
        }
    }
}

