/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.crafting;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class ShapedRecipeInternal
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    public static final int MAX_WIDTH = 3;
    public static final int MAX_HEIGHT = 3;
    public final int width;
    public final int height;
    public final NonNullList<Ingredient> recipeItems;
    public final ItemStack result;
    public final ResourceLocation id;
    public final String group;

    public ShapedRecipeInternal(ResourceLocation p_i48162_1_, String p_i48162_2_, int p_i48162_3_, int p_i48162_4_, NonNullList<Ingredient> p_i48162_5_, ItemStack p_i48162_6_) {
        this.id = p_i48162_1_;
        this.group = p_i48162_2_;
        this.width = p_i48162_3_;
        this.height = p_i48162_4_;
        this.recipeItems = p_i48162_5_;
        this.result = p_i48162_6_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializer.f_44076_;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public boolean m_8004_(int p_194133_1_, int p_194133_2_) {
        return p_194133_1_ >= this.width && p_194133_2_ >= this.height;
    }

    public boolean matches(CraftingContainer p_77569_1_, Level p_77569_2_) {
        for (int i = 0; i <= p_77569_1_.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= p_77569_1_.m_39346_() - this.height; ++j) {
                if (this.matches(p_77569_1_, i, j, true)) {
                    return true;
                }
                if (!this.matches(p_77569_1_, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(CraftingContainer p_77573_1_, int p_77573_2_, int p_77573_3_, boolean p_77573_4_) {
        for (int i = 0; i < p_77573_1_.m_39347_(); ++i) {
            for (int j = 0; j < p_77573_1_.m_39346_(); ++j) {
                int k = i - p_77573_2_;
                int l = j - p_77573_3_;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = p_77573_4_ ? (Ingredient)this.recipeItems.get(this.width - k - 1 + l * this.width) : (Ingredient)this.recipeItems.get(k + l * this.width);
                }
                if (ingredient.test(p_77573_1_.m_8020_(i + j * p_77573_1_.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer p_77572_1_) {
        return this.m_8043_().m_41777_();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }

    public static NonNullList<Ingredient> dissolvePattern(String[] p_192402_0_, Map<String, Ingredient> p_192402_1_, int p_192402_2_, int p_192402_3_) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(p_192402_2_ * p_192402_3_), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(p_192402_1_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_192402_0_.length; ++i) {
            for (int j = 0; j < p_192402_0_[i].length(); ++j) {
                String s = p_192402_0_[i].substring(j, j + 1);
                Ingredient ingredient = p_192402_1_.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + p_192402_2_ * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    public static String[] shrink(String ... p_194134_0_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_194134_0_.length; ++i1) {
            String s = p_194134_0_[i1];
            i = Math.min(i, ShapedRecipeInternal.firstNonSpace(s));
            int j1 = ShapedRecipeInternal.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_194134_0_.length == l) {
            return new String[0];
        }
        String[] astring = new String[p_194134_0_.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_194134_0_[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    public static int firstNonSpace(String p_194135_0_) {
        int i;
        for (i = 0; i < p_194135_0_.length() && p_194135_0_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    public static int lastNonSpace(String p_194136_0_) {
        int i;
        for (i = p_194136_0_.length() - 1; i >= 0 && p_194136_0_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public static String[] patternFromJson(JsonArray p_192407_0_) {
        String[] astring = new String[p_192407_0_.size()];
        if (astring.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)p_192407_0_.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    public static Map<String, Ingredient> keyFromJson(JsonObject p_192408_0_) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : p_192408_0_.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack itemFromJson(JsonObject p_199798_0_) {
        String s = GsonHelper.m_13906_((JsonObject)p_199798_0_, (String)"item");
        Item item = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (p_199798_0_.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = GsonHelper.m_13824_((JsonObject)p_199798_0_, (String)"count", (int)1);
        return CraftingHelper.getItemStack((JsonObject)p_199798_0_, (boolean)true);
    }
}

