/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;

public class MathUtil {
    public static Vec3i getRegionPositionByIndex(int i) {
        int index = i + 1;
        int s = (int)Math.ceil(Math.sqrt(index)) + (int)((Math.ceil(Math.sqrt(index)) % 2.0 + 1.0) % 2.0);
        int ringIndex = 0;
        int p = 1;
        if (s > 1) {
            ringIndex = i - (s - 2) * (s - 2);
            p = s * s - (s - 2) * (s - 2);
        }
        int ri = (ringIndex + s / 2) % p;
        int x = 0;
        if (s > 1) {
            x = ri < p / 4 ? ri : (ri <= p / 4 * 2 - 1 ? p / 4 : (ri <= p / 4 * 3 ? p / 4 * 3 - ri : 0));
        }
        int y = 0;
        if (s > 1) {
            y = ri < p / 4 ? 0 : (ri <= p / 4 * 2 - 1 ? ri - p / 4 : (ri <= p / 4 * 3 ? p / 4 : p - ri));
        }
        return new Vec3i(x -= s / 2, 0, y -= s / 2);
    }

    public static BlockPos getCenterWithY(ChunkPos chunk, int y) {
        return chunk.m_45615_().m_121955_((Vec3i)new BlockPos(8, y, 8));
    }

    public static BlockPos getCenterWithY(Vec3i regionIndex, int y) {
        ChunkPos chunk = new ChunkPos(regionIndex.m_123341_() * 64, regionIndex.m_123343_() * 64);
        return MathUtil.getCenterWithY(chunk, y);
    }

    public static ChunkPos getChunkForRoomIndex(int roomIndex) {
        Vec3i region = MathUtil.getRegionPositionByIndex(roomIndex);
        BlockPos roomCenter = MathUtil.getCenterWithY(region, 0);
        return new ChunkPos(roomCenter);
    }
}

