/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.modular_accumulator;

import com.mrh0.createaddition.blocks.modular_accumulator.CAConnectivityHandler;
import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlock;
import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlockEntity;
import com.mrh0.createaddition.index.CABlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ModularAccumulatorBlockItem
extends BlockItem {
    public ModularAccumulatorBlockItem(Block block, Item.Properties props) {
        super(block, props);
    }

    public InteractionResult m_40576_(BlockPlaceContext ctx) {
        InteractionResult initialResult = super.m_40576_(ctx);
        if (!initialResult.m_19077_()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean m_7274_(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag nbt = stack.m_41737_("BlockEntityTag");
        if (nbt != null) {
            int energy;
            nbt.m_128473_("Size");
            nbt.m_128473_("Height");
            nbt.m_128473_("Controller");
            nbt.m_128473_("LastKnownPos");
            if (nbt.m_128441_("EnergyContent") && (energy = nbt.m_128469_("EnergyContent").m_128451_("energy")) > 0) {
                energy = Math.min(ModularAccumulatorBlockEntity.getCapacityMultiplier(), energy);
                CompoundTag ec = new CompoundTag();
                ec.m_128405_("energy", energy);
                nbt.m_128365_("EnergyContent", (Tag)ec);
            }
        }
        return super.m_7274_(pos, level, player, stack, state);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.m_43723_();
        if (player == null) {
            return;
        }
        if (player.m_6144_()) {
            return;
        }
        Direction face = ctx.m_43719_();
        if (!face.m_122434_().m_122478_()) {
            return;
        }
        ItemStack stack = ctx.m_43722_();
        Level world = ctx.m_43725_();
        BlockState placedOnState = world.m_8055_(placedOnPos = (pos = ctx.m_8083_()).m_121945_(face.m_122424_()));
        if (!ModularAccumulatorBlock.isAccumulator(placedOnState)) {
            return;
        }
        ModularAccumulatorBlockEntity accumulatorAt = (ModularAccumulatorBlockEntity)CAConnectivityHandler.partAt((BlockEntityType)CABlockEntities.MODULAR_ACCUMULATOR.get(), (BlockGetter)world, placedOnPos);
        if (accumulatorAt == null) {
            return;
        }
        ModularAccumulatorBlockEntity controllerTE = accumulatorAt.getControllerBE();
        if (controllerTE == null) {
            return;
        }
        int width = controllerTE.width;
        if (width == 1) {
            return;
        }
        int blocksToPlace = 0;
        BlockPos blockPos = startPos = face == Direction.DOWN ? controllerTE.m_58899_().m_7495_() : controllerTE.m_58899_().m_6630_(controllerTE.height);
        if (startPos.m_123342_() != pos.m_123342_()) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (ModularAccumulatorBlock.isAccumulator(blockState)) continue;
                if (!blockState.m_60767_().m_76336_()) {
                    return;
                }
                ++blocksToPlace;
            }
        }
        if (!player.m_7500_() && stack.m_41613_() < blocksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (ModularAccumulatorBlock.isAccumulator(blockState)) continue;
                BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().m_128379_("SilenceTankSound", true);
                super.m_40576_(context);
                player.getPersistentData().m_128473_("SilenceTankSound");
            }
        }
    }

    private static int getOrCreateEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        if (!tag.m_128425_("energy", 8)) {
            tag.m_128405_("energy", 0);
        }
        return tag.m_128451_("energy");
    }
}

