/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.server;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.container.AbstractDankMenu;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.util.C2SPacketHelper;
import tfar.dankstorage.world.DankInventory;

public class C2SSetFrequencyPacket
implements C2SPacketHelper {
    private final int frequency;
    private final boolean set;

    public C2SSetFrequencyPacket(int frequency, boolean set) {
        this.frequency = frequency;
        this.set = set;
    }

    public C2SSetFrequencyPacket(FriendlyByteBuf buf) {
        this.frequency = buf.readInt();
        this.set = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.frequency);
        buf.writeBoolean(this.set);
    }

    public static void send(int id, boolean set) {
        DankPacketHandler.sendToServer(new C2SSetFrequencyPacket(id, set));
    }

    @Override
    public void handleServer(ServerPlayer player) {
        AbstractContainerMenu container = player.f_36096_;
        if (container instanceof AbstractDankMenu) {
            int textColor;
            AbstractDankMenu dankMenu = (AbstractDankMenu)container;
            DankInventory inventory = dankMenu.dankInventory;
            if (this.frequency > -1) {
                DankInventory targetInventory = DankStorage.instance.data.getInventory(this.frequency);
                if (targetInventory != null && targetInventory.dankStats == inventory.dankStats) {
                    if (targetInventory.frequencyLocked()) {
                        textColor = DankInventory.TxtColor.LOCKED.color;
                    } else {
                        textColor = DankInventory.TxtColor.GOOD.color;
                        if (this.set) {
                            dankMenu.setFrequency(this.frequency);
                            player.m_6915_();
                        }
                    }
                } else {
                    textColor = targetInventory == null ? DankInventory.TxtColor.TOO_HIGH.color : DankInventory.TxtColor.DIFFERENT_TIER.color;
                }
            } else {
                textColor = DankInventory.TxtColor.INVALID.color;
            }
            inventory.setTextColor(textColor);
        }
    }
}

