/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PacketBufferEX {
    static final long LIMIT = 0x800000L;

    public static void writeExtendedItemStack(FriendlyByteBuf buf, ItemStack stack) {
        if (stack.m_41619_()) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(Item.m_41393_((Item)stack.m_41720_()));
            buf.writeInt(stack.m_41613_());
            CompoundTag nbttagcompound = stack.m_41783_();
            PacketBufferEX.writeNBT(buf, nbttagcompound);
        }
    }

    public static void writeNBT(FriendlyByteBuf buf, @Nullable CompoundTag nbt) {
        if (nbt == null) {
            buf.writeByte(0);
        } else {
            try {
                NbtIo.m_128941_((CompoundTag)nbt, (DataOutput)new ByteBufOutputStream((ByteBuf)buf));
            }
            catch (IOException ioexception) {
                throw new EncoderException((Throwable)ioexception);
            }
        }
    }

    public static ItemStack readExtendedItemStack(FriendlyByteBuf buf) {
        int i = buf.readInt();
        if (i < 0) {
            return ItemStack.f_41583_;
        }
        int j = buf.readInt();
        ItemStack itemstack = new ItemStack((ItemLike)Item.m_41445_((int)i), j);
        itemstack.m_41751_(PacketBufferEX.readNBT(buf));
        return itemstack;
    }

    public static CompoundTag readNBT(FriendlyByteBuf buf) {
        int i = buf.readerIndex();
        byte b0 = buf.readByte();
        if (b0 == 0) {
            return null;
        }
        buf.readerIndex(i);
        try {
            return NbtIo.m_128934_((DataInput)new ByteBufInputStream((ByteBuf)buf), (NbtAccounter)new NbtAccounter(0x800000L));
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    public static void writeList(FriendlyByteBuf buf, NonNullList<ItemStack> stacks) {
        buf.writeInt(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            PacketBufferEX.writeExtendedItemStack(buf, (ItemStack)stacks.get(i));
        }
    }

    public static NonNullList<ItemStack> readList(FriendlyByteBuf buf) {
        int size = buf.readInt();
        NonNullList stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < size; ++i) {
            ItemStack stack = PacketBufferEX.readExtendedItemStack(buf);
            stacks.set(i, (Object)stack);
        }
        return stacks;
    }
}

