/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.ItemStackWrapper;
import tfar.dankstorage.utils.Utils;

public class DankInventory
extends ItemStackHandler
implements ContainerData {
    public DankStats dankStats;
    protected NonNullList<ItemStack> ghostItems;
    protected int id;
    private boolean locked = true;
    protected int textColor = -1;
    static final String GHOST = "GhostItems";

    public DankInventory(DankStats stats, int id) {
        super(stats.slots);
        this.dankStats = stats;
        this.ghostItems = NonNullList.m_122780_((int)stats.slots, (Object)ItemStack.f_41583_);
        this.id = id;
    }

    public void setDankStats(DankStats dankStats) {
        this.dankStats = dankStats;
        this.setSize(dankStats.slots);
    }

    public void setSize(int size) {
        super.setSize(size);
        this.ghostItems = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    public void upgradeTo(DankStats stats) {
        if (stats.ordinal() <= this.dankStats.ordinal()) {
            return;
        }
        this.setTo(stats);
    }

    public void setTo(DankStats stats) {
        if (stats != this.dankStats) {
            DankStorage.LOGGER.debug("Upgrading dank #{} from tier {} to {}", (Object)this.id, (Object)this.dankStats.name(), (Object)stats.name());
        }
        this.dankStats = stats;
        this.copyItems();
    }

    private void copyItems() {
        int i;
        NonNullList newStacks = NonNullList.m_122780_((int)this.dankStats.slots, (Object)ItemStack.f_41583_);
        NonNullList newGhostStacks = NonNullList.m_122780_((int)this.dankStats.slots, (Object)ItemStack.f_41583_);
        int oldSlots = this.getSlots();
        int max = Math.min(oldSlots, this.dankStats.slots);
        for (i = 0; i < max; ++i) {
            ItemStack oldStack = this.getStackInSlot(i);
            ItemStack oldGhost = this.getGhostItem(i);
            newStacks.set(i, (Object)oldStack);
            newGhostStacks.set(i, (Object)oldGhost);
        }
        this.setSize(this.dankStats.slots);
        for (i = 0; i < max; ++i) {
            this.stacks = newStacks;
            this.ghostItems = newGhostStacks;
        }
        this.onContentsChanged(0);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.hasGhostItem(slot) && this.getGhostItem(slot).m_41720_() != stack.m_41720_()) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.dankStats.stacklimit;
    }

    public int getStackLimit(int slot, @NotNull ItemStack stack) {
        return stack.m_204117_(ModTags.UNSTACKABLE) ? 1 : this.getSlotLimit(slot);
    }

    public NonNullList<ItemStack> getContents() {
        return this.stacks;
    }

    public boolean noValidSlots() {
        return IntStream.range(0, this.getSlots()).mapToObj(arg_0 -> ((DankInventory)this).getStackInSlot(arg_0)).allMatch(stack -> stack.m_41619_() || stack.m_204117_(ModTags.BLACKLISTED_USAGE));
    }

    public boolean hasGhostItem(int slot) {
        return !((ItemStack)this.ghostItems.get(slot)).m_41619_();
    }

    public ItemStack getGhostItem(int slot) {
        return (ItemStack)this.ghostItems.get(slot);
    }

    public void setGhostItem(int slot, Item item) {
        this.ghostItems.set(slot, (Object)new ItemStack((ItemLike)item));
    }

    public void toggleGhostItem(int slot) {
        boolean loc;
        boolean bl = loc = !((ItemStack)this.ghostItems.get(slot)).m_41619_();
        if (!loc) {
            this.ghostItems.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)this.getStackInSlot(slot), (int)1));
        } else {
            this.ghostItems.set(slot, (Object)ItemStack.f_41583_);
        }
        this.onContentsChanged(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        boolean checkGhostItem = !this.hasGhostItem(slot) || this.getGhostItem(slot).m_41720_() == stack.m_41720_();
        return !stack.m_204117_(ModTags.BLACKLISTED_STORAGE) && checkGhostItem && super.isItemValid(slot, stack);
    }

    public CompoundTag save() {
        CompoundTag itemTag;
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.getContents().size(); ++i) {
            if (((ItemStack)this.getContents().get(i)).m_41619_()) continue;
            int realCount = Math.min(this.dankStats.stacklimit, ((ItemStack)this.getContents().get(i)).m_41613_());
            itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.getContents().get(i)).m_41739_(itemTag);
            itemTag.m_128405_("ExtendedCount", realCount);
            nbtTagList.add((Object)itemTag);
        }
        ListTag ghostItemNBT = new ListTag();
        for (int i = 0; i < this.getContents().size(); ++i) {
            if (((ItemStack)this.ghostItems.get(i)).m_41619_()) continue;
            itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.ghostItems.get(i)).m_41739_(itemTag);
            ghostItemNBT.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128365_(GHOST, (Tag)ghostItemNBT);
        nbt.m_128359_("DankStats", this.dankStats.name());
        nbt.m_128405_("dankstorage:id", this.id);
        nbt.m_128379_("locked", this.locked);
        return nbt;
    }

    public void read(CompoundTag nbt) {
        DankStats stats = DankStats.valueOf(nbt.m_128461_("DankStats"));
        this.setDankStats(stats);
        ListTag tagList = nbt.m_128437_("Items", 10);
        this.readItems(tagList);
        ListTag ghostItemList = nbt.m_128437_(GHOST, 10);
        this.readGhostItems(ghostItemList);
        this.locked = nbt.m_128471_("locked");
        this.validate();
    }

    protected void readItems(ListTag listTag) {
        for (int i = 0; i < listTag.size(); ++i) {
            ItemStack stack;
            CompoundTag itemTags = listTag.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.getSlots()) continue;
            if (itemTags.m_128425_("StackList", 9)) {
                stack = ItemStack.f_41583_;
                ListTag stackTagList = itemTags.m_128437_("StackList", 10);
                for (int j = 0; j < stackTagList.size(); ++j) {
                    CompoundTag itemTag = stackTagList.m_128728_(j);
                    ItemStack temp = ItemStack.m_41712_((CompoundTag)itemTag);
                    if (temp.m_41619_()) continue;
                    if (stack.m_41619_()) {
                        stack = temp;
                        continue;
                    }
                    stack.m_41769_(temp.m_41613_());
                }
                if (stack.m_41619_()) continue;
                int count = stack.m_41613_();
                count = Math.min(count, this.getSlotLimit(slot));
                stack.m_41764_(count);
                this.setStackInSlot(slot, stack);
                continue;
            }
            stack = ItemStack.m_41712_((CompoundTag)itemTags);
            if (itemTags.m_128425_("ExtendedCount", 3)) {
                stack.m_41764_(itemTags.m_128451_("ExtendedCount"));
            }
            this.setStackInSlot(slot, stack);
        }
    }

    protected void readGhostItems(ListTag listTag) {
        for (int i = 0; i < listTag.size(); ++i) {
            ItemStack stack;
            CompoundTag itemTags = listTag.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.getSlots()) continue;
            if (itemTags.m_128425_("StackList", 9)) {
                stack = ItemStack.f_41583_;
                ListTag stackTagList = itemTags.m_128437_("StackList", 10);
                for (int j = 0; j < stackTagList.size(); ++j) {
                    CompoundTag itemTag = stackTagList.m_128728_(j);
                    ItemStack temp = ItemStack.m_41712_((CompoundTag)itemTag);
                    if (temp.m_41619_()) continue;
                    if (stack.m_41619_()) {
                        stack = temp;
                        continue;
                    }
                    stack.m_41769_(temp.m_41613_());
                }
                if (stack.m_41619_()) continue;
                this.ghostItems.set(slot, (Object)stack);
                continue;
            }
            stack = ItemStack.m_41712_((CompoundTag)itemTags);
            this.ghostItems.set(slot, (Object)stack);
        }
    }

    protected void setGhostItems(NonNullList<ItemStack> newGhosts) {
        this.ghostItems = newGhosts;
    }

    protected void validate() {
        if (this.dankStats == DankStats.zero) {
            throw new RuntimeException("dank has no stats?");
        }
        if (this.getSlots() == 0) {
            throw new RuntimeException("dank is empty?");
        }
        if (this.ghostItems.size() != this.getSlots()) {
            throw new RuntimeException("inequal size");
        }
    }

    public int calcRedstone() {
        int numStacks = 0;
        float f = 0.0f;
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            f += (float)stack.m_41613_() / (float)this.getSlotLimit(slot);
            ++numStacks;
        }
        return Mth.m_14143_((float)((f /= (float)this.getSlots()) * 14.0f)) + (numStacks > 0 ? 1 : 0);
    }

    public void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (DankStorage.instance.data != null) {
            DankStorage.instance.data.m_77762_();
        }
    }

    public int getFrequencySlot() {
        return this.getSlots();
    }

    public int getTextColor() {
        return this.m_6413_(1);
    }

    public void setTextColor(int color) {
        this.m_8050_(1, color);
    }

    public boolean frequencyLocked() {
        return this.m_6413_(2) == 1;
    }

    public void toggleFrequencyLock() {
        boolean loc = this.frequencyLocked();
        this.setFrequencyLock(!loc);
    }

    public void setFrequencyLock(boolean lock) {
        this.m_8050_(2, lock ? 1 : 0);
    }

    public int m_6413_(int slot) {
        return switch (slot) {
            case 0 -> this.id;
            case 1 -> this.textColor;
            case 2 -> {
                if (this.locked) {
                    yield 1;
                }
                yield 0;
            }
            default -> -999;
        };
    }

    public int getFrequency() {
        return this.m_6413_(0);
    }

    public void m_8050_(int slot, int value) {
        switch (slot) {
            case 0: {
                this.id = value;
                break;
            }
            case 1: {
                this.textColor = value;
                break;
            }
            case 2: {
                this.locked = value == 1;
            }
        }
        this.onContentsChanged(slot);
    }

    public void compress(ServerPlayer player) {
        ItemStack stack;
        this.sort();
        ServerLevel level = player.m_9236_();
        ArrayList<ItemStack> addLater = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getSlots() && !(stack = this.getStackInSlot(i)).m_41619_(); ++i) {
            Pair<ItemStack, Integer> result;
            ItemStack resultStack;
            if (!Utils.canCompress(level, stack) || (resultStack = (ItemStack)(result = Utils.compress(stack)).getFirst()).m_41619_()) continue;
            int division = (Integer)result.getSecond();
            int compressedCount = stack.m_41613_() / division;
            int remainderCount = stack.m_41613_() % division;
            this.setStackInSlot(i, ItemHandlerHelper.copyStackWithSize((ItemStack)resultStack, (int)compressedCount));
            addLater.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remainderCount));
        }
        this.sort();
        for (ItemStack itemStack : addLater) {
            ItemStack remainder = itemStack.m_41777_();
            for (int i = 0; i < this.getSlots() && !(remainder = this.insertItem(i, remainder, false)).m_41619_(); ++i) {
            }
            if (remainder.m_41619_()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)remainder);
        }
        this.sort();
    }

    public void sort() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.getContents()) {
            if (stack.m_41619_()) continue;
            Utils.merge(stacks, stack.m_41777_());
        }
        List<ItemStackWrapper> wrappers = Utils.wrap(stacks);
        Collections.sort(wrappers);
        for (int i = 0; i < this.getSlots(); ++i) {
            this.setStackInSlot(i, ItemStack.f_41583_);
            this.ghostItems.set(i, (Object)ItemStack.f_41583_);
        }
        int slotId = 0;
        for (int i = 0; i < wrappers.size(); ++i) {
            ItemStack stack = wrappers.get((int)i).stack;
            int count = stack.m_41613_();
            if (count > this.dankStats.stacklimit) {
                int fullStacks = count / this.dankStats.stacklimit;
                int partialStack = count - fullStacks * this.dankStats.stacklimit;
                for (int j = 0; j < fullStacks; ++j) {
                    this.setStackInSlot(slotId, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)this.dankStats.stacklimit));
                    ++slotId;
                }
                if (partialStack <= 0) continue;
                this.setStackInSlot(slotId, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)partialStack));
                ++slotId;
                continue;
            }
            this.setStackInSlot(slotId, stack);
            ++slotId;
        }
    }

    public void clearContent() {
        this.stacks.clear();
        this.onContentsChanged(0);
    }

    public int m_6499_() {
        return this.getSlots() + 3;
    }

    public static enum TxtColor {
        INVALID(-65536),
        TOO_HIGH(Short.MIN_VALUE),
        DIFFERENT_TIER(-256),
        GOOD(-16711936),
        LOCKED(-16776961);

        public final int color;

        private TxtColor(int color) {
            this.color = color;
        }
    }
}

