/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.world;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.world.DankInventory;

public class DankSavedData
extends SavedData {
    private final List<DankInventory> storage = new ArrayList<DankInventory>();

    @Nullable
    public DankInventory getInventory(int id) {
        return id < this.storage.size() && id > -1 ? this.storage.get(id) : null;
    }

    public DankInventory getOrCreateInventory(int id, DankStats stats) {
        DankInventory dankInventory = this.getInventory(id);
        if (dankInventory == null) {
            int next = this.getNextID();
            DankInventory inventory = new DankInventory(stats, next);
            this.storage.add(next, inventory);
            this.m_77762_();
        }
        return this.getInventory(id);
    }

    public int getNextID() {
        return this.storage.size();
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag listTag = new ListTag();
        for (DankInventory inventory : this.storage) {
            listTag.add((Object)inventory.save());
        }
        compoundTag.m_128365_("contents", (Tag)listTag);
        return compoundTag;
    }

    public static DankSavedData loadStatic(CompoundTag compoundTag) {
        DankSavedData dankSavedData = new DankSavedData();
        dankSavedData.load(compoundTag);
        return dankSavedData;
    }

    protected void load(CompoundTag compoundTag) {
        ListTag invs = compoundTag.m_128437_("contents", 10);
        for (Tag tag : invs) {
            CompoundTag compoundTag1 = (CompoundTag)tag;
            int id = compoundTag1.m_128451_("dankstorage:id");
            DankInventory dankInventory = this.readItems(compoundTag1, id);
            this.storage.add(id, dankInventory);
        }
    }

    DankInventory readItems(CompoundTag tag, int id) {
        DankInventory inventory = new DankInventory(DankStats.zero, id);
        inventory.read(tag);
        return inventory;
    }

    public void m_77757_(File file) {
        super.m_77757_(file);
        DankStorage.LOGGER.debug("Saving Dank Contents");
    }

    public void clearAll() {
        this.storage.clear();
        this.m_77762_();
    }

    public boolean clearId(int id) {
        if (id < this.getNextID()) {
            DankInventory dankInventory = this.getInventory(id);
            dankInventory.clearContent();
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean setTier(int id, int tier) {
        if (id < this.getNextID()) {
            DankInventory dankInventory = this.getInventory(id);
            dankInventory.setTo(DankStats.values()[tier]);
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean lock(int frequency) {
        if (frequency < this.getNextID()) {
            DankInventory dankInventory = this.getInventory(frequency);
            dankInventory.setFrequencyLock(true);
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean unlock(int frequency) {
        if (frequency < this.getNextID()) {
            DankInventory dankInventory = this.getInventory(frequency);
            dankInventory.setFrequencyLock(false);
            this.m_77762_();
            return true;
        }
        return false;
    }
}

