/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.otherside;

import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.world.DDPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class OthersideBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"deeperdarker");
    public static final RegistryObject<Biome> DEEPLANDS = BIOMES.register("deeplands", OthersideBiomes::deeplands);
    public static final RegistryObject<Biome> ECHOING_FOREST = BIOMES.register("echoing_forest", OthersideBiomes::echoingForest);
    public static final RegistryObject<Biome> OVERCAST_COLUMNS = BIOMES.register("overcast_columns", OthersideBiomes::overcastColumns);

    public static Biome deeplands() {
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SCULK_CENTIPEDE.get(), 6, 1, 4));
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SCULK_SNAPPER.get(), 11, 3, 6));
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20509_, 2, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, (Holder)DDPlacedFeatures.SCULK_STONE_COLUMN.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, (Holder)DDPlacedFeatures.SCULK_GLEAM.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)DDPlacedFeatures.SURFACE_SCULK_STONE.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)DDPlacedFeatures.SCULK_DECORATION.getHolder().get());
        OthersideBiomes.addSculkDecoration(biomeBuilder);
        OthersideBiomes.addSculkOres(biomeBuilder);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(-0.5f).m_47611_(-0.5f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(1254763).m_48037_(1253458).m_48019_(1317939).m_48040_(OthersideBiomes.calculateSkyColor(-0.5f)).m_48027_(new AmbientMoodSettings((SoundEvent)DDSounds.AMBIENT_OTHERSIDE_ADDITIONS.get(), 6000, 8, 2.0)).m_48021_(Musics.m_11653_((SoundEvent)((SoundEvent)DDSounds.MUSIC_BIOME_DEEPLANDS.get()))).m_48018_()).m_47605_(mobSpawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome echoingForest() {
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SCULK_SNAPPER.get(), 9, 1, 2));
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SHATTERED.get(), 17, 2, 5));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, (Holder)DDPlacedFeatures.SCULK_GLEAM_FOREST.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)DDPlacedFeatures.ECHO_TREE.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.ECHO_SOIL.getHolder().get());
        OthersideBiomes.addSculkDecoration(biomeBuilder);
        OthersideBiomes.addSculkOres(biomeBuilder);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(0.3f).m_47611_(0.5f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4330347).m_48037_(3742046).m_48019_(3152448).m_48040_(OthersideBiomes.calculateSkyColor(0.3f)).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123783_, 0.04f)).m_48027_(new AmbientMoodSettings((SoundEvent)DDSounds.AMBIENT_OTHERSIDE_ADDITIONS.get(), 6000, 8, 2.0)).m_48021_(Musics.m_11653_((SoundEvent)((SoundEvent)DDSounds.MUSIC_BIOME_ECHOING_FOREST.get()))).m_48018_()).m_47605_(mobSpawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static Biome overcastColumns() {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, (Holder)DDPlacedFeatures.GLOOMSLATE_COLUMN.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)DDPlacedFeatures.SURFACE_GLOOMSLATE.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)DDPlacedFeatures.GLOOMY_SCULK_VEGETATION.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.GLOOMY_SCULK.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.MAGMA.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.SOUL_SAND.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.SOUL_SOIL.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.GLOOMSLATE_COAL.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.GLOOMSLATE_IRON.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.GLOOMSLATE_COPPER.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.GLOOMSLATE_GOLD.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.GLOOMSLATE_REDSTONE.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.GLOOMSLATE_EMERALD.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.GLOOMSLATE_LAPIS.getHolder().get());
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.GLOOMSLATE_DIAMOND.getHolder().get());
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(0.6f).m_47611_(0.2f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4530962).m_48037_(3547929).m_48019_(4663576).m_48040_(OthersideBiomes.calculateSkyColor(0.6f)).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123762_, 0.026f)).m_48027_(new AmbientMoodSettings((SoundEvent)DDSounds.AMBIENT_OTHERSIDE_ADDITIONS.get(), 6000, 8, 2.0)).m_48021_(Musics.m_11653_((SoundEvent)((SoundEvent)DDSounds.MUSIC_BIOME_OVERCAST_COLUMNS.get()))).m_48018_()).m_47605_(MobSpawnSettings.f_48326_).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    public static void addSculkDecoration(BiomeGenerationSettings.Builder builder) {
        builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)DDPlacedFeatures.SCULK_TENDRILS.getHolder().get());
        builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)DDPlacedFeatures.SCULK_VINES.getHolder().get());
    }

    public static void addSculkOres(BiomeGenerationSettings.Builder builder) {
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.INFESTED_SCULK.getHolder().get());
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.SCULK_JAW.getHolder().get());
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.SCULK_COAL.getHolder().get());
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.SCULK_IRON.getHolder().get());
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.SCULK_COPPER.getHolder().get());
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.SCULK_GOLD.getHolder().get());
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.SCULK_REDSTONE.getHolder().get());
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.SCULK_EMERALD.getHolder().get());
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.SCULK_LAPIS.getHolder().get());
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)DDPlacedFeatures.SCULK_DIAMOND.getHolder().get());
    }

    private static int calculateSkyColor(float temp) {
        float s = temp / 3.0f;
        s = Mth.m_14036_((float)s, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - s * 0.05f), (float)(0.5f + s * 0.1f), (float)1.0f);
    }
}

