/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.items;

import de.maxhenkel.easy_villagers.corelib.CachedMap;
import de.maxhenkel.easy_villagers.corelib.client.CustomRendererItem;
import de.maxhenkel.easy_villagers.corelib.client.ItemRenderer;
import de.maxhenkel.easy_villagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.items.render.VillagerItemRenderer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VillagerItem
extends CustomRendererItem {
    private final CachedMap<ItemStack, EasyVillagerEntity> cachedVillagers = new CachedMap(10000L, ItemUtils.ITEM_COMPARATOR);

    public VillagerItem() {
        super(new Item.Properties().m_41487_(1));
        DispenserBlock.m_52672_((ItemLike)this, (source, stack) -> {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos blockpos = source.m_7961_().m_121945_(direction);
            ServerLevel world = source.m_7727_();
            EasyVillagerEntity villager = this.getVillager((Level)world, stack);
            villager.m_19890_((double)blockpos.m_123341_() + 0.5, blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, direction.m_122435_(), 0.0f);
            world.m_7967_((Entity)villager);
            stack.m_41774_(1);
            return stack;
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemRenderer createItemRenderer() {
        return new VillagerItemRenderer();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.m_43722_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (!blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_()) {
            blockpos = blockpos.m_121945_(direction);
        }
        Villager villager = VillagerItem.convertToVillager(this.getVillager(world, itemstack));
        villager.m_6034_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5);
        if (world.m_7967_((Entity)villager)) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.CONSUME;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(ItemStack stack) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return super.m_7626_(stack);
        }
        EasyVillagerEntity villager = this.getVillagerFast((Level)world, stack);
        if (!villager.m_8077_() && villager.m_6162_()) {
            return Component.m_237115_((String)"item.easy_villagers.baby_villager");
        }
        return villager.m_5446_();
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player) || world.f_46443_) {
            return;
        }
        if (!((Boolean)Main.SERVER_CONFIG.villagerInventorySounds.get()).booleanValue()) {
            return;
        }
        VillagerBlockBase.playRandomVillagerSound((Player)entity, SoundEvents.f_12503_);
    }

    public void setVillager(ItemStack stack, Villager villager) {
        CompoundTag compound = stack.m_41698_("villager");
        villager.m_7380_(compound);
        if (villager.m_8077_()) {
            stack.m_41714_(villager.m_7770_());
        }
    }

    public EasyVillagerEntity getVillager(Level world, ItemStack stack) {
        CompoundTag compound = stack.m_41737_("villager");
        if (compound == null) {
            compound = new CompoundTag();
        }
        EasyVillagerEntity villager = new EasyVillagerEntity((EntityType<? extends Villager>)EntityType.f_20492_, world);
        villager.m_7378_(compound);
        if (stack.m_41788_()) {
            villager.m_6593_(stack.m_41786_());
        }
        villager.f_20916_ = 0;
        villager.f_20885_ = 0.0f;
        villager.f_20886_ = 0.0f;
        return villager;
    }

    public static Villager convertToVillager(EasyVillagerEntity easyVillager) {
        Villager villager = new Villager(EntityType.f_20492_, easyVillager.f_19853_);
        CompoundTag data = easyVillager.serializeNBT();
        villager.deserializeNBT(data);
        return villager;
    }

    public EasyVillagerEntity getVillagerFast(Level world, ItemStack stack) {
        return this.cachedVillagers.get(stack, () -> this.getVillager(world, stack));
    }

    public static ItemStack getBabyVillager() {
        ItemStack babyVillager = new ItemStack((ItemLike)ModItems.VILLAGER.get());
        CompoundTag compound = babyVillager.m_41698_("villager");
        compound.m_128405_("Age", -24000);
        return babyVillager;
    }
}

