/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.client.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.common.block.BlockEnderChest;

@OnlyIn(value=Dist.CLIENT)
public class EventHandlerClient {
    @SubscribeEvent
    public void drawBlockHighlightEvent(RenderHighlightEvent.Block event) {
        VoxelShape shape;
        BlockPos pos;
        if (event.getTarget() == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !player.m_6144_() || player.m_21205_().m_41619_() && player.m_21206_().m_41619_()) {
            return;
        }
        Level world = player.m_9236_();
        BlockState state = world.m_8055_(pos = event.getTarget().m_82425_());
        if (state.m_60734_() instanceof BlockEnderChest && world.m_6857_().m_61937_(pos) && !(shape = this.getShapeToOutline((Player)player, state, world, pos)).m_83281_()) {
            this.drawSelectionBox(event.getPoseStack(), event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), event.getCamera(), pos, shape);
        }
    }

    private VoxelShape getShapeToOutline(Player player, BlockState state, Level world, BlockPos pos) {
        for (InteractionHand hand : InteractionHand.values()) {
            Item item = player.m_21120_(hand).m_41720_();
            if (Values.listPersonal.contains(item) || Values.listTeam.contains(item) || Values.listSmallCap_Single.contains(item) || Values.listSmallCap_Multi.contains(item) || Values.listLargeCap_Single.contains(item) || Values.listLargeCap_Multi.contains(item)) {
                return state.m_60808_((BlockGetter)world, pos);
            }
            if (!DyeHelper.isDye((Item)item) || BlockEnderChest.SHAPES.isEmpty()) continue;
            VoxelShape[] shapes = BlockEnderChest.SHAPES.get(state.m_61143_((Property)BlockEnderChest.FACING));
            int subHit = Function.getSubShapeHit((Entity)player, (BlockPos)pos, (VoxelShape[])shapes);
            return subHit > 0 && subHit < 4 ? shapes[subHit] : Shapes.m_83040_();
        }
        return Shapes.m_83040_();
    }

    public void drawSelectionBox(PoseStack matrixStack, VertexConsumer buffer, Camera info, BlockPos pos, VoxelShape shape) {
        double d0 = info.m_90583_().f_82479_;
        double d1 = info.m_90583_().f_82480_;
        double d2 = info.m_90583_().f_82481_;
        float mul = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        if (mul > 1.0f) {
            mul = 2.0f - mul;
        }
        EventHandlerClient.drawShape(matrixStack, buffer, shape, (double)pos.m_123341_() - d0, (double)pos.m_123342_() - d1, (double)pos.m_123343_() - d2, mul, mul, mul, 0.4f);
    }

    private static void drawShape(PoseStack matrixStack, VertexConsumer buffer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose pose = matrixStack.m_85850_();
        shape.m_83224_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float nX = (float)(maxX - minX);
            float nY = (float)(maxY - minY);
            float nZ = (float)(maxZ - minZ);
            float sqrt = Mth.m_14116_((float)(nX * nX + nY * nY + nZ * nZ));
            buffer.m_85982_(pose.m_85861_(), (float)(minX + x), (float)(minY + y), (float)(minZ + z)).m_85950_(red, green, blue, alpha).m_85977_(pose.m_85864_(), nX /= sqrt, nY /= sqrt, nZ /= sqrt).m_5752_();
            buffer.m_85982_(pose.m_85861_(), (float)(maxX + x), (float)(maxY + y), (float)(maxZ + z)).m_85950_(red, green, blue, alpha).m_85977_(pose.m_85864_(), nX, nY, nZ).m_5752_();
        });
    }
}

