/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.jade;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    private static final ResourceLocation CONFIG_BASIC = new ResourceLocation("endertanks", "hud.basic");
    private static final ResourceLocation CONFIG_CONTENTS = new ResourceLocation("endertanks", "hud.contents");
    private static final ResourceLocation CONFIG_STATUS = new ResourceLocation("endertanks", "hud.status");

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)ComponentProvider.INSTANCE, TileEntityEnderTank.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(CONFIG_BASIC, true);
        registration.addConfig(CONFIG_CONTENTS, true);
        registration.addConfig(CONFIG_STATUS, true);
        registration.registerBlockComponent((IBlockComponentProvider)ComponentProvider.INSTANCE, BlockEnderTank.class);
    }

    public static class ComponentProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockEntity> {
        static final ComponentProvider INSTANCE = new ComponentProvider();
        private static final ResourceLocation INFO_PROVIDER_ID = new ResourceLocation("endertanks", "hud");
        private static final ItemStack COMPARATOR = new ItemStack((ItemLike)Items.f_42351_);

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            CompoundTag data = accessor.getServerData();
            if (!data.m_128441_("endertanks_basic")) {
                tooltip.add((Component)Component.m_237115_((String)"hud.endertanks.server_data_missing"));
                return;
            }
            ArrayList<Component> lines = new ArrayList<Component>();
            if (config.get(CONFIG_BASIC)) {
                TankInfoHelper.unpackHUDInfo(lines, data.m_128437_("endertanks_basic", 8));
            }
            if (config.get(CONFIG_CONTENTS) && data.m_128441_("endertanks_contents")) {
                TankInfoHelper.unpackHUDInfo(lines, data.m_128437_("endertanks_contents", 8));
            }
            tooltip.addAll(lines);
            if (config.get(CONFIG_STATUS) && data.m_128441_("endertanks_status")) {
                lines.clear();
                TankInfoHelper.unpackHUDInfo(lines, data.m_128437_("endertanks_status", 8));
                tooltip.add((Component)lines.get(0));
                IElementHelper elements = tooltip.getElementHelper();
                IElement icon = elements.item(COMPARATOR, 0.5f).size(new Vec2(10.0f, 10.0f)).translate(new Vec2(0.0f, -1.0f)).message(null);
                tooltip.add(icon);
                tooltip.append((Component)lines.get(1));
            }
        }

        public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity tile, boolean showDetails) {
            if (tile instanceof TileEntityEnderTank) {
                TileEntityEnderTank tank = (TileEntityEnderTank)tile;
                data.m_128365_("endertanks_basic", (Tag)TankInfoHelper.packHUDBasic(tank));
                if (showDetails) {
                    data.m_128365_("endertanks_contents", (Tag)TankInfoHelper.packHUDContents(tank));
                    data.m_128365_("endertanks_status", (Tag)TankInfoHelper.packHUDStatus(tank));
                }
            }
        }

        public ResourceLocation getUid() {
            return INFO_PROVIDER_ID;
        }
    }
}

