/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.command.QuestObjectArgument;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.DeleteObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.SyncQuestsMessage;
import dev.ftb.mods.ftbquests.net.SyncTeamDataMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.util.FileUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsCommands {
    private static final SimpleCommandExceptionType NO_INVENTORY = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.ftbquests.command.error.no_inventory"));
    private static final Set<UUID> warnedPlayers = new HashSet<UUID>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbquests").requires(s -> s.m_81377_() != null && s.m_81377_().m_129792_() || s.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"editing_mode").executes(c -> FTBQuestsCommands.editingMode((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.editingMode((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(c -> FTBQuestsCommands.editingMode((CommandSourceStack)c.getSource(), EntityArgument.m_91474_((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"locked").executes(c -> FTBQuestsCommands.locked((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.locked((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(c -> FTBQuestsCommands.locked((CommandSourceStack)c.getSource(), EntityArgument.m_91474_((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(Commands.m_82127_((String)"delete_empty_reward_tables").executes(context -> FTBQuestsCommands.deleteEmptyRewardTables((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"change_progress").requires(s -> s.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"quest_object", (ArgumentType)QuestObjectArgument.questObject()).executes(ctx -> {
            Collection players = EntityArgument.m_91477_((CommandContext)ctx, (String)"players");
            QuestObjectBase questObject = (QuestObjectBase)ctx.getArgument("quest_object", QuestObjectBase.class);
            return FTBQuestsCommands.changeProgress((CommandSourceStack)ctx.getSource(), players, true, questObject);
        })))).then(Commands.m_82127_((String)"complete").then(Commands.m_82129_((String)"quest_object", (ArgumentType)QuestObjectArgument.questObject()).executes(ctx -> {
            Collection players = EntityArgument.m_91477_((CommandContext)ctx, (String)"players");
            QuestObjectBase questObject = (QuestObjectBase)ctx.getArgument("quest_object", QuestObjectBase.class);
            return FTBQuestsCommands.changeProgress((CommandSourceStack)ctx.getSource(), players, false, questObject);
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export_reward_table_to_chest").requires(s -> s.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"reward_table", (ArgumentType)QuestObjectArgument.questObject()).executes(ctx -> {
            QuestObjectBase table = (QuestObjectBase)ctx.getArgument("reward_table", QuestObjectBase.class);
            if (!(table instanceof RewardTable)) {
                throw QuestObjectArgument.NO_OBJECT.create((Object)table.getCodeString());
            }
            return FTBQuestsCommands.exportRewards((CommandSourceStack)ctx.getSource(), (RewardTable)table, null);
        })).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> {
            QuestObjectBase table = (QuestObjectBase)ctx.getArgument("reward_table", QuestObjectBase.class);
            BlockPos pos = BlockPosArgument.m_174395_((CommandContext)ctx, (String)"pos");
            if (!(table instanceof RewardTable)) {
                throw QuestObjectArgument.NO_OBJECT.create((Object)table.getCodeString());
            }
            return FTBQuestsCommands.exportRewards((CommandSourceStack)ctx.getSource(), (RewardTable)table, pos);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"import_reward_table_from_chest").requires(s -> s.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return FTBQuestsCommands.importRewards((CommandSourceStack)ctx.getSource(), name, null);
        })).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            BlockPos pos = BlockPosArgument.m_174395_((CommandContext)ctx, (String)"pos");
            return FTBQuestsCommands.importRewards((CommandSourceStack)ctx.getSource(), name, pos);
        }))))).then(Commands.m_82127_((String)"generate_chapter_with_all_items_in_game").executes(context -> FTBQuestsCommands.generateAllItemChapter((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(s -> s.m_6761_(2))).executes(context -> FTBQuestsCommands.doReload((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"block_rewards").executes(c -> FTBQuestsCommands.toggleRewardBlocking((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.toggleRewardBlocking((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(s -> s.m_6761_(2))).executes(c -> FTBQuestsCommands.toggleRewardBlocking((CommandSourceStack)c.getSource(), EntityArgument.m_91474_((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))))));
    }

    private static int exportRewards(CommandSourceStack source, RewardTable table, BlockPos pos) throws CommandSyntaxException {
        BlockEntity be;
        ServerPlayer player = source.m_81375_();
        ServerLevel level = source.m_81372_();
        if (pos == null) {
            pos = new BlockPos(player.m_19907_(10.0, 1.0f, false).m_82450_());
        }
        if (!((be = level.m_7702_(pos)) instanceof BaseContainerBlockEntity)) {
            throw NO_INVENTORY.create();
        }
        BaseContainerBlockEntity container = (BaseContainerBlockEntity)be;
        container.m_6211_();
        int s = 0;
        for (WeightedReward reward : table.rewards) {
            if (s >= container.m_6643_()) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.ftbquests.command.feedback.table_too_many_items", (Object[])new Object[]{table.getTitle()}));
                return 0;
            }
            if (!(reward.reward instanceof ItemReward)) continue;
            container.m_6836_(s++, ((ItemReward)reward.reward).item);
        }
        source.m_81354_((Component)Component.m_237110_((String)"commands.ftbquests.command.feedback.table_imported", (Object[])new Object[]{table.getTitle(), table.rewards.size()}), false);
        return 1;
    }

    private static int importRewards(CommandSourceStack source, String name, BlockPos pos) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ServerLevel level = source.m_81372_();
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (pos == null) {
            pos = new BlockPos(player.m_19907_(10.0, 1.0f, false).m_82450_());
        }
        RewardTable table = new RewardTable(file);
        table.id = file.newID();
        table.title = name;
        table.icon = Items.f_42009_.m_7968_();
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof BaseContainerBlockEntity)) {
            throw NO_INVENTORY.create();
        }
        BaseContainerBlockEntity container = (BaseContainerBlockEntity)be;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            table.rewards.add(new WeightedReward(new ItemReward(table.fakeQuest, stack), 1.0f));
        }
        file.rewardTables.add(table);
        file.save();
        new CreateObjectResponseMessage(table, null).sendToAll(level.m_7654_());
        source.m_81354_((Component)Component.m_237110_((String)"commands.ftbquests.command.feedback.table_imported", (Object[])new Object[]{name, table.rewards.size()}), false);
        return 1;
    }

    private static int editingMode(CommandSourceStack source, ServerPlayer player, @Nullable Boolean canEdit) {
        TeamData data = ServerQuestFile.INSTANCE.getData((Entity)player);
        if (canEdit == null) {
            canEdit = !data.getCanEdit((Player)player);
        }
        data.setCanEdit((Player)player, canEdit);
        if (canEdit.booleanValue()) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.ftbquests.editing_mode.enabled", (Object[])new Object[]{player.m_5446_()}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.ftbquests.editing_mode.disabled", (Object[])new Object[]{player.m_5446_()}), true);
        }
        return 1;
    }

    private static int locked(CommandSourceStack source, ServerPlayer player, @Nullable Boolean locked) {
        TeamData data = ServerQuestFile.INSTANCE.getData((Entity)player);
        if (locked == null) {
            locked = !data.isLocked();
        }
        data.setLocked(locked);
        if (locked.booleanValue()) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.ftbquests.locked.enabled", (Object[])new Object[]{player.m_5446_()}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.ftbquests.locked.disabled", (Object[])new Object[]{player.m_5446_()}), true);
        }
        return 1;
    }

    private static int changeProgress(CommandSourceStack source, Collection<ServerPlayer> players, boolean reset, QuestObjectBase questObject) {
        ProgressChange progressChange = new ProgressChange(ServerQuestFile.INSTANCE);
        progressChange.origin = questObject;
        progressChange.reset = reset;
        for (ServerPlayer player : players) {
            progressChange.player = player.m_20148_();
            questObject.forceProgress(ServerQuestFile.INSTANCE.getData((Entity)player), progressChange);
        }
        source.m_81354_((Component)Component.m_237115_((String)"commands.ftbquests.change_progress.text"), true);
        return 1;
    }

    private static int deleteEmptyRewardTables(CommandSourceStack source) {
        int del = 0;
        for (RewardTable table : ServerQuestFile.INSTANCE.rewardTables) {
            if (!table.rewards.isEmpty()) continue;
            ++del;
            table.invalid = true;
            FileUtils.delete(ServerQuestFile.INSTANCE.getFolder().resolve(table.getPath()).toFile());
            new DeleteObjectResponseMessage(table.id).sendToAll(source.m_81377_());
        }
        ServerQuestFile.INSTANCE.rewardTables.removeIf(rewardTable -> rewardTable.invalid);
        ServerQuestFile.INSTANCE.refreshIDMap();
        ServerQuestFile.INSTANCE.save();
        source.m_81354_((Component)Component.m_237113_((String)("Deleted " + del + " empty tables")), false);
        return 1;
    }

    private static int generateAllItemChapter(CommandSourceStack source) {
        NonNullList nonNullList = NonNullList.m_122779_();
        for (Map.Entry entry : Registry.f_122827_.m_6579_()) {
            Item item = (Item)entry.getValue();
            try {
                int s = nonNullList.size();
                item.m_6787_(CreativeModeTab.f_40754_, nonNullList);
                if (s != nonNullList.size()) continue;
                nonNullList.add((Object)new ItemStack((ItemLike)item));
            }
            catch (Throwable ex) {
                FTBQuests.LOGGER.warn("Failed to get items from " + entry.getKey() + ": " + ex);
            }
        }
        Chapter chapter = new Chapter(ServerQuestFile.INSTANCE, ServerQuestFile.INSTANCE.defaultChapterGroup);
        chapter.id = chapter.file.newID();
        chapter.onCreated();
        chapter.title = "Generated chapter of all items in search creative tab [" + nonNullList.size() + "]";
        chapter.icon = new ItemStack((ItemLike)Items.f_42522_);
        chapter.defaultQuestShape = "rsquare";
        new CreateObjectResponseMessage(chapter, null).sendToAll(source.m_81377_());
        List<ItemStack> list = nonNullList.stream().filter(stack -> !stack.m_41619_() && Registries.getId((Object)stack.m_41720_(), (ResourceKey)Registry.f_122904_) != null).sorted(Comparator.comparing(a -> Registries.getId((Object)a.m_41720_(), (ResourceKey)Registry.f_122904_))).toList();
        FTBQuests.LOGGER.info("Found " + nonNullList.size() + " items in total, chapter ID: " + chapter);
        if (list.isEmpty()) {
            return 0;
        }
        int col = 0;
        int row = 0;
        String modid = Registries.getId((Object)list.get(0).m_41720_(), (ResourceKey)Registry.f_122904_).m_135827_();
        for (ItemStack stack2 : list) {
            ResourceLocation id = Registries.getId((Object)stack2.m_41720_(), (ResourceKey)Registry.f_122904_);
            if (!modid.equals(id.m_135827_())) {
                modid = id.m_135827_();
                col = 0;
                row += 2;
            } else if (col >= 40) {
                col = 0;
                ++row;
            }
            Quest quest = new Quest(chapter);
            quest.id = chapter.file.newID();
            quest.onCreated();
            quest.x = col;
            quest.y = row;
            quest.subtitle = stack2.m_41739_(new CompoundTag()).toString();
            new CreateObjectResponseMessage(quest, null).sendToAll(source.m_81377_());
            ItemTask task = new ItemTask(quest);
            task.id = chapter.file.newID();
            task.onCreated();
            task.consumeItems = Tristate.TRUE;
            task.item = stack2;
            CompoundTag extra = new CompoundTag();
            extra.m_128359_("type", task.getType().getTypeForNBT());
            new CreateObjectResponseMessage(task, extra).sendToAll(source.m_81377_());
            ++col;
        }
        ServerQuestFile.INSTANCE.save();
        ServerQuestFile.INSTANCE.saveNow();
        source.m_81354_((Component)Component.m_237113_((String)"Done!"), false);
        return 1;
    }

    private static int doReload(CommandSourceStack source) {
        UUID id;
        ServerQuestFile instance = ServerQuestFile.INSTANCE;
        ServerPlayer sender = source.m_230896_();
        if (sender != null && !instance.getData((Entity)sender).getCanEdit((Player)sender)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.ftbquests.command.error.not_editing"));
            return 1;
        }
        instance.load();
        new SyncQuestsMessage(instance).sendToAll(source.m_81377_());
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            TeamData data = instance.getData((Entity)player);
            for (TeamData teamData : instance.getAllData()) {
                new SyncTeamDataMessage(teamData, teamData == data).sendTo(player);
            }
        }
        source.m_81354_((Component)Component.m_237115_((String)"commands.ftbquests.command.feedback.reloaded"), false);
        UUID uUID = id = sender == null ? Util.f_137441_ : sender.m_20148_();
        if (!warnedPlayers.contains(id)) {
            source.m_81354_((Component)Component.m_237115_((String)"commands.ftbquests.command.feedback.reloaded.disclaimer").m_130940_(ChatFormatting.GOLD), false);
            warnedPlayers.add(id);
        }
        return 1;
    }

    private static int toggleRewardBlocking(CommandSourceStack source, ServerPlayer player, Boolean doBlocking) {
        TeamData data = ServerQuestFile.INSTANCE.getData((Entity)player);
        if (doBlocking == null) {
            doBlocking = !data.areRewardsBlocked();
        }
        data.setRewardsBlocked(doBlocking);
        source.m_81354_((Component)Component.m_237110_((String)"commands.ftbquests.command.feedback.rewards_blocked", (Object[])new Object[]{data, data.areRewardsBlocked()}), false);
        return 1;
    }
}

