/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class KnownClientPlayer
implements Comparable<KnownClientPlayer> {
    public final UUID uuid;
    public String name;
    public boolean online;
    public UUID teamId;
    private GameProfile profile;
    private CompoundTag extraData;

    public KnownClientPlayer(PlayerTeam pt) {
        this.uuid = pt.getId();
        this.name = pt.playerName;
        this.online = pt.online;
        this.teamId = pt.actualTeam.getId();
        this.extraData = pt.getExtraData();
    }

    public KnownClientPlayer(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        this.name = buf.m_130136_(Short.MAX_VALUE);
        this.online = buf.readBoolean();
        this.teamId = buf.m_130259_();
        this.extraData = buf.m_130261_();
    }

    public void update(KnownClientPlayer p) {
        this.name = p.name;
        this.online = p.online;
        this.teamId = p.teamId;
        this.profile = null;
        this.extraData = p.extraData;
    }

    public GameProfile getProfile() {
        if (this.profile == null) {
            this.profile = new GameProfile(this.uuid, this.name);
        }
        return this.profile;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.m_130072_(this.name, Short.MAX_VALUE);
        buf.writeBoolean(this.online);
        buf.m_130077_(this.teamId);
        buf.m_130079_(this.extraData);
    }

    public boolean isInternalTeam() {
        return this.teamId.equals(this.uuid);
    }

    public boolean isOnlineAndNotInParty() {
        return this.online && this.isInternalTeam();
    }

    public CompoundTag getExtraData() {
        return this.extraData;
    }

    @Override
    public int compareTo(KnownClientPlayer o) {
        int i = Boolean.compare(o.isOnlineAndNotInParty(), this.isOnlineAndNotInParty());
        return i == 0 ? this.name.compareToIgnoreCase(o.name) : i;
    }
}

