/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.config;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.nio.file.Path;

public interface FTBUltimineClientConfig {
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create((String)"ftbultimine-client").comment(new String[]{"Client-specific configuration for FTB Ultimine", "This file is meant for users to control Ultimine's clientside behaviour and rendering.", "Changes to this file require you to reload the world"});
    public static final IntValue xOffset = (IntValue)CONFIG.getInt("x_offset", -1).comment(new String[]{"Manual x offset of FTB Ultimine overlay, required for some modpacks"});
    public static final IntValue shapeMenuContextLines = (IntValue)CONFIG.getInt("shape_menu_context_lines", 2).range((Number)1, (Number)5).comment(new String[]{"When displaying the shape selection menu by holding the Ultimine key", "and sneaking at the same time, the number of shape names to display", "above and below the selected shape"});
    public static final BooleanValue requireSneakForMenu = (BooleanValue)CONFIG.getBoolean("require_sneak_for_menu", true).comment(new String[]{"When holding the Ultimine key, must the player also be sneaking to show the shapes menu?"});
    public static final IntValue renderOutline = (IntValue)CONFIG.getInt("render_outline", 256).range((Number)0, (Number)Integer.MAX_VALUE).comment(new String[]{"Maximum number of blocks the white outline should be rendered for", "Keep in mind this may get *very* laggy for large amounts of blocks!"});

    public static void load() {
        ConfigUtil.loadDefaulted((SNBTConfig)CONFIG, (Path)ConfigUtil.LOCAL_DIR, (String)"ftbultimine");
    }

    public static ConfigGroup getConfigGroup() {
        ConfigGroup group = new ConfigGroup("ftbultimine.client_settings");
        CONFIG.createClientConfig(group);
        group.savedCallback = accepted -> {
            if (accepted) {
                CONFIG.save(Platform.getGameFolder().resolve("local/ftbultimine-client.snbt"));
            }
        };
        return group;
    }
}

