/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.lib;

import at.petrak.hexcasting.common.lib.HexSounds;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Vec3i;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.HexalAPI;

public class HexalSounds {
    private static final Map<ResourceLocation, SoundEntry> SOUNDS = new LinkedHashMap<ResourceLocation, SoundEntry>();
    public static final SoundEntry WISP_CASTING_START = HexalSounds.create("wisp_casting_start").subtitle("Wisp starts casting").playExisting(HexSounds.ACTUALLY_CAST, 0.5f, 1.0f).category(SoundSource.PLAYERS).attenuationDistance(8).build();
    public static final SoundEntry WISP_CASTING_CONTINUE = HexalSounds.create("wisp_casting_continue").subtitle("Wisp continues casting").category(SoundSource.PLAYERS).volume(0.5f).attenuationDistance(8).build();

    public static void registerSounds(BiConsumer<SoundEvent, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, SoundEntry> e : SOUNDS.entrySet()) {
            e.getValue().register(r);
        }
    }

    public static SoundEntryBuilder create(String id) {
        return HexalSounds.create(HexalAPI.modLoc(id));
    }

    public static SoundEntryBuilder create(ResourceLocation id) {
        return new SoundEntryBuilder(id);
    }

    public static JsonObject provideLangEntries() {
        JsonObject object = new JsonObject();
        for (SoundEntry entry : SOUNDS.values()) {
            if (!entry.hasSubtitle()) continue;
            object.addProperty(entry.getSubtitleKey(), entry.getSubtitle());
        }
        return object;
    }

    public static SoundEntryProvider provider(DataGenerator generator) {
        return new SoundEntryProvider(generator);
    }

    public static abstract class SoundEntry {
        protected ResourceLocation id;
        protected String subtitle;
        protected SoundSource category;
        protected int attenuationDistance;

        public SoundEntry(ResourceLocation id, String subtitle, SoundSource category, int attenuationDistance) {
            this.id = id;
            this.subtitle = subtitle;
            this.category = category;
            this.attenuationDistance = attenuationDistance;
        }

        public abstract void register(BiConsumer<SoundEvent, ResourceLocation> var1);

        public abstract void write(JsonObject var1);

        public abstract SoundEvent getMainEvent();

        public String getSubtitleKey() {
            return this.id.m_135827_() + ".subtitle." + this.id.m_135815_();
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public boolean hasSubtitle() {
            return this.subtitle != null;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public SoundSource getCategory() {
            return this.category;
        }

        public void playOnServer(Level world, Vec3i pos2) {
            this.playOnServer(world, pos2, 1.0f, 1.0f);
        }

        public void playOnServer(Level world, Vec3i pos2, float volume, float pitch) {
            this.play(world, null, pos2, volume, pitch);
        }

        public void play(Level world, Player entity, Vec3i pos2) {
            this.play(world, entity, pos2, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity) {
            this.playFrom(entity, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity, float volume, float pitch) {
            if (!entity.m_20067_()) {
                this.play(entity.f_19853_, null, (Vec3i)entity.m_20183_(), volume, pitch);
            }
        }

        public void play(Level world, Player entity, Vec3i pos2, float volume, float pitch) {
            this.play(world, entity, (double)pos2.m_123341_() + 0.5, (double)pos2.m_123342_() + 0.5, (double)pos2.m_123343_() + 0.5, volume, pitch);
        }

        public void play(Level world, Player entity, Vec3 pos2, float volume, float pitch) {
            this.play(world, entity, pos2.m_7096_(), pos2.m_7098_(), pos2.m_7094_(), volume, pitch);
        }

        public abstract void play(Level var1, Player var2, double var3, double var5, double var7, float var9, float var10);

        public void playAt(Level world, Vec3i pos2, float volume, float pitch, boolean fade) {
            this.playAt(world, (double)pos2.m_123341_() + 0.5, (double)pos2.m_123342_() + 0.5, (double)pos2.m_123343_() + 0.5, volume, pitch, fade);
        }

        public void playAt(Level world, Vec3 pos2, float volume, float pitch, boolean fade) {
            this.playAt(world, pos2.m_7096_(), pos2.m_7098_(), pos2.m_7094_(), volume, pitch, fade);
        }

        public abstract void playAt(Level var1, double var2, double var4, double var6, float var8, float var9, boolean var10);
    }

    public static class SoundEntryBuilder {
        protected ResourceLocation id;
        protected String subtitle = "unregistered";
        protected SoundSource category = SoundSource.BLOCKS;
        protected List<ConfiguredSoundEvent> wrappedEvents = new ArrayList<ConfiguredSoundEvent>();
        protected List<ResourceLocation> variants = new ArrayList<ResourceLocation>();
        protected float volume;
        protected float pitch;
        protected int attenuationDistance;

        public SoundEntryBuilder(ResourceLocation id) {
            this.id = id;
        }

        public SoundEntryBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public SoundEntryBuilder volume(float volume) {
            this.volume = volume;
            return this;
        }

        public SoundEntryBuilder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public SoundEntryBuilder attenuationDistance(int distance) {
            this.attenuationDistance = distance;
            return this;
        }

        public SoundEntryBuilder noSubtitle() {
            this.subtitle = null;
            return this;
        }

        public SoundEntryBuilder category(SoundSource category) {
            this.category = category;
            return this;
        }

        public SoundEntryBuilder addVariant(String name) {
            return this.addVariant(HexalAPI.modLoc(name));
        }

        public SoundEntryBuilder addVariant(ResourceLocation id) {
            this.variants.add(id);
            return this;
        }

        public SoundEntryBuilder playExisting(Supplier<SoundEvent> event, float volume, float pitch) {
            this.wrappedEvents.add(new ConfiguredSoundEvent(event, volume, pitch));
            return this;
        }

        public SoundEntryBuilder playExisting(SoundEvent event, float volume, float pitch) {
            return this.playExisting(() -> event, volume, pitch);
        }

        public SoundEntryBuilder playExisting(SoundEvent event) {
            return this.playExisting(event, 1.0f, 1.0f);
        }

        public SoundEntry build() {
            SoundEntry entry = this.wrappedEvents.isEmpty() ? new CustomSoundEntry(this.id, this.variants, this.subtitle, this.category, this.volume, this.pitch, this.attenuationDistance) : new WrappedSoundEntry(this.id, this.subtitle, this.wrappedEvents, this.category, this.attenuationDistance);
            SOUNDS.put(entry.getId(), entry);
            return entry;
        }
    }

    public record SoundEntryProvider(DataGenerator generator) implements DataProvider
    {
        public void m_213708_(@NotNull CachedOutput cache) {
            this.generate(this.generator.m_123916_(), cache);
        }

        @NotNull
        public String m_6055_() {
            return "Hexal's Custom Sounds";
        }

        public void generate(Path path, CachedOutput cache) {
            path = path.resolve("assets/hexal");
            try {
                JsonObject json = new JsonObject();
                SOUNDS.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((SoundEntry)entry.getValue()).write(json));
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class CustomSoundEntry
    extends SoundEntry {
        protected List<ResourceLocation> variants;
        protected SoundEvent event;
        protected final float volume;
        protected final float pitch;

        public CustomSoundEntry(ResourceLocation id, List<ResourceLocation> variants, String subtitle, SoundSource category, float volume, float pitch, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.event = new SoundEvent(id);
            this.variants = variants;
            this.volume = volume;
            this.pitch = pitch;
        }

        @Override
        public void register(BiConsumer<SoundEvent, ResourceLocation> registry) {
            registry.accept(this.event, this.id);
        }

        @Override
        public SoundEvent getMainEvent() {
            return this.event;
        }

        @Override
        public void write(JsonObject json) {
            JsonObject entry = new JsonObject();
            JsonArray list = new JsonArray();
            JsonObject s = new JsonObject();
            s.addProperty("name", this.id.toString());
            s.addProperty("type", "file");
            if (this.volume != 0.0f) {
                s.addProperty("volume", (Number)Float.valueOf(this.volume));
            }
            if (this.pitch != 0.0f) {
                s.addProperty("pitch", (Number)Float.valueOf(this.pitch));
            }
            if (this.attenuationDistance != 0) {
                s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
            }
            list.add((JsonElement)s);
            for (ResourceLocation variant : this.variants) {
                s = new JsonObject();
                s.addProperty("name", variant.toString());
                s.addProperty("type", "file");
                if (this.volume != 0.0f) {
                    s.addProperty("volume", (Number)Float.valueOf(this.volume));
                }
                if (this.pitch != 0.0f) {
                    s.addProperty("pitch", (Number)Float.valueOf(this.pitch));
                }
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
            }
            entry.add("sounds", (JsonElement)list);
            if (this.hasSubtitle()) {
                entry.addProperty("subtitle", this.getSubtitleKey());
            }
            json.add(this.id.m_135815_(), (JsonElement)entry);
        }

        @Override
        public void play(Level world, Player entity, double x, double y, double z, float volume, float pitch) {
            world.m_6263_(entity, x, y, z, this.event, this.category, volume, pitch);
        }

        @Override
        public void playAt(Level world, double x, double y, double z, float volume, float pitch, boolean fade) {
            world.m_7785_(x, y, z, this.event, this.category, volume, pitch, fade);
        }
    }

    private static class WrappedSoundEntry
    extends SoundEntry {
        private final List<ConfiguredSoundEvent> wrappedEvents;

        public WrappedSoundEntry(ResourceLocation id, String subtitle, List<ConfiguredSoundEvent> wrappedEvents, SoundSource category, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.wrappedEvents = wrappedEvents;
        }

        @Override
        public void register(BiConsumer<SoundEvent, ResourceLocation> registry) {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent wrapped = this.wrappedEvents.get(i);
                ResourceLocation location = this.getIdOf(i);
                registry.accept(new SoundEvent(location), location);
            }
        }

        @Override
        public SoundEvent getMainEvent() {
            return this.wrappedEvents.get(0).event().get();
        }

        protected ResourceLocation getIdOf(int i) {
            return new ResourceLocation(this.id.m_135827_(), (String)(i == 0 ? this.id.m_135815_() : this.id.m_135815_() + "_compounded_" + i));
        }

        @Override
        public void write(JsonObject json) {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent event = this.wrappedEvents.get(i);
                JsonObject entry = new JsonObject();
                JsonArray list = new JsonArray();
                JsonObject s = new JsonObject();
                s.addProperty("name", event.event().get().m_11660_().toString());
                s.addProperty("type", "event");
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
                entry.add("sounds", (JsonElement)list);
                if (i == 0 && this.hasSubtitle()) {
                    entry.addProperty("subtitle", this.getSubtitleKey());
                }
                json.add(this.getIdOf(i).m_135815_(), (JsonElement)entry);
            }
        }

        @Override
        public void play(Level world, Player entity, double x, double y, double z, float volume, float pitch) {
            for (ConfiguredSoundEvent event : this.wrappedEvents) {
                world.m_6263_(entity, x, y, z, event.event().get(), this.category, event.volume() * volume, event.pitch() * pitch);
            }
        }

        @Override
        public void playAt(Level world, double x, double y, double z, float volume, float pitch, boolean fade) {
            for (ConfiguredSoundEvent event : this.wrappedEvents) {
                world.m_7785_(x, y, z, event.event().get(), this.category, event.volume() * volume, event.pitch() * pitch, fade);
            }
        }
    }

    public record ConfiguredSoundEvent(Supplier<SoundEvent> event, float volume, float pitch) {
    }
}

