/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.mixin;

import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.casting.ResolvedPatternType;
import at.petrak.hexcasting.api.spell.casting.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.PatternIota;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.spell.casting.IMixinCastingContext;
import ram.talia.hexal.common.casting.Patterns;
import ram.talia.hexal.common.entities.BaseCastingWisp;
import ram.talia.hexal.xplat.IXplatAbstractions;

@Mixin(value={CastingHarness.class})
public abstract class MixinCastingHarness {
    private final CastingHarness harness = (CastingHarness)this;

    @Redirect(method={"updateWithPattern"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"), remap=false)
    private boolean updateWithPatternWisp(List<OperatorSideEffect> sideEffects, Object o) {
        if (o instanceof OperatorSideEffect.Particles) {
            OperatorSideEffect.Particles particles = (OperatorSideEffect.Particles)o;
            CastingContext ctx = this.harness.getCtx();
            IMixinCastingContext ctxi = (IMixinCastingContext)ctx;
            if (!ctxi.hasWisp()) {
                return sideEffects.add((OperatorSideEffect)particles);
            }
            return false;
        }
        return sideEffects.add((OperatorSideEffect)o);
    }

    @Redirect(method={"executeIotas"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", remap=true), remap=false)
    private void playSoundWisp(ServerLevel level, Player player, double x, double y, double z, SoundEvent soundEvent, SoundSource soundSource, float v, float p) {
        CastingContext ctx = this.harness.getCtx();
        IMixinCastingContext wispContext = (IMixinCastingContext)ctx;
        BaseCastingWisp wisp = wispContext.getWisp();
        if (wisp != null) {
            wisp.scheduleCastSound();
        } else {
            level.m_6263_(player, x, y, z, soundEvent, soundSource, v, p);
        }
    }

    @ModifyVariable(method={"withdrawMedia"}, at=@At(value="STORE"), ordinal=0, remap=false, argsOnly=true)
    private int removeConsumedFromCost(int value) {
        CastingContext ctx = this.harness.getCtx();
        IMixinCastingContext iCtx = (IMixinCastingContext)ctx;
        int consumedMedia = iCtx.getConsumedMedia();
        if (consumedMedia == 0) {
            return value;
        }
        int newValue = Math.max(value - consumedMedia, 0);
        iCtx.setConsumedMedia(consumedMedia -= value - newValue);
        return newValue;
    }

    @Inject(method={"withdrawMedia"}, at={@At(value="HEAD")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION, remap=false)
    private void withdrawMediaWisp(int manaCost, boolean allowOvercast, CallbackInfoReturnable<Integer> cir) {
        if (manaCost <= 0) {
            cir.setReturnValue((Object)0);
            return;
        }
        IMixinCastingContext wispContext = (IMixinCastingContext)((CastingHarness)this).getCtx();
        BaseCastingWisp wisp = wispContext.getWisp();
        if (wisp != null) {
            int mediaAvailable = wisp.getMedia();
            HexalAPI.LOGGER.debug("charging wisp %s for casting".formatted(wisp.m_20149_()));
            HexalAPI.LOGGER.debug("mediaAvailable: %d".formatted(mediaAvailable));
            HexalAPI.LOGGER.debug("manaCost: %d".formatted(manaCost));
            int mediaToTake = Math.min(manaCost, mediaAvailable);
            wisp.addMedia(-mediaToTake);
            cir.setReturnValue((Object)(manaCost -= mediaToTake));
        }
    }

    @Inject(method={"executeIota"}, at={@At(value="HEAD")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION, remap=false)
    private void executeIotaMacro(Iota iota, ServerLevel world, CallbackInfoReturnable<ControllerInfo> cir) {
        boolean transmitting;
        List<Iota> toExecute;
        CastingContext ctx = this.harness.getCtx();
        if (ctx.getSpellCircle() != null || ((IMixinCastingContext)ctx).hasWisp()) {
            return;
        }
        if (!ctx.isCasterEnlightened() || this.harness.getEscapeNext()) {
            toExecute = new ArrayList<Iota>(Collections.singleton(iota));
        } else if (iota.getType() != HexIotaTypes.PATTERN || ((PatternIota)iota).getPattern().sigsEqual(HexPattern.fromAngles((String)"qqqaw", (HexDir)HexDir.EAST))) {
            toExecute = new ArrayList<Iota>(Collections.singleton(iota));
        } else {
            HexPattern pattern = ((PatternIota)iota).getPattern();
            toExecute = IXplatAbstractions.INSTANCE.getEverbookMacro(ctx.getCaster(), pattern);
            if (toExecute == null) {
                toExecute = new ArrayList<Iota>(Collections.singleton(iota));
            }
        }
        boolean isUnescapedEscape = !this.harness.getEscapeNext() && iota.getType() == HexIotaTypes.PATTERN && ((PatternIota)iota).getPattern().sigsEqual(HexPattern.fromAngles((String)"qqqaw", (HexDir)HexDir.EAST));
        ILinkable transmittingTo = IXplatAbstractions.INSTANCE.getPlayerTransmittingTo(ctx.getCaster());
        boolean bl = transmitting = transmittingTo != null;
        if (transmitting && !isUnescapedEscape) {
            Iterator<Iota> iter = toExecute.iterator();
            while (iter.hasNext()) {
                Iota it = iter.next();
                if (!this.harness.getEscapeNext() && iota.getType() == HexIotaTypes.PATTERN && Iota.tolerates((Iota)iota, (Iota)Patterns.LINK_COMM_CLOSE_TRANSMIT)) break;
                iter.remove();
                transmittingTo.receiveIota(IXplatAbstractions.INSTANCE.getLinkstore(ctx.getCaster()), it);
            }
            this.harness.setEscapeNext(false);
        }
        boolean wasTransmitting = transmitting;
        ControllerInfo ret = this.harness.executeIotas(toExecute, world);
        transmittingTo = IXplatAbstractions.INSTANCE.getPlayerTransmittingTo(ctx.getCaster());
        transmitting = transmittingTo != null;
        boolean isEdgeTransmit = transmitting ^ wasTransmitting;
        boolean isStackClear = ret.isStackClear() && !transmitting;
        ResolvedPatternType type2 = transmitting && !isUnescapedEscape && !isEdgeTransmit ? ResolvedPatternType.ESCAPED : ret.getResolutionType();
        List<CompoundTag> stack = transmitting ? transmittingTo.getAsActionResult().stream().map(HexIotaTypes::serialize).toList() : ret.getStack();
        List parenthesized = transmitting ? List.of() : ret.getParenthesized();
        CompoundTag ravenmind = transmitting ? null : ret.getRavenmind();
        int parenCount = transmitting ? 1 : ret.getParenCount();
        ret = ret.copy(isStackClear, type2, stack, parenthesized, ravenmind, parenCount);
        cir.setReturnValue((Object)ret);
    }
}

