/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.iota;

import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanIota
extends Iota {
    public static IotaType<BooleanIota> TYPE = new IotaType<BooleanIota>(){

        @Override
        @Nullable
        public BooleanIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            return BooleanIota.deserialize(tag);
        }

        @Override
        public Component display(Tag tag) {
            return BooleanIota.display(BooleanIota.deserialize(tag).getBool());
        }

        @Override
        public int color() {
            return -171;
        }
    };

    public BooleanIota(boolean d) {
        super(HexIotaTypes.BOOLEAN, d);
    }

    public boolean getBool() {
        return (Boolean)this.payload;
    }

    @Override
    public boolean isTruthy() {
        return this.getBool();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean toleratesOther(Iota that) {
        if (!BooleanIota.typesMatch(this, that)) return false;
        if (!(that instanceof BooleanIota)) return false;
        BooleanIota b = (BooleanIota)that;
        if (this.getBool() != b.getBool()) return false;
        return true;
    }

    @Override
    @NotNull
    public Tag serialize() {
        return ByteTag.m_128273_((boolean)this.getBool());
    }

    public static BooleanIota deserialize(Tag tag) throws IllegalArgumentException {
        ByteTag dtag = (ByteTag)HexUtils.downcast(tag, ByteTag.f_128255_);
        return new BooleanIota(dtag.m_7063_() != 0);
    }

    public static Component display(boolean b) {
        return Component.m_237115_((String)(b ? "hexcasting.tooltip.boolean_true" : "hexcasting.tooltip.boolean_false")).m_130940_(b ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED);
    }
}

