/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.iota;

import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.IotaType;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternIota
extends Iota {
    public static IotaType<PatternIota> TYPE = new IotaType<PatternIota>(){

        @Override
        @Nullable
        public PatternIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            return PatternIota.deserialize(tag);
        }

        @Override
        public Component display(Tag tag) {
            return PatternIota.display(PatternIota.deserialize(tag).getPattern());
        }

        @Override
        public int color() {
            return -22016;
        }
    };

    public PatternIota(@NotNull HexPattern pattern) {
        super(HexIotaTypes.PATTERN, pattern);
    }

    public HexPattern getPattern() {
        return (HexPattern)this.payload;
    }

    protected PatternIota(@NotNull IotaType<?> type, @NotNull Object payload) {
        super(type, payload);
    }

    @Override
    public boolean isTruthy() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean toleratesOther(Iota that) {
        if (!PatternIota.typesMatch(this, that)) return false;
        if (!(that instanceof PatternIota)) return false;
        PatternIota piota = (PatternIota)that;
        if (!this.getPattern().anglesSignature().equals(piota.getPattern().anglesSignature())) return false;
        return true;
    }

    @Override
    @NotNull
    public Tag serialize() {
        return this.getPattern().serializeToNBT();
    }

    public static PatternIota deserialize(Tag tag) throws IllegalArgumentException {
        CompoundTag patTag = (CompoundTag)HexUtils.downcast(tag, CompoundTag.f_128326_);
        HexPattern pat = HexPattern.fromNBT(patTag);
        return new PatternIota(pat);
    }

    public static Component display(HexPattern pat) {
        StringBuilder bob = new StringBuilder();
        bob.append((Object)pat.getStartDir());
        String sig = pat.anglesSignature();
        if (!sig.isEmpty()) {
            bob.append(" ");
            bob.append(sig);
        }
        return Component.m_237110_((String)"hexcasting.tooltip.pattern_iota", (Object[])new Object[]{Component.m_237113_((String)bob.toString()).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GOLD);
    }
}

