/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.mishaps;

import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.spell.Action;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.ResolvedPatternType;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.items.colorizer.ItemDyeColorizer;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.ktxt.AccessorWrappers;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 -2\u00020\u0001:\u0002-.B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0004J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J)\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017\"\u00020\u0018H\u0004\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH&J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&H\u0004J\u0018\u0010'\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)H\u0004J \u0010*\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020+2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010,\u001a\u00020)H\u0004\u00a8\u0006/"}, d2={"Lat/petrak/hexcasting/api/spell/mishaps/Mishap;", "", "()V", "accentColor", "Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "errorCtx", "Lat/petrak/hexcasting/api/spell/mishaps/Mishap$Context;", "actionName", "Lnet/minecraft/network/chat/Component;", "action", "Lat/petrak/hexcasting/api/spell/Action;", "blockAtPos", "pos", "Lnet/minecraft/core/BlockPos;", "dyeColor", "color", "Lnet/minecraft/world/item/DyeColor;", "error", "stub", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lnet/minecraft/network/chat/Component;", "errorMessage", "execute", "", "stack", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "particleSpray", "Lat/petrak/hexcasting/api/spell/ParticleSpray;", "resolutionType", "Lat/petrak/hexcasting/api/spell/casting/ResolvedPatternType;", "yeetHeldItem", "hand", "Lnet/minecraft/world/InteractionHand;", "yeetHeldItemsTowards", "targetPos", "Lnet/minecraft/world/phys/Vec3;", "yeetItem", "Lnet/minecraft/world/item/ItemStack;", "delta", "Companion", "Context", "hexcasting-forge-1.19.2"})
public abstract class Mishap
extends Throwable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract FrozenColorizer accentColor(@NotNull CastingContext var1, @NotNull Context var2);

    @NotNull
    public ParticleSpray particleSpray(@NotNull CastingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Vec3 vec3 = ctx.getPosition().m_82520_(0.0, 0.2, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ctx.position.add(0.0, 0.2, 0.0)");
        return new ParticleSpray(vec3, new Vec3(0.0, 2.0, 0.0), 0.2, 0.7853981633974483, 40);
    }

    @NotNull
    public ResolvedPatternType resolutionType(@NotNull CastingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return ResolvedPatternType.ERRORED;
    }

    public abstract void execute(@NotNull CastingContext var1, @NotNull Context var2, @NotNull List<Iota> var3);

    @NotNull
    public abstract Component errorMessage(@NotNull CastingContext var1, @NotNull Context var2);

    @NotNull
    protected final FrozenColorizer dyeColor(@NotNull DyeColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        ItemDyeColorizer itemDyeColorizer = HexItems.DYE_COLORIZERS.get(color);
        Intrinsics.checkNotNull((Object)itemDyeColorizer);
        return new FrozenColorizer(new ItemStack((ItemLike)itemDyeColorizer), Util.f_137441_);
    }

    @NotNull
    protected final Component error(@NotNull String stub, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return (Component)HexUtils.asTranslatedComponent("hexcasting.mishap." + stub, Arrays.copyOf(args, args.length));
    }

    @NotNull
    protected final Component actionName(@Nullable Action action) {
        Action action2 = action;
        if (action2 == null || (action2 = action2.getDisplayName()) == null) {
            action2 = (Component)HexUtils.getLightPurple(HexUtils.getAsTranslatedComponent("hexcasting.spell.null"));
        }
        return action2;
    }

    protected final void yeetHeldItemsTowards(@NotNull CastingContext ctx, @NotNull Vec3 targetPos) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
        List items = new ArrayList();
        for (InteractionHand hand : InteractionHand.values()) {
            if (hand == ctx.getCastingHand() && !ctx.getCaster().m_21120_(hand).m_204117_(HexTags.Items.STAVES)) continue;
            ItemStack itemStack = ctx.getCaster().m_21120_(hand).m_41777_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"ctx.caster.getItemInHand(hand).copy()");
            items.add(itemStack);
            ctx.getCaster().m_21008_(hand, ItemStack.f_41583_);
        }
        Vec3 delta = targetPos.m_82546_(ctx.getPosition()).m_82541_().m_82490_(0.5);
        for (ItemStack item : items) {
            Intrinsics.checkNotNullExpressionValue((Object)delta, (String)"delta");
            this.yeetItem(item, ctx, delta);
        }
    }

    protected final void yeetHeldItem(@NotNull CastingContext ctx, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack item = ctx.getCaster().m_21120_(hand).m_41777_();
        if (hand == ctx.getCastingHand() && IXplatAbstractions.INSTANCE.findHexHolder(item) != null) {
            return;
        }
        ctx.getCaster().m_21008_(hand, ItemStack.f_41583_);
        Vec3 delta = ctx.getCaster().m_20154_().m_82490_(0.5);
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
        Intrinsics.checkNotNullExpressionValue((Object)delta, (String)"delta");
        this.yeetItem(item, ctx, delta);
    }

    protected final void yeetItem(@NotNull ItemStack stack, @NotNull CastingContext ctx, @NotNull Vec3 delta) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        ItemEntity entity = new ItemEntity((Level)ctx.getWorld(), ctx.getPosition().f_82479_, ctx.getPosition().f_82480_, ctx.getPosition().f_82481_, stack, delta.f_82479_ + (Math.random() - 0.5) * 0.1, delta.f_82480_ + (Math.random() - 0.5) * 0.1, delta.f_82481_ + (Math.random() - 0.5) * 0.1);
        entity.m_32010_(40);
        ctx.getWorld().m_8847_((Entity)entity);
    }

    @NotNull
    protected final Component blockAtPos(@NotNull CastingContext ctx, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        MutableComponent mutableComponent = ctx.getWorld().m_8055_(pos).m_60734_().m_49954_();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"ctx.world.getBlockState(pos).block.name");
        return (Component)mutableComponent;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/api/spell/mishaps/Mishap$Context;", "", "pattern", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "action", "Lat/petrak/hexcasting/api/spell/Action;", "(Lat/petrak/hexcasting/api/spell/math/HexPattern;Lat/petrak/hexcasting/api/spell/Action;)V", "getAction", "()Lat/petrak/hexcasting/api/spell/Action;", "getPattern", "()Lat/petrak/hexcasting/api/spell/math/HexPattern;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "hexcasting-forge-1.19.2"})
    public static final class Context {
        @NotNull
        private final HexPattern pattern;
        @Nullable
        private final Action action;

        public Context(@NotNull HexPattern pattern, @Nullable Action action) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
            this.action = action;
        }

        @NotNull
        public final HexPattern getPattern() {
            return this.pattern;
        }

        @Nullable
        public final Action getAction() {
            return this.action;
        }

        @NotNull
        public final HexPattern component1() {
            return this.pattern;
        }

        @Nullable
        public final Action component2() {
            return this.action;
        }

        @NotNull
        public final Context copy(@NotNull HexPattern pattern, @Nullable Action action) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return new Context(pattern, action);
        }

        public static /* synthetic */ Context copy$default(Context context, HexPattern hexPattern, Action action, int n, Object object) {
            if ((n & 1) != 0) {
                hexPattern = context.pattern;
            }
            if ((n & 2) != 0) {
                action = context.action;
            }
            return context.copy(hexPattern, action);
        }

        @NotNull
        public String toString() {
            return "Context(pattern=" + this.pattern + ", action=" + this.action + ")";
        }

        public int hashCode() {
            int result = this.pattern.hashCode();
            result = result * 31 + (this.action == null ? 0 : this.action.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.pattern, (Object)context.pattern)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.action, (Object)context.action);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lat/petrak/hexcasting/api/spell/mishaps/Mishap$Companion;", "", "()V", "trulyHurt", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "hexcasting-forge-1.19.2"})
    public static final class Companion {
        private Companion() {
        }

        public final void trulyHurt(@NotNull LivingEntity entity, @NotNull DamageSource source, float amount) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            AccessorWrappers.setHurtWithStamp(entity, source, entity.f_19853_.m_46467_());
            float targetHealth = entity.m_21223_() - amount;
            if (entity.f_19802_ > 10) {
                float lastHurt = AccessorWrappers.getLastHurt(entity);
                if (lastHurt < amount) {
                    entity.f_19802_ = 0;
                } else {
                    AccessorWrappers.setLastHurt(entity, AccessorWrappers.getLastHurt(entity) - amount);
                }
            }
            if (!(entity.m_6469_(source, amount) || entity.m_6673_(source) || entity.f_19853_.f_46443_ || entity.m_21224_())) {
                entity.m_21153_(targetHealth);
                AccessorWrappers.markHurt((Entity)entity);
                if (entity.m_21224_()) {
                    if (!AccessorWrappers.checkTotemDeathProtection(entity, source)) {
                        SoundEvent sound = AccessorWrappers.getDeathSoundAccessor(entity);
                        if (sound != null) {
                            entity.m_5496_(sound, AccessorWrappers.getSoundVolumeAccessor(entity), entity.m_6100_());
                        }
                        entity.m_6667_(source);
                    }
                } else {
                    AccessorWrappers.playHurtSound(entity, source);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

