/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.NullIota;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemFocus
extends Item
implements IotaHolderItem {
    public static final ResourceLocation OVERLAY_PRED = HexAPI.modLoc("overlay_layer");
    public static final String TAG_DATA = "data";
    public static final String TAG_SEALED = "sealed";

    public ItemFocus(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    @Nullable
    public CompoundTag readIotaTag(ItemStack stack) {
        return NBTHelper.getCompound(stack, TAG_DATA);
    }

    public String m_5671_(ItemStack stack) {
        return super.m_5671_(stack) + (NBTHelper.getBoolean(stack, TAG_SEALED) ? ".sealed" : "");
    }

    @Override
    @Nullable
    public Iota emptyIota(ItemStack stack) {
        return new NullIota();
    }

    @Override
    public boolean canWrite(ItemStack stack, Iota datum) {
        return datum == null || !NBTHelper.getBoolean(stack, TAG_SEALED);
    }

    @Override
    public void writeDatum(ItemStack stack, Iota datum) {
        if (datum == null) {
            stack.m_41749_(TAG_DATA);
            stack.m_41749_(TAG_SEALED);
        } else if (!ItemFocus.isSealed(stack)) {
            NBTHelper.put(stack, TAG_DATA, (Tag)HexIotaTypes.serialize(datum));
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        IotaHolderItem.appendHoverText(this, pStack, pTooltipComponents, pIsAdvanced);
    }

    public static boolean isSealed(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_SEALED);
    }
}

