/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.misc.DiscoveryHandlers;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.network.MsgUpdateComparatorVisualsAck;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Wearable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemLens
extends Item
implements Wearable {
    private static final Map<ServerPlayer, Pair<BlockPos, Integer>> comparatorDataMap;
    private static final Map<ServerPlayer, Pair<BlockPos, Integer>> beeDataMap;

    public ItemLens(Item.Properties pProperties) {
        super(pProperties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            @NotNull
            protected ItemStack m_7498_(@NotNull BlockSource world, @NotNull ItemStack stack) {
                this.m_123573_(ArmorItem.m_40398_((BlockSource)world, (ItemStack)stack));
                return stack;
            }
        });
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public static void tickAllPlayers(ServerLevel world) {
        for (ServerPlayer player : world.m_6907_()) {
            ItemLens.tickLens((Entity)player);
        }
    }

    public static void tickLens(Entity pEntity) {
        ServerPlayer player;
        if (!pEntity.m_9236_().m_5776_() && pEntity instanceof ServerPlayer && DiscoveryHandlers.hasLens((Player)(player = (ServerPlayer)pEntity))) {
            ItemLens.sendComparatorDataToClient(player);
        }
    }

    private static void sendComparatorDataToClient(ServerPlayer player) {
        double reachAttribute = IXplatAbstractions.INSTANCE.getReachDistance((Player)player);
        double distance = player.m_7500_() ? reachAttribute : reachAttribute - 0.5;
        HitResult hitResult = player.m_19907_(distance, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockEntity blockEntity;
            BlockPos pos = ((BlockHitResult)hitResult).m_82425_();
            BlockState state = player.f_19853_.m_8055_(pos);
            int bee = -1;
            if (state.m_60734_() instanceof BeehiveBlock && (blockEntity = player.f_19853_.m_7702_(pos)) instanceof BeehiveBlockEntity) {
                BeehiveBlockEntity bees = (BeehiveBlockEntity)blockEntity;
                bee = bees.m_58776_();
            }
            if (state.m_60713_(Blocks.f_50328_)) {
                ItemLens.syncComparatorValue(player, pos, state.m_60775_((BlockGetter)player.f_19853_, pos, (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)), bee);
            } else if (state.m_60807_()) {
                ItemLens.syncComparatorValue(player, pos, state.m_60674_(player.f_19853_, pos), bee);
            } else {
                ItemLens.syncComparatorValue(player, null, -1, bee);
            }
        } else {
            ItemLens.syncComparatorValue(player, null, -1, -1);
        }
    }

    private static void syncComparatorValue(ServerPlayer player, BlockPos pos, int comparator, int bee) {
        Pair<BlockPos, Integer> previousComparator = comparatorDataMap.get(player);
        Pair<BlockPos, Integer> previousBee = beeDataMap.get(player);
        if (comparator == -1 && bee == -1) {
            if (previousComparator != null || previousBee != null) {
                comparatorDataMap.remove(player);
                beeDataMap.remove(player);
                IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgUpdateComparatorVisualsAck(null, -1, -1));
            }
        } else if (previousComparator == null || !pos.equals(previousComparator.getFirst()) || comparator != (Integer)previousComparator.getSecond() || previousBee == null || !pos.equals(previousBee.getFirst()) || bee != (Integer)previousBee.getSecond()) {
            comparatorDataMap.put(player, (Pair<BlockPos, Integer>)new Pair((Object)pos, (Object)comparator));
            beeDataMap.put(player, (Pair<BlockPos, Integer>)new Pair((Object)pos, (Object)bee));
            IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgUpdateComparatorVisualsAck(pos, comparator, bee));
        }
    }

    @Nullable
    public SoundEvent m_142602_() {
        return SoundEvents.f_144243_;
    }

    static {
        DiscoveryHandlers.addLensPredicate(player -> player.m_6844_(EquipmentSlot.MAINHAND).m_150930_((Item)HexItems.SCRYING_LENS));
        DiscoveryHandlers.addLensPredicate(player -> player.m_6844_(EquipmentSlot.OFFHAND).m_150930_((Item)HexItems.SCRYING_LENS));
        DiscoveryHandlers.addLensPredicate(player -> player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)HexItems.SCRYING_LENS));
        DiscoveryHandlers.addGridScaleModifier(player -> player.m_6844_(EquipmentSlot.MAINHAND).m_150930_((Item)HexItems.SCRYING_LENS) ? 0.75f : 1.0f);
        DiscoveryHandlers.addGridScaleModifier(player -> player.m_6844_(EquipmentSlot.OFFHAND).m_150930_((Item)HexItems.SCRYING_LENS) ? 0.75f : 1.0f);
        comparatorDataMap = new WeakHashMap<ServerPlayer, Pair<BlockPos, Integer>>();
        beeDataMap = new WeakHashMap<ServerPlayer, Pair<BlockPos, Integer>>();
    }
}

