/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public class CauldronParticleData
implements ParticleOptions {
    private Color tint;
    private double diameter;
    public static final Codec<CauldronParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tint").forGetter(d -> d.tint.getRGB()), (App)Codec.DOUBLE.fieldOf("diameter").forGetter(d -> d.diameter)).apply((Applicative)instance, CauldronParticleData::new));
    public static final ParticleOptions.Deserializer<CauldronParticleData> DESERIALIZER = new ParticleOptions.Deserializer<CauldronParticleData>(){

        @Nonnull
        public CauldronParticleData fromCommand(@Nonnull ParticleType<CauldronParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double diameter = CauldronParticleData.constrainDiameterToValidRange(reader.readDouble());
            boolean MIN_COLOUR = false;
            int MAX_COLOUR = 255;
            reader.expect(' ');
            int red = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int green = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int blue = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue);
            return new CauldronParticleData(color, diameter);
        }

        public CauldronParticleData fromNetwork(@Nonnull ParticleType<CauldronParticleData> type, FriendlyByteBuf buf) {
            boolean MIN_COLOUR = false;
            int MAX_COLOUR = 255;
            int red = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int green = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int blue = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue);
            double diameter = CauldronParticleData.constrainDiameterToValidRange(buf.readDouble());
            return new CauldronParticleData(color, diameter);
        }
    };

    public CauldronParticleData(Color tint, double diameter) {
        this.tint = tint;
        this.diameter = CauldronParticleData.constrainDiameterToValidRange(diameter);
    }

    public Color getTint() {
        return this.tint;
    }

    public double getDiameter() {
        return this.diameter;
    }

    @Nonnull
    public ParticleType<CauldronParticleData> m_6012_() {
        return ModParticleTypes.cauldronParticleType;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.tint.getRed());
        buf.writeInt(this.tint.getGreen());
        buf.writeInt(this.tint.getBlue());
        buf.writeDouble(this.diameter);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %i %i %i", this.m_6012_(), this.diameter, this.tint.getRed(), this.tint.getGreen(), this.tint.getBlue());
    }

    private static double constrainDiameterToValidRange(double diameter) {
        double MIN_DIAMETER = 0.05;
        double MAX_DIAMETER = 1.0;
        return Mth.m_14008_((double)diameter, (double)0.05, (double)1.0);
    }

    private CauldronParticleData(int tintRGB, double diameter) {
        this.tint = new Color(tintRGB);
        this.diameter = CauldronParticleData.constrainDiameterToValidRange(diameter);
    }
}

