/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.input;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.screens.Screen;
import org.anti_ad.mc.common.IInputHandler;
import org.anti_ad.mc.common.gui.debug.DebugInfos;
import org.anti_ad.mc.common.gui.screen.ConfigOptionHotkeyDialog;
import org.anti_ad.mc.common.gui.screen.ConfigScreenBase;
import org.anti_ad.mc.common.input.IKeybind;
import org.anti_ad.mc.common.input.KeybindSettings;
import org.anti_ad.mc.common.vanilla.Vanilla;
import org.anti_ad.mc.common.vanilla.VanillaUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001e\u001a\u00020\u000b2\n\u0010\u001f\u001a\u00020 \"\u00020\rJ\u0012\u0010!\u001a\u00020\u000b2\n\u0010\u001f\u001a\u00020 \"\u00020\rJ\u0012\u0010\"\u001a\u00020\u000b2\n\u0010\u001f\u001a\u00020 \"\u00020\rJ\b\u0010#\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0&2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,J\u001c\u0010-\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0&2\u0006\u0010'\u001a\u00020(J\u000e\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\rJ\b\u00100\u001a\u00020\u000bH\u0002J\u0018\u00101\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0002J6\u00101\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\r2\u0006\u00103\u001a\u00020\r2\u0006\u00102\u001a\u00020\r2\u0006\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020,J\u001e\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\r2\u0006\u00102\u001a\u00020\r2\u0006\u00109\u001a\u00020\rJ\u000e\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u001cJ\u000e\u0010<\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u001cJ\u0012\u0010=\u001a\u00020\u000b2\n\u0010\u001f\u001a\u00020 \"\u00020\rJ\u0012\u0010>\u001a\u00020\u000b2\n\u0010\u001f\u001a\u00020 \"\u00020\rJ\u000e\u0010?\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u001cJ\u000e\u0010@\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u001cR(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00182\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/anti_ad/mc/common/input/GlobalInputHandler;", "", "()V", "value", "Lorg/anti_ad/mc/common/input/IKeybind;", "currentAssigningKeybind", "getCurrentAssigningKeybind", "()Lorg/anti_ad/mc/common/input/IKeybind;", "setCurrentAssigningKeybind", "(Lorg/anti_ad/mc/common/input/IKeybind;)V", "ignoreLeftClick", "", "<set-?>", "", "lastAction", "getLastAction", "()I", "lastKey", "getLastKey", "pressedFirstKey", "pressedKeys", "", "getPressedKeys", "()Ljava/util/Set;", "", "previousPressedKeys", "getPreviousPressedKeys", "registered", "Lorg/anti_ad/mc/common/IInputHandler;", "registeredCancellable", "altAnd", "keyCodes", "", "arePressed", "ctrlAnd", "handleAssignKeybind", "", "isActivated", "", "settings", "Lorg/anti_ad/mc/common/input/KeybindSettings;", "isKeyDown", "keyCode", "window", "", "isPressing", "isWaitingForRelease", "key", "onInput", "onKey", "action", "scanCode", "modifiers", "checkPressing", "handle", "onMouseButton", "button", "mods", "register", "inputHandler", "registerCancellable", "shiftAnd", "superAnd", "unregister", "unregisterCancellable", "libIPN"})
@SourceDebugExtension(value={"SMAP\nGlobalInputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalInputHandler.kt\norg/anti_ad/mc/common/input/GlobalInputHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 kt_common.kt\norg/anti_ad/mc/common/extensions/Kt_commonKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1747#2,3:249\n1855#2,2:252\n1855#2:254\n1856#2:257\n130#3:255\n1#4:256\n*S KotlinDebug\n*F\n+ 1 GlobalInputHandler.kt\norg/anti_ad/mc/common/input/GlobalInputHandler\n*L\n109#1:249,3\n113#1:252,2\n183#1:254\n183#1:257\n184#1:255\n184#1:256\n*E\n"})
public final class GlobalInputHandler {
    @NotNull
    public static final GlobalInputHandler INSTANCE = new GlobalInputHandler();
    @NotNull
    private static final Set<Integer> pressedKeys = new LinkedHashSet();
    @NotNull
    private static Set<Integer> previousPressedKeys = CollectionsKt.toSet((Iterable)pressedKeys);
    private static int lastKey = -1;
    private static int lastAction = -1;
    @Nullable
    private static IKeybind currentAssigningKeybind;
    private static boolean pressedFirstKey;
    private static boolean ignoreLeftClick;
    @NotNull
    private static final Set<IInputHandler> registered;
    @NotNull
    private static final Set<IInputHandler> registeredCancellable;

    private GlobalInputHandler() {
    }

    @NotNull
    public final Set<Integer> getPressedKeys() {
        return pressedKeys;
    }

    @NotNull
    public final Set<Integer> getPreviousPressedKeys() {
        return previousPressedKeys;
    }

    public final int getLastKey() {
        return lastKey;
    }

    public final int getLastAction() {
        return lastAction;
    }

    public final boolean isWaitingForRelease(int key) {
        return pressedKeys.contains(key);
    }

    public final boolean isActivated(@NotNull List<Integer> keyCodes, @NotNull KeybindSettings settings) {
        Intrinsics.checkNotNullParameter(keyCodes, (String)"keyCodes");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (keyCodes.isEmpty()) {
            return false;
        }
        if (!settings.getActivateOn().isValid(lastAction)) {
            return false;
        }
        if (!VanillaUtil.INSTANCE.isValidScreen(settings.getContext())) {
            return false;
        }
        Set<Integer> validateKeys = lastAction == 1 ? pressedKeys : previousPressedKeys;
        return KeybindSettings.validates$default(settings, validateKeys, keyCodes, false, 4, null);
    }

    public final boolean isPressing(@NotNull List<Integer> keyCodes, @NotNull KeybindSettings settings) {
        Intrinsics.checkNotNullParameter(keyCodes, (String)"keyCodes");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (keyCodes.isEmpty()) {
            return false;
        }
        if (!VanillaUtil.INSTANCE.isValidScreen(settings.getContext())) {
            return false;
        }
        return settings.validates(pressedKeys, keyCodes, false);
    }

    private final boolean onKey(int key, int action) {
        boolean isPress;
        boolean bl = isPress = action == 1;
        if (isPress && pressedKeys.contains(key)) {
            return false;
        }
        previousPressedKeys = CollectionsKt.toSet((Iterable)pressedKeys);
        if (isPress) {
            pressedKeys.add(key);
        } else {
            pressedKeys.remove(key);
        }
        lastKey = key;
        lastAction = action;
        return this.onInput();
    }

    private final boolean onInput() {
        IInputHandler it;
        boolean bl;
        block9: {
            if (currentAssigningKeybind != null) {
                if (lastAction == 1) {
                    this.handleAssignKeybind();
                } else {
                    this.handleAssignKeybind();
                }
                return true;
            }
            Screen screen = Vanilla.INSTANCE.screen();
            if (screen != null && (screen instanceof ConfigScreenBase || screen instanceof ConfigOptionHotkeyDialog)) {
                return false;
            }
            Iterable $this$any$iv = registeredCancellable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (IInputHandler)element$iv;
                    boolean bl2 = false;
                    if (!it.onInput(lastKey, lastAction)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        Iterable $this$forEach$iv = registered;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IInputHandler)element$iv;
            boolean bl3 = false;
            it.onInput(lastKey, lastAction);
        }
        return false;
    }

    @Nullable
    public final IKeybind getCurrentAssigningKeybind() {
        return currentAssigningKeybind;
    }

    public final void setCurrentAssigningKeybind(@Nullable IKeybind value) {
        pressedFirstKey = false;
        ignoreLeftClick = true;
        currentAssigningKeybind = value;
    }

    private final void handleAssignKeybind() {
        List<Integer> pressedKeys;
        block14: {
            Object object;
            block13: {
                object = currentAssigningKeybind;
                if (object == null) break block13;
                IKeybind $this$handleAssignKeybind_u24lambda_u242 = object;
                boolean bl = false;
                List<Integer> list = $this$handleAssignKeybind_u24lambda_u242.getSettings().getModifierKey().handleKeys(CollectionsKt.toList((Iterable)GlobalInputHandler.pressedKeys));
                object = list;
                if (list != null) break block14;
            }
            object = pressedKeys = CollectionsKt.toList((Iterable)GlobalInputHandler.pressedKeys);
        }
        if (lastAction == 1) {
            if (lastKey == -100 && ignoreLeftClick) {
                return;
            }
            pressedFirstKey = true;
            if (lastKey == 256) {
                IKeybind iKeybind = currentAssigningKeybind;
                if (iKeybind != null) {
                    iKeybind.setKeyCodes(CollectionsKt.emptyList());
                }
                this.setCurrentAssigningKeybind(null);
            } else {
                IKeybind iKeybind = currentAssigningKeybind;
                if (iKeybind != null) {
                    iKeybind.setKeyCodes(pressedKeys);
                }
            }
        } else {
            if (lastKey == -100) {
                ignoreLeftClick = false;
            }
            if (pressedKeys.isEmpty() && pressedFirstKey) {
                this.setCurrentAssigningKeybind(null);
            }
        }
    }

    public final boolean isKeyDown(int keyCode, long window) {
        int keyCode2 = keyCode;
        if (keyCode2 >= 0) {
            return GLFW.glfwGetKey((long)window, (int)keyCode2) == 1;
        }
        return (keyCode2 += 100) >= 0 && GLFW.glfwGetMouseButton((long)window, (int)keyCode2) == 1;
    }

    public final boolean onKey(int key, int scanCode, int action, int modifiers, boolean checkPressing, long handle) {
        DebugInfos.INSTANCE.onKey(key, scanCode, action, modifiers);
        if (handle != 0L && checkPressing && !((Collection)pressedKeys).isEmpty()) {
            Set pressed = CollectionsKt.toSet((Iterable)pressedKeys);
            pressedKeys.clear();
            Iterable $this$forEach$iv = pressed;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                int it = ((Number)element$iv).intValue();
                boolean bl2 = false;
                boolean $this$ifTrue$iv = INSTANCE.isKeyDown(it, handle);
                boolean $i$f$ifTrue = false;
                boolean it$iv = bl = $this$ifTrue$iv;
                boolean bl3 = false;
                if (!$this$ifTrue$iv) continue;
                boolean bl4 = false;
                pressedKeys.add(it);
            }
        }
        return switch (action) {
            case 1 -> this.onKey(key, action);
            case 0 -> this.onKey(key, action);
            default -> false;
        };
    }

    public final boolean onMouseButton(int button2, int action, int mods) {
        DebugInfos.INSTANCE.onMouseButton(button2, action, mods);
        return switch (action) {
            case 0, 1 -> this.onKey(button2 >= 0 ? button2 - 100 : button2, action);
            default -> false;
        };
    }

    public final boolean shiftAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(340) || pressedKeys.contains(344)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean altAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(342) || pressedKeys.contains(346)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean ctrlAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(341) || pressedKeys.contains(345)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean superAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(343) || pressedKeys.contains(347)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean arePressed(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean register(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registered.add(inputHandler);
    }

    public final boolean unregister(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registered.remove(inputHandler);
    }

    public final boolean registerCancellable(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registeredCancellable.add(inputHandler);
    }

    public final boolean unregisterCancellable(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registeredCancellable.remove(inputHandler);
    }

    static {
        registered = new LinkedHashSet();
        registeredCancellable = new LinkedHashSet();
    }
}

