/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.event;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.item.LocoRouteItem;
import dev.murad.shipping.item.TugRouteItem;
import dev.murad.shipping.network.client.EntityPosition;
import dev.murad.shipping.network.client.VehicleTrackerPacketHandler;
import dev.murad.shipping.setup.EntityItemMap;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.LocoRoute;
import dev.murad.shipping.util.LocoRouteNode;
import dev.murad.shipping.util.RailHelper;
import dev.murad.shipping.util.TugRoute;
import dev.murad.shipping.util.TugRouteNode;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="littlelogistics", value={Dist.CLIENT})
public class ForgeClientEventHandler {
    public static final ResourceLocation BEAM_LOCATION = new ResourceLocation("littlelogistics", "textures/entity/beacon_beam.png");

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        if (!event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS)) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41720_().equals(ModItems.LOCO_ROUTE.get())) {
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            PoseStack pose = event.getPoseStack();
            Vec3 cameraOff = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            LocoRoute route = LocoRouteItem.getRoute(stack);
            List list = route.stream().map(LocoRouteNode::toBlockPos).collect(Collectors.toList());
            for (BlockPos block : list) {
                pose.m_85836_();
                pose.m_85837_((double)block.m_123341_() - cameraOff.f_82479_, 1.0 - cameraOff.f_82480_, (double)block.m_123343_() - cameraOff.f_82481_);
                BeaconRenderer.m_112184_((PoseStack)pose, (MultiBufferSource)buffer, (ResourceLocation)BEAM_LOCATION, (float)event.getPartialTick(), (float)1.0f, (long)player.f_19853_.m_46467_(), (int)(player.f_19853_.m_141937_() + 1), (int)1024, (float[])DyeColor.RED.m_41068_(), (float)0.0f, (float)0.25f);
                pose.m_85849_();
            }
            for (BlockPos block : list) {
                pose.m_85836_();
                RailShape shape = RailHelper.getRail(block, player.f_19853_).map(arg_0 -> ForgeClientEventHandler.lambda$onRenderWorldLast$0((Player)player, arg_0)).orElse(RailShape.EAST_WEST);
                double baseY = shape.m_156038_().contains("ascending") ? 0.1 : 0.0;
                double baseX = 0.0;
                double baseZ = 0.0;
                Runnable mulPose = () -> {};
                switch (shape) {
                    case ASCENDING_EAST: {
                        baseX = 0.2;
                        mulPose = () -> pose.m_85845_(Vector3f.f_122227_.m_122240_(45.0f));
                        break;
                    }
                    case ASCENDING_WEST: {
                        baseX = 0.1;
                        baseY += 0.7;
                        mulPose = () -> pose.m_85845_(Vector3f.f_122227_.m_122240_(-45.0f));
                        break;
                    }
                    case ASCENDING_NORTH: {
                        baseZ = 0.1;
                        baseY += 0.7;
                        mulPose = () -> pose.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                        break;
                    }
                    case ASCENDING_SOUTH: {
                        baseZ = 0.2;
                        mulPose = () -> pose.m_85845_(Vector3f.f_122223_.m_122240_(-45.0f));
                    }
                }
                pose.m_85837_((double)block.m_123341_() + baseX - cameraOff.f_82479_, (double)block.m_123342_() + baseY - cameraOff.f_82480_, (double)block.m_123343_() + baseZ - cameraOff.f_82481_);
                AABB a = new AABB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0).m_165897_(0.2, 0.0, 0.2);
                mulPose.run();
                LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)buffer.m_6299_(ModRenderType.LINES), (AABB)a, (float)1.0f, (float)0.3f, (float)0.3f, (float)0.5f);
                pose.m_85849_();
            }
            buffer.m_109911_();
        }
        if (stack.m_41720_().equals(ModItems.TUG_ROUTE.get())) {
            if (((Boolean)ShippingConfig.Client.DISABLE_TUG_ROUTE_BEACONS.get()).booleanValue()) {
                return;
            }
            Vec3 vector3d = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_();
            double d0 = vector3d.m_7096_();
            double d1 = vector3d.m_7098_();
            double d2 = vector3d.m_7094_();
            MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            TugRoute route = TugRouteItem.getRoute(stack);
            int routeSize = route.size();
            for (int i = 0; i < routeSize; ++i) {
                TugRouteNode node = (TugRouteNode)route.get(i);
                PoseStack matrixStack = event.getPoseStack();
                matrixStack.m_85836_();
                matrixStack.m_85837_(node.getX() - d0, 1.0 - d1, node.getZ() - d2);
                BeaconRenderer.m_112184_((PoseStack)matrixStack, (MultiBufferSource)renderTypeBuffer, (ResourceLocation)BEAM_LOCATION, (float)event.getPartialTick(), (float)1.0f, (long)player.f_19853_.m_46467_(), (int)player.f_19853_.m_141937_(), (int)1024, (float[])DyeColor.RED.m_41068_(), (float)0.2f, (float)0.25f);
                matrixStack.m_85849_();
                matrixStack.m_85836_();
                matrixStack.m_85837_(node.getX() - d0, player.m_20186_() + 2.0 - d1, node.getZ() - d2);
                matrixStack.m_85841_(-0.025f, -0.025f, -0.025f);
                matrixStack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
                Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
                Font fontRenderer = Minecraft.m_91087_().f_91062_;
                String text = node.getDisplayName(i);
                float width = (float)(-fontRenderer.m_92895_(text)) / 2.0f;
                fontRenderer.m_92811_(text, width, 0.0f, -1, true, matrix4f, (MultiBufferSource)renderTypeBuffer, true, 0, 0xF000F0);
                matrixStack.m_85849_();
            }
            renderTypeBuffer.m_109911_();
        }
        if (stack.m_41720_().equals(ModItems.CONDUCTORS_WRENCH.get()) && player.f_19853_.m_46472_().toString().equals(VehicleTrackerPacketHandler.toRenderDimension)) {
            MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            Camera camera = Minecraft.m_91087_().m_91290_().f_114358_;
            Vec3 cameraPosition = camera.m_90583_();
            double d0 = cameraPosition.m_7096_();
            double d1 = cameraPosition.m_7098_();
            double d2 = cameraPosition.m_7094_();
            for (EntityPosition position : VehicleTrackerPacketHandler.toRender) {
                double z;
                double y;
                double x;
                Entity entity = player.f_19853_.m_6815_(position.id());
                if (entity == null) {
                    x = position.pos().f_82479_;
                    y = position.pos().f_82480_;
                    z = position.pos().f_82481_;
                } else {
                    x = Mth.m_14139_((double)event.getPartialTick(), (double)entity.f_19790_, (double)entity.m_20185_());
                    y = Mth.m_14139_((double)event.getPartialTick(), (double)entity.f_19791_, (double)entity.m_20186_());
                    z = Mth.m_14139_((double)event.getPartialTick(), (double)entity.f_19792_, (double)entity.m_20189_());
                }
                Vec3 posToRender = ForgeClientEventHandler.computeFixedDistance(new Vec3(x, y, z), cameraPosition);
                PoseStack matrixStack = event.getPoseStack();
                matrixStack.m_85836_();
                matrixStack.m_85837_(posToRender.f_82479_ - d0, posToRender.f_82480_ - d1, posToRender.f_82481_ - d2);
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-camera.m_90590_()));
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
                Minecraft.m_91087_().m_91291_().m_174269_(new ItemStack((ItemLike)EntityItemMap.get(position.type())), ItemTransforms.TransformType.GROUND, 150, OverlayTexture.f_118083_, matrixStack, (MultiBufferSource)renderTypeBuffer, position.id());
                matrixStack.m_85841_(-0.025f, -0.025f, -0.025f);
                Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
                Font fontRenderer = Minecraft.m_91087_().f_91062_;
                String text = String.valueOf((double)Math.round(position.pos().m_82554_(player.m_20182_()) * 10.0) / 10.0);
                float width = (float)(-fontRenderer.m_92895_(text)) / 2.0f;
                fontRenderer.m_92811_(text, width, 0.0f, -1, true, matrix4f, (MultiBufferSource)renderTypeBuffer, true, 0, 0xF000F0);
                matrixStack.m_85849_();
            }
            renderTypeBuffer.m_109911_();
        }
    }

    private static Vec3 computeFixedDistance(Vec3 target, Vec3 position) {
        Vec3 delta = position.m_82505_(target = target.m_82520_(0.0, 2.0, 0.0));
        if (delta.m_82553_() < 5.0) {
            return target;
        }
        return position.m_82549_(delta.m_82541_().m_82490_(5.0));
    }

    private static /* synthetic */ RailShape lambda$onRenderWorldLast$0(Player player, BlockPos pos) {
        return RailHelper.getShape(pos, player.f_19853_);
    }

    public static class ModRenderType
    extends RenderType {
        public static final RenderType LINES = ModRenderType.m_173215_((String)"lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(f_110119_).m_110663_(RenderStateShard.f_110111_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));

        public ModRenderType(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
            super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
        }
    }
}

