/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.global;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.global.TrainChunkManagerManager;
import dev.murad.shipping.network.client.EntityPosition;
import dev.murad.shipping.network.client.VehicleTrackerClientPacket;
import dev.murad.shipping.network.client.VehicleTrackerPacketHandler;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.LinkableEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class PlayerTrainChunkManager
extends SavedData {
    private static final TicketType<UUID> TRAVEL_TICKET = TicketType.m_9462_((String)"littlelogistics:travelticket", UUID::compareTo);
    private static final TicketType<UUID> LOAD_TICKET = TicketType.m_9465_((String)"littlelogistics:loadticket", UUID::compareTo, (int)500);
    private final Set<Entity> enrolled = new HashSet<Entity>();
    private final Set<ChunkPos> tickets = new HashSet<ChunkPos>();
    private final Set<ChunkPos> toLoad = new HashSet<ChunkPos>();
    private final int loadLevel = (Integer)ShippingConfig.Server.CHUNK_LOADING_LEVEL.get();
    private boolean changed = false;
    private boolean active = false;
    private int numVehicles = 0;
    private final UUID uuid;
    private final ServerLevel level;

    public static PlayerTrainChunkManager get(ServerLevel level, UUID uuid) {
        DimensionDataStorage storage = level.m_8895_();
        return (PlayerTrainChunkManager)storage.m_164861_(tag -> new PlayerTrainChunkManager((CompoundTag)tag, level, uuid), () -> new PlayerTrainChunkManager(level, uuid), "littlelogistics:chunkmanager-" + uuid.toString());
    }

    public static Optional<PlayerTrainChunkManager> getSaved(ServerLevel level, UUID uuid) {
        DimensionDataStorage storage = level.m_8895_();
        return Optional.ofNullable((PlayerTrainChunkManager)storage.m_164858_(tag -> new PlayerTrainChunkManager((CompoundTag)tag, level, uuid), "littlelogistics:chunkmanager-" + uuid.toString()));
    }

    public static boolean enroll(Entity entity, UUID uuid) {
        if (!entity.f_19853_.f_46443_) {
            PlayerTrainChunkManager manager = PlayerTrainChunkManager.get((ServerLevel)entity.f_19853_, uuid);
            if (!manager.active) {
                return false;
            }
            manager.enrolled.add(entity);
            manager.changed = true;
            return true;
        }
        return false;
    }

    public static boolean enrollIfAllowed(Entity entity, UUID uuid) {
        if (!entity.f_19853_.f_46443_) {
            PlayerTrainChunkManager manager = PlayerTrainChunkManager.get((ServerLevel)entity.f_19853_, uuid);
            Player player = manager.level.m_46003_(uuid);
            if (player == null) {
                return false;
            }
            int max = (Integer)ShippingConfig.Server.MAX_REGISTRERED_VEHICLES_PER_PLAYER.get();
            int registered = TrainChunkManagerManager.get(manager.level.m_7654_()).countVehicles(uuid) + 1;
            if (registered > max) {
                player.m_213846_((Component)Component.m_237110_((String)"global.littlelogistics.locomotive.register_success", (Object[])new Object[]{max}));
                return false;
            }
            player.m_213846_((Component)Component.m_237110_((String)"global.littlelogistics.locomotive.register_fail", (Object[])new Object[]{registered, max}));
            manager.enrolled.add(entity);
            manager.changed = true;
            return true;
        }
        return false;
    }

    public void deactivate() {
        this.updateToLoad();
        this.numVehicles = this.enrolled.size();
        this.enrolled.clear();
        this.tickets.forEach(chunkPos -> this.level.m_7726_().m_8438_(TRAVEL_TICKET, chunkPos, this.loadLevel, (Object)this.uuid));
        this.tickets.clear();
        this.active = false;
    }

    public void activate() {
        this.active = true;
        this.level.m_7654_().execute(() -> this.toLoad.forEach(chunkPos -> this.level.m_7726_().m_8387_(LOAD_TICKET, chunkPos, 2, (Object)this.uuid)));
    }

    private List<Entity> getAllSubjectEntities(Entity entity) {
        ArrayList<Entity> subjects = new ArrayList<Entity>();
        subjects.add(entity);
        if (entity instanceof LinkableEntity) {
            LinkableEntity l = (LinkableEntity)entity;
            for (LinkableEntity e : l.getTrain().asListOfTugged()) {
                if (!(e instanceof Entity)) continue;
                Entity entity1 = (Entity)e;
                subjects.add(entity1);
                subjects.addAll(entity1.m_20197_());
            }
        }
        if (entity.getParts() != null) {
            subjects.addAll(List.of(entity.getParts()));
        }
        return subjects;
    }

    private void updateToLoad() {
        this.toLoad.clear();
        this.enrolled.forEach(e -> this.toLoad.addAll(this.getAllSubjectEntities((Entity)e).stream().map(Entity::m_146902_).collect(Collectors.toSet())));
    }

    public void tick() {
        ServerPlayer serverPlayer;
        boolean changed = this.enrolled.removeIf(e -> !e.m_6084_());
        if (!this.active) {
            return;
        }
        this.enrolled.forEach(entityHead -> this.getAllSubjectEntities((Entity)entityHead).stream().filter(entity -> !((ServerLevel)entity.f_19853_).m_143340_(entity.m_20183_())).forEach(Entity::m_8119_));
        Player player = this.level.m_46003_(this.uuid);
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_21120_(InteractionHand.MAIN_HAND).m_41720_().equals(ModItems.CONDUCTORS_WRENCH.get())) {
            VehicleTrackerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)VehicleTrackerClientPacket.of(this.getEntityPositions(), this.level.m_46472_().toString()));
        }
        if (this.changed || changed || this.enrolled.stream().map(e -> !e.m_146902_().equals((Object)new ChunkPos(new BlockPos(e.f_19790_, e.f_19791_, e.f_19792_)))).reduce(Boolean.FALSE, Boolean::logicalOr).booleanValue()) {
            this.changed = false;
            this.level.m_7654_().execute(this::onChanged);
        }
    }

    public List<EntityPosition> getEntityPositions() {
        return this.enrolled.stream().map(entity -> new EntityPosition(entity.m_6095_().toString(), entity.m_19879_(), entity.m_20182_(), new Vec3(entity.f_19790_, entity.f_19791_, entity.f_19792_))).collect(Collectors.toList());
    }

    private void onChanged() {
        HashSet<ChunkPos> required = new HashSet<ChunkPos>();
        this.numVehicles = this.enrolled.size();
        if (((Boolean)ShippingConfig.Server.DISABLE_CHUNK_MANAGEMENT.get()).booleanValue()) {
            this.removeUnneededTickets(required);
            return;
        }
        this.enrolled.stream().map(this::computeRequiredTickets).forEach(required::addAll);
        this.removeUnneededTickets(required);
        this.addNeededTickets(required);
        this.updateToLoad();
        this.m_77762_();
    }

    private Set<ChunkPos> computeRequiredTickets(Entity entity) {
        HashSet<ChunkPos> set = new HashSet<ChunkPos>();
        this.getAllSubjectEntities(entity).stream().map(Entity::m_146902_).map(pos -> ChunkPos.m_45596_((ChunkPos)pos, (int)1)).forEach(pos -> set.addAll(pos.collect(Collectors.toList())));
        return set;
    }

    private void removeUnneededTickets(Set<ChunkPos> required) {
        Set.copyOf(this.tickets).stream().filter(pos -> !required.contains(pos)).forEach(chunkPos -> {
            this.level.m_7726_().m_8438_(TRAVEL_TICKET, chunkPos, this.loadLevel, (Object)this.uuid);
            this.tickets.remove(chunkPos);
        });
    }

    private void addNeededTickets(Set<ChunkPos> required) {
        required.stream().filter(pos -> !this.tickets.contains(pos)).collect(Collectors.toSet()).forEach(chunkPos -> {
            this.level.m_7726_().m_8387_(TRAVEL_TICKET, chunkPos, this.loadLevel, (Object)this.uuid);
            this.tickets.add((ChunkPos)chunkPos);
        });
    }

    PlayerTrainChunkManager(ServerLevel level, UUID uuid) {
        this.level = level;
        this.uuid = uuid;
        TrainChunkManagerManager.get(level.m_7654_()).enroll(this);
        this.active = true;
        this.m_77762_();
    }

    PlayerTrainChunkManager(CompoundTag tag, ServerLevel level, UUID uuid) {
        this.level = level;
        this.uuid = uuid;
        this.numVehicles = tag.m_128451_("numVehicles");
        Arrays.stream(tag.m_128467_("chunksToLoad")).forEach(chunk -> this.toLoad.add(new ChunkPos(chunk)));
        if (((Boolean)ShippingConfig.Server.OFFLINE_LOADING.get()).booleanValue()) {
            this.activate();
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("numVehicles", this.numVehicles);
        tag.m_128428_("chunksToLoad", this.toLoad.stream().map(ChunkPos::m_45588_).collect(Collectors.toList()));
        return tag;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getNumVehicles() {
        return this.numVehicles;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public ServerLevel getLevel() {
        return this.level;
    }
}

