/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.global;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import dev.murad.shipping.global.PlayerTrainChunkManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class TrainChunkManagerManager
extends SavedData {
    private final Table<ResourceKey<Level>, UUID, PlayerTrainChunkManager> managers = TreeBasedTable.create();
    MinecraftServer server;

    public static TrainChunkManagerManager get(MinecraftServer server) {
        return (TrainChunkManagerManager)server.m_129783_().m_8895_().m_164861_(tag -> new TrainChunkManagerManager((CompoundTag)tag, server), () -> new TrainChunkManagerManager(server), "littlelogistics:trainchunkmanagermanager");
    }

    private TrainChunkManagerManager(MinecraftServer server) {
        this.server = server;
    }

    private TrainChunkManagerManager(CompoundTag tag, MinecraftServer server) {
        this.server = server;
        for (Tag cell : tag.m_128437_("saved", 10)) {
            if (!(cell instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)cell;
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compoundTag.m_128461_("level")));
            ServerLevel level = server.m_129880_(dimension);
            if (level == null) {
                return;
            }
            UUID uuid = compoundTag.m_128342_("UUID");
            server.execute(() -> PlayerTrainChunkManager.getSaved(level, uuid).ifPresent(manager -> this.managers.put((Object)dimension, (Object)uuid, (Object)manager)));
        }
    }

    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        ListTag topList = new ListTag();
        for (Table.Cell cell : this.managers.cellSet()) {
            CompoundTag inner = new CompoundTag();
            inner.m_128359_("level", ((ResourceKey)cell.getRowKey()).m_135782_().toString());
            inner.m_128362_("UUID", (UUID)cell.getColumnKey());
            topList.add((Object)inner);
        }
        tag.m_128365_("saved", (Tag)topList);
        return tag;
    }

    public void enroll(PlayerTrainChunkManager playerTrainChunkManager) {
        this.managers.put((Object)playerTrainChunkManager.getLevel().m_46472_(), (Object)playerTrainChunkManager.getUuid(), (Object)playerTrainChunkManager);
        this.m_77762_();
    }

    public Set<PlayerTrainChunkManager> getManagers(ResourceKey<Level> dimension) {
        return new HashSet<PlayerTrainChunkManager>(this.managers.row(dimension).values());
    }

    public Set<PlayerTrainChunkManager> getManagers(UUID uuid) {
        return new HashSet<PlayerTrainChunkManager>(this.managers.column((Object)uuid).values());
    }

    public int countVehicles(UUID uuid) {
        return this.getManagers(uuid).stream().reduce(0, (i, manager) -> i + manager.getNumVehicles(), Integer::sum);
    }
}

