/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import dev.murad.shipping.entity.custom.vessel.tug.AbstractTugEntity;
import dev.murad.shipping.util.LinkableEntity;
import java.util.Arrays;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class SpringPhysicsUtil {
    public static float computeTargetYaw(Float currentYaw, Vec3 anchorPos, Vec3 otherAnchorPos) {
        float idealYaw = (float)(Math.atan2(otherAnchorPos.f_82479_ - anchorPos.f_82479_, -(otherAnchorPos.f_82481_ - anchorPos.f_82481_)) * 57.29577951308232);
        float closestDistance = Float.POSITIVE_INFINITY;
        float closest = idealYaw;
        for (int sign : Arrays.asList(-1, 0, 1)) {
            float potentialYaw = idealYaw + (float)sign * 360.0f;
            float distance = Math.abs(potentialYaw - currentYaw.floatValue());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closest = potentialYaw;
        }
        return closest;
    }

    public static <T extends Entity> void adjustSpringedEntities(T dominant, T dominated) {
        if (dominated.m_20270_(dominant) > 20.0f) {
            ((LinkableEntity)dominated).removeDominant();
        }
        double distSq = dominant.m_20280_(dominated);
        double maxDstSq = ((LinkableEntity)dominant).getTrain().getTug().map(tug -> ((AbstractTugEntity)tug).isDocked() ? 1.0 : 1.2).orElse(1.2);
        Vec3 frontAnchor = dominant.m_20182_();
        Vec3 backAnchor = dominated.m_20182_();
        double dist = Math.sqrt(distSq);
        double dx = (frontAnchor.f_82479_ - backAnchor.f_82479_) / dist;
        double dy = (frontAnchor.f_82480_ - backAnchor.f_82480_) / dist;
        double dz = (frontAnchor.f_82481_ - backAnchor.f_82481_) / dist;
        double alpha = 0.5;
        float targetYaw = SpringPhysicsUtil.computeTargetYaw(Float.valueOf(dominated.m_146908_()), frontAnchor, backAnchor);
        dominated.m_146922_((float)((0.5 * (double)dominated.m_146908_() + (double)targetYaw * 0.5) % 360.0));
        double k = dominant instanceof AbstractTugEntity ? 0.3 : 0.4;
        double l0 = maxDstSq;
        dominated.m_20334_(k * (dist - l0) * dx, k * (dist - l0) * dy, k * (dist - l0) * dz);
    }
}

